/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.swingui.editor.storage.udb.BufferPoolPropertyDialogUDB;

public class BufferPoolUDB
extends AbstractStorageObjectDB2 {
    private static Object[] availablePageSizes = new Object[]{new Integer(4), new Integer(8), new Integer(16), new Integer(32)};
    private String scope = "";
    private InlineScopeList scopeSet = null;
    private int size = 1024;
    private String nodesWithDiffSize = "";
    private int pageSize = 4;
    private boolean useExtendedStorage = false;
    public static final String TYPE_NAME = "Bufferpool";

    @Override
    public String getIDPrefix() {
        return "BP";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateScopeSet(string);
        } else {
            this.addScope(string);
        }
        this.scope = this.getScopeSet().toString();
        this.fireDataFieldChange();
    }

    private void addScope(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getScopeSet().contains(string2)) {
            this.getScopeSet().add(string2);
        }
    }

    public void recreateScopeSet(String string) {
        this.getScopeSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getScopeSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setNodesWithDiffSize(String string) {
        this.nodesWithDiffSize = string;
    }

    public String getNodesWithDiffSize() {
        return this.nodesWithDiffSize;
    }

    public static Object[] getAvailablePageSizes() {
        return availablePageSizes;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setExtendedStorage(boolean bl) {
        this.useExtendedStorage = bl;
    }

    public boolean getExtendedStorage() {
        return this.useExtendedStorage;
    }

    public boolean isSystemBufferPool() {
        return false;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BufferPoolPropertyDialogUDB bufferPoolPropertyDialogUDB = new BufferPoolPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            bufferPoolPropertyDialogUDB.show();
        }
    }

    public InlineScopeList getScopeSet() {
        if (this.scopeSet == null) {
            this.scopeSet = new InlineScopeList();
        }
        return this.scopeSet;
    }

    public void clear() {
        this.getScopeSet().removeAllElements();
        this.scope = "";
    }

    public class InlineScopeList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

