/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.AliasPropertyDialogUDB;

public class AliasUDB
extends AbstractStorageObjectDB2 {
    private StorageObject referencedObject;
    private SchemaUDB schema = null;
    public static final String TYPE_NAME = "Alias";

    @Override
    public String getIDPrefix() {
        return "AL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    protected boolean checkReferencedObject(StorageObject storageObject) {
        if (storageObject instanceof TableProxyUDB) {
            return true;
        }
        if (storageObject instanceof TableViewProxyUDB) {
            return true;
        }
        return storageObject instanceof AliasUDB && (AliasUDB)storageObject != this;
    }

    public boolean isAliasReference() {
        return this.getReferencedObject() instanceof AliasUDB;
    }

    public boolean isTableProxyReference() {
        return this.referencedObject instanceof TableProxyUDB;
    }

    public boolean isTableViewProxyReference() {
        return this.referencedObject instanceof TableViewProxyUDB;
    }

    public void setReferencedObject(StorageObject storageObject) {
        if (this.checkReferencedObject(storageObject)) {
            this.referencedObject = storageObject;
            this.fireDataFieldChange();
        }
    }

    public StorageObject getReferencedObject() {
        return this.referencedObject;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getSchema() != null) {
            string = this.getSchema().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AliasPropertyDialogUDB aliasPropertyDialogUDB = new AliasPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            aliasPropertyDialogUDB.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ALIAS_ICON", 16);
    }
}

