/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.ViewPropertyDialogSqlServerv2k5;

public class TableViewProxySqlServerv2k5
extends TableViewProxySqlServer {
    public TableViewProxySqlServerv2k5(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
        this.synonyms = new StorageObjectCollection(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(TableViewProxySqlServer.class);
        this.synonyms.setSetMethod("setView");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
    }

    public TableViewProxySqlServerv2k5(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ViewPropertyDialogSqlServerv2k5 viewPropertyDialogSqlServerv2k5 = new ViewPropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            viewPropertyDialogSqlServerv2k5.show();
        }
    }

    private void addSynonymsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)iterator.next();
            if (synonymSqlServer.getView() == this) {
                synonymSqlServer.setParent(this.synonyms);
                this.synonyms.add(synonymSqlServer);
                continue;
            }
            this.synonyms.remove(synonymSqlServer);
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymSqlServer createSynonym() {
        if (this.synonyms.getStorageObjectSet() != null) {
            return (SynonymSqlServer)this.synonyms.createElement(null);
        }
        return null;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 1) {
            return this.synonyms;
        }
        return super.getChild(n);
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.synonyms) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.synonyms) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.synonyms.removeAll();
    }

    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
                SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
                synonymSqlServer.addObjectListener(this);
                if (synonymSqlServer.getView() == this) {
                    synonymSqlServer.setParent(this.synonyms);
                    this.synonyms.add(synonymSqlServer);
                } else {
                    this.synonyms.remove(synonymSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
            this.synonyms.remove(synonymSqlServer);
            synonymSqlServer.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(storageObject, objectChangeEvent);
        if (objectChangeEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)objectChangeEvent.getAffected();
            if (synonymSqlServer.getView() == this) {
                synonymSqlServer.setParent(this.synonyms);
                this.synonyms.add(synonymSqlServer);
            } else {
                this.synonyms.remove(synonymSqlServer);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        super.changed(modelObjectSet, modelObjectSetEvent);
        if (modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
            synonymSqlServer.addObjectListener(this);
            if (synonymSqlServer.getView() == this) {
                synonymSqlServer.setParent(this.synonyms);
                this.synonyms.add(synonymSqlServer);
            } else {
                this.synonyms.remove(synonymSqlServer);
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)modelObjectSetEvent.getAffected();
            synonymSqlServer.removeObjectListener(this);
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TableView tableView = (TableView)storageDesign.getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxySqlServerv2k5 tableViewProxySqlServerv2k5 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignSqlServerv2k5)storageDesign).getTableViewProxySet().getProxy(tableView.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableViewProxySqlServerv2k5 = (TableViewProxySqlServerv2k5)relationalObjectProxy;
        }
        if (tableViewProxySqlServerv2k5 != null) {
            StorageObject storageObject;
            StorageObject storageObject2;
            StorageObject storageObject3;
            tableViewProxySqlServerv2k5.setName(this.getName());
            Iterator iterator = this.getIndexesOnView().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (IndexOnViewSqlServerv2k5)iterator.next();
                storageObject2 = (IndexOnViewSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getIndexOnViewSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (IndexOnViewSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getIndexOnViewSet().createIndexOnView();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((IndexOnViewSqlServer)storageObject).setView(tableViewProxySqlServerv2k5);
                    tableViewProxySqlServerv2k5.addIndexesFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getIndexOnViewSet());
                    continue;
                }
                ((IndexOnViewSqlServer)storageObject2).setView(tableViewProxySqlServerv2k5);
                tableViewProxySqlServerv2k5.addIndexesFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getIndexOnViewSet());
            }
            iterator = this.getTriggers().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TriggerSqlServerv2k5)iterator.next();
                storageObject2 = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet().createTrigger();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((TriggerSqlServer)storageObject).setView(tableViewProxySqlServerv2k5);
                    tableViewProxySqlServerv2k5.addTriggersFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet());
                    continue;
                }
                ((TriggerSqlServer)storageObject2).setView(tableViewProxySqlServerv2k5);
                tableViewProxySqlServerv2k5.addTriggersFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getTriggerSet());
            }
            iterator = this.synonyms.iterator();
            while (iterator.hasNext()) {
                storageObject3 = (SynonymSqlServer)iterator.next();
                storageObject2 = (SynonymSqlServer)((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = ((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().createSynonym();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((SynonymSqlServer)storageObject).setView(tableViewProxySqlServerv2k5);
                    tableViewProxySqlServerv2k5.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
                    continue;
                }
                ((SynonymSqlServer)storageObject2).setView(tableViewProxySqlServerv2k5);
                tableViewProxySqlServerv2k5.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
            }
            if (this.getDataBase() != null) {
                storageObject3 = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().getByName(this.getDataBase().getName());
                if (storageObject3 == null) {
                    storageObject2 = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getDataBaseSet().createDataBase();
                    storageObject2.setName(this.getDataBase().getName());
                    storageObject2.setRawObject(true);
                    tableViewProxySqlServerv2k5.setDataBase((DataBaseSqlServer)storageObject2);
                } else {
                    tableViewProxySqlServerv2k5.setDataBase((DataBaseSqlServer)storageObject3);
                }
            }
            if (this.getSchema() != null) {
                storageObject3 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)storageDesign).getSchemaSet().createSchema();
                    storageObject2.setName(this.getSchema().getName());
                    storageObject2.setRawObject(true);
                    tableViewProxySqlServerv2k5.setSchema((SchemaSqlServer)storageObject2);
                } else {
                    tableViewProxySqlServerv2k5.setSchema((SchemaSqlServer)storageObject3);
                }
            }
            tableViewProxySqlServerv2k5.setCheckOption(this.getCheckOption());
            tableViewProxySqlServerv2k5.setEncryption(this.getEncryption());
            tableViewProxySqlServerv2k5.setSchemaBinding(this.getSchemaBinding());
            tableViewProxySqlServerv2k5.setViewMetaData(this.getViewMetaData());
            tableViewProxySqlServerv2k5.setDefinition(this.getDefinition());
            tableViewProxySqlServerv2k5.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            tableViewProxySqlServerv2k5.setComment(this.getComment());
            tableViewProxySqlServerv2k5.setCommentInRDBMS(this.getCommentInRDBMS());
            tableViewProxySqlServerv2k5.setRawObject(false);
        }
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((StorageDesignSqlServer)this.getStorageDesign()).getSchemaSet().getBySchemaObject(schemaObject);
            if (storageObject != null) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }
}

