/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;

public class IndexProxySetSqlServerv2k5
extends IndexProxySetSqlServer
implements Constants {
    public IndexProxySetSqlServerv2k5(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && !((KeyObject)designObject).isPK() && !((KeyObject)designObject).isFK() && !((Index)designObject).getIndexState().equalsIgnoreCase("Unique Constraint")) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            try {
                this.add(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in IndexProxySetSqlServerv2k5.add");
            }
            this.fireUpdate();
        }
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new IndexProxySqlServerv2k5((Index)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new IndexProxySqlServerv2k5(design, string, string2, this.getStorageDesign());
    }
}

