/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class UserSqlServer
extends AbstractStorageObjectSqlServer {
    private DataBaseSqlServer database;
    private LoginSqlServer login;
    private static final String[] PRIVILEGES = new String[]{"ALL", "CREATE DEFAULT", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE RULE", "CREATE TABLE", "CREATE VIEW", "BACKUP DATABASE", "BACKUP LOG"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String systemPrivileges = "";
    private InlineList systemPrivilegesSet = null;
    public static final String TYPE_NAME = "User";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "U";
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public LoginSqlServer getLogin() {
        return this.login;
    }

    public void setLogin(LoginSqlServer loginSqlServer) {
        this.login = loginSqlServer;
        this.fireDataFieldChange();
    }

    @Override
    public boolean canDeleteInGUI() {
        return false;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    private void addPrivilege(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
        }
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.systemPrivilegesSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!this.checkPrivileges(string2)) continue;
            this.getPrivilegesSet().add(string2);
        }
    }

    protected boolean checkPrivileges(String string) {
        return PRIVILEGESLIST.contains(string);
    }

    public void setSystemPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else if (this.checkPrivileges(string)) {
            this.addPrivilege(string);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public List getPermissions() {
        ArrayList<PermissionsSqlServer> arrayList = new ArrayList<PermissionsSqlServer>();
        Iterator iterator = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != this || permissionsSqlServer.getTable() == null && permissionsSqlServer.getView() == null) continue;
            arrayList.add(permissionsSqlServer);
        }
        return arrayList;
    }

    public PermissionsSqlServer createPermission() {
        PermissionsSqlServer permissionsSqlServer = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permissionsSqlServer.setUser(this);
        return permissionsSqlServer;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

