/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UsedUDDTPropertyDialog;

public class UsedUserDefinedData
extends AbstractStorageObjectSqlServer
implements RelationalObjectProxySetListener {
    protected SchemaSqlServer schema;
    protected DistinctTypeProxySqlServer distinctTypeProxy;
    protected DefaultSqlServer defaultObject;
    protected RuleSqlServer ruleObject;
    protected String comments;
    protected String commentsInRDBMS;
    protected UserDefinedTypeSqlServer userDefinedType;
    protected DataBaseSqlServer database;
    private String props = "";
    private InlineList extPropsSet = null;
    public static final String TYPE_NAME = "UUDD";
    public static final String OLD_TYPE_NAME = "UsedUserDefinedData";

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getCommentsInRDBMS() {
        return this.commentsInRDBMS;
    }

    public void setCommentsInRDBMS(String string) {
        this.commentsInRDBMS = string;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer;
        this.setPAC_Element(dataBaseSqlServer);
    }

    public DefaultSqlServer getDefaultObject() {
        return this.defaultObject;
    }

    public void setDefaultObject(DefaultSqlServer defaultSqlServer) {
        this.defaultObject = defaultSqlServer;
    }

    public DistinctTypeProxySqlServer getDistinctTypeProxy() {
        return this.distinctTypeProxy;
    }

    public void setDistinctTypeProxy(DistinctTypeProxySqlServer distinctTypeProxySqlServer) {
        if (distinctTypeProxySqlServer != null) {
            this.distinctTypeProxy = distinctTypeProxySqlServer;
            this.userDefinedType = null;
            this.fireDataFieldChange();
        }
    }

    public RuleSqlServer getRuleObject() {
        return this.ruleObject;
    }

    public void setRuleObject(RuleSqlServer ruleSqlServer) {
        this.ruleObject = ruleSqlServer;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schemaSqlServer) {
        this.schema = schemaSqlServer;
    }

    @Override
    public void showPropertyDialog() {
        UsedUDDTPropertyDialog usedUDDTPropertyDialog = new UsedUDDTPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
        usedUDDTPropertyDialog.show();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "UDDT";
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
    }

    public UserDefinedTypeSqlServer getUserDefinedType() {
        return this.userDefinedType;
    }

    public void setUserDefinedType(UserDefinedTypeSqlServer userDefinedTypeSqlServer) {
        if (userDefinedTypeSqlServer != null) {
            this.userDefinedType = userDefinedTypeSqlServer;
            this.distinctTypeProxy = null;
            this.fireDataFieldChange();
        }
    }

    public boolean isBaseOnDistinctType() {
        return this.getDistinctTypeProxy() != null;
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(string);
        } else {
            this.addExtProperty(string);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String string) {
        this.getExtPropsSet().add(string);
    }

    public void recreateExtPropertiesSet(String string) {
        this.getExtPropsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extPropsSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getExtPropsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    public String getDataType() {
        try {
            if (this.distinctTypeProxy != null) {
                return this.distinctTypeProxy.getDistinctType().getLogicalDataType().toString();
            }
            return this.userDefinedType.getDataType().getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getDataTypeString() {
        String string = "";
        MDDataType mDDataType = null;
        if (this.distinctTypeProxy != null) {
            DistinctType distinctType = this.distinctTypeProxy.getDistinctType();
            LogicalDatatype logicalDatatype = distinctType.getLogicalDataType();
            if (logicalDatatype != null) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("size", "" + distinctType.getSize());
                treeMap.put("precision", "" + distinctType.getPrecision());
                treeMap.put("scale", "" + distinctType.getScale());
                mDDataType = logicalDatatype.createDataType(this.getRDBMSType().toString(), treeMap);
                string = mDDataType.toString();
            }
        } else {
            mDDataType = this.userDefinedType.getDataType();
            string = mDDataType.toString();
        }
        return string;
    }

    public String getNullType() {
        if (this.isBaseOnDistinctType()) {
            return this.getDistinctTypeProxy().getNullType();
        }
        return this.getUserDefinedType().getNullType();
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return super.getLongName();
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

