/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UniquePropertyDialogSqlServer;

public class UniqueProxySqlServer
extends IndexProxy {
    private FileGroupSqlServer filegroup;
    private int fillFactor = 0;
    public static final String TYPE_NAME = "Unique";

    public UniqueProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public UniqueProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UniquePropertyDialogSqlServer uniquePropertyDialogSqlServer = new UniquePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            uniquePropertyDialogSqlServer.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer fileGroupSqlServer) {
        this.filegroup = fileGroupSqlServer;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int n) {
        if (n >= 0 && n <= 100) {
            this.fillFactor = n;
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().remove(this);
            if (!this.getStorageDesign().getIndexProxySet().containsId(designObject.getObjectID())) {
                this.getStorageDesign().getIndexProxySet().add(designObject);
            }
            this.fireChangeNoDirty(objectChangeEvent);
        }
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }
}

