/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;

public class UniqueProxySetSqlServer
extends IndexProxySet {
    public UniqueProxySetSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new UniqueProxySqlServer((Index)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new UniqueProxySqlServer(design, string, string2, this.getStorageDesign());
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        Index index;
        if (modelObjectSetEvent.isAdded()) {
            Index index2 = (Index)modelObjectSetEvent.getAffected();
            if (index2.isUnique()) {
                this.add(index2);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved() && this.containsId((index = (Index)modelObjectSetEvent.getAffected()).getObjectID())) {
            this.remove((Index)modelObjectSetEvent.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (!index.isUnique()) continue;
            this.add(index);
        }
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && ((KeyObject)designObject).isUnique()) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            try {
                this.add(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in UniqueProxySetSqlServer.add");
            }
            this.fireUpdate();
        }
    }

    public boolean hasDublicateNames() {
        for (int i = 0; i < this.elements.size(); ++i) {
            UniqueProxySqlServer uniqueProxySqlServer = (UniqueProxySqlServer)this.elements.get(i);
            for (int j = i + 1; j < this.elements.size(); ++j) {
                UniqueProxySqlServer uniqueProxySqlServer2 = (UniqueProxySqlServer)this.elements.get(j);
                if (!uniqueProxySqlServer.getName().equalsIgnoreCase(uniqueProxySqlServer2.getName()) || ((TableProxySqlServer)uniqueProxySqlServer.getTableProxy()).getDatabase() != ((TableProxySqlServer)uniqueProxySqlServer2.getTableProxy()).getDatabase()) continue;
                return true;
            }
        }
        return false;
    }
}

