/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.ViewPropertyDialogSqlServer;

public class TableViewProxySqlServer
extends TableViewProxy
implements ModelObjectSetListener,
StorageObjectListener {
    private DataBaseSqlServer dataBase;
    private StorageObjectCollection indexesOnView;
    private StorageObjectCollection triggers;
    private String props = "";
    private InlineList extPropsSet = null;
    private UserSqlServer user = null;
    private String encryption = "NO";
    private String schemaBinding = "NO";
    private String viewMetaData = "NO";
    private SchemaSqlServer schema;
    protected StorageObjectCollection synonyms;

    public TableViewProxySqlServer(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
        this.indexesOnView = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getIndexOnViewSet());
        this.indexesOnView.setParent(this);
        this.indexesOnView.setName(Messages.getString("TableProxy.Indexes"));
        this.indexesOnView.setClassForParent(TableViewProxySqlServer.class);
        this.indexesOnView.setSetMethod("setView");
        this.indexesOnView.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getIndexOnViewSet().addSetListener(this);
        this.addIndexesFromDesign(((StorageDesignSqlServer)storageDesign).getIndexOnViewSet());
        if (this.schemaBinding.equalsIgnoreCase("YES")) {
            this.enableIndexes();
        } else {
            this.disableIndexes();
        }
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxySqlServer.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.setDataBase(null);
    }

    public TableViewProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.indexesOnView = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getIndexOnViewSet());
        this.indexesOnView.setParent(this);
        this.indexesOnView.setName(Messages.getString("TableProxy.Indexes"));
        this.indexesOnView.setClassForParent(TableViewProxySqlServer.class);
        this.indexesOnView.setSetMethod("setView");
        this.indexesOnView.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getIndexOnViewSet().addSetListener(this);
        this.addIndexesFromDesign(((StorageDesignSqlServer)storageDesign).getIndexOnViewSet());
        if (this.schemaBinding.equalsIgnoreCase("YES")) {
            this.enableIndexes();
        } else {
            this.disableIndexes();
        }
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxySqlServer.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.setDataBase(null);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ViewPropertyDialogSqlServer viewPropertyDialogSqlServer = new ViewPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            viewPropertyDialogSqlServer.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.indexesOnView;
            }
            case 1: {
                return this.triggers;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.indexesOnView) {
            return 0;
        }
        if (modelObject == this.triggers) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.indexesOnView) {
            return 0;
        }
        if (object == this.triggers) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.indexesOnView.removeAll();
        this.triggers.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexOnViewSqlServer) {
                IndexOnViewSqlServer indexOnViewSqlServer = (IndexOnViewSqlServer)modelObjectSetEvent.getAffected();
                indexOnViewSqlServer.addObjectListener(this);
                if (indexOnViewSqlServer.getView() == this) {
                    indexOnViewSqlServer.setParent(this.indexesOnView);
                    this.indexesOnView.add(indexOnViewSqlServer);
                } else {
                    this.indexesOnView.remove(indexOnViewSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer triggerSqlServer = (TriggerSqlServer)modelObjectSetEvent.getAffected();
                triggerSqlServer.addObjectListener(this);
                if (triggerSqlServer.getView() == this) {
                    triggerSqlServer.setParent(this.triggers);
                    this.triggers.add(triggerSqlServer);
                } else {
                    this.triggers.remove(triggerSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexOnViewSqlServer) {
                IndexOnViewSqlServer indexOnViewSqlServer = (IndexOnViewSqlServer)modelObjectSetEvent.getAffected();
                this.indexesOnView.remove(indexOnViewSqlServer);
                indexOnViewSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer triggerSqlServer = (TriggerSqlServer)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerSqlServer);
                triggerSqlServer.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof IndexOnViewSqlServer) {
            IndexOnViewSqlServer indexOnViewSqlServer = (IndexOnViewSqlServer)objectChangeEvent.getAffected();
            if (indexOnViewSqlServer.getView() == this) {
                indexOnViewSqlServer.setParent(this.indexesOnView);
                this.indexesOnView.add(indexOnViewSqlServer);
                if (this.indexesOnView.size() == 1) {
                    indexOnViewSqlServer.setClustered("YES");
                    indexOnViewSqlServer.setUnique("YES");
                }
            } else {
                this.indexesOnView.remove(indexOnViewSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof TriggerSqlServer) {
            TriggerSqlServer triggerSqlServer = (TriggerSqlServer)objectChangeEvent.getAffected();
            if (triggerSqlServer.getView() == this) {
                triggerSqlServer.setParent(this.triggers);
                this.triggers.add(triggerSqlServer);
            } else {
                this.triggers.remove(triggerSqlServer);
            }
        }
    }

    public UserSqlServer getUser() {
        return this.user;
    }

    public void setUser(UserSqlServer userSqlServer) {
        if (this.user != userSqlServer) {
            this.user = userSqlServer;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.encryption = string;
        }
        this.fireDataFieldChange();
    }

    public String getSchemaBinding() {
        return this.schemaBinding;
    }

    public void setSchemaBinding(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.schemaBinding = string;
            if (string.equalsIgnoreCase("YES")) {
                this.enableIndexes();
            } else {
                this.disableIndexes();
            }
        }
        this.fireDataFieldChange();
    }

    public String getViewMetaData() {
        return this.viewMetaData;
    }

    public void setViewMetaData(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.viewMetaData = string;
        }
        this.fireDataFieldChange();
    }

    public void setDataBase(DataBaseSqlServer dataBaseSqlServer) {
        this.dataBase = dataBaseSqlServer == null && ((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().hasNullInstance() ? (DataBaseSqlServer)((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().getNullInstance() : dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public DataBaseSqlServer getDataBase() {
        return this.dataBase;
    }

    protected void addIndexesFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            IndexOnViewSqlServer indexOnViewSqlServer = (IndexOnViewSqlServer)iterator.next();
            indexOnViewSqlServer.addObjectListener(this);
            if (indexOnViewSqlServer.getView() == this) {
                indexOnViewSqlServer.setParent(this.indexesOnView);
                this.indexesOnView.add(indexOnViewSqlServer);
                continue;
            }
            this.indexesOnView.remove(indexOnViewSqlServer);
        }
    }

    protected void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerSqlServer triggerSqlServer = (TriggerSqlServer)iterator.next();
            triggerSqlServer.addObjectListener(this);
            if (triggerSqlServer.getView() == this) {
                triggerSqlServer.setParent(this.triggers);
                this.triggers.add(triggerSqlServer);
                continue;
            }
            this.triggers.remove(triggerSqlServer);
        }
    }

    public ColumnProxySqlServer getColumnProxyByName(String string) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)columnProxyArray[i];
            if (!string.equals(columnProxySqlServer.getName())) continue;
            return columnProxySqlServer;
        }
        return null;
    }

    private void enableIndexes() {
        this.indexesOnView.setForbiddenCreateElement(false);
    }

    private void disableIndexes() {
        this.indexesOnView.setForbiddenCreateElement(true);
        this.indexesOnView.removeAll();
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(string);
        } else {
            this.addExtProperty(string);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String string) {
        this.getExtPropsSet().add(string);
    }

    protected void recreateExtPropertiesSet(String string) {
        this.getExtPropsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extPropsSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getExtPropsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    public StorageObjectCollection getIndexesOnView() {
        return this.indexesOnView;
    }

    public IndexOnViewSqlServer createIndexOnView() {
        if (this.indexesOnView.getStorageObjectSet() != null) {
            return (IndexOnViewSqlServer)this.indexesOnView.createElement(null);
        }
        return null;
    }

    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schemaSqlServer) {
        this.schema = schemaSqlServer;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.getSchema() != null && !this.getSchema().isNullInstance()) {
            return new StringBuffer().append(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getDataBase().isDropEnabled() || this.getDataBase().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.triggers.addAllElementsTo(arrayList);
            if (this.synonyms != null) {
                this.synonyms.addAllElementsTo(arrayList);
            }
            this.indexesOnView.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

