/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.DistinctTypeProxySet;
import oracle.dbtools.crest.model.design.storage.MethodProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.TypeElementProxySet;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FKProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedDataSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeSetSqlServerv2k5;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.storage.usertype.UserDefinedTypesDialogSqlServer;

public abstract class StorageDesignSqlServer
extends StorageDesign {
    private boolean dtDialogVisible = false;
    private DistinctTypeProxySet distinctTypeProxies;
    private boolean imported;

    public StorageDesignSqlServer(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, Design design) {
        super(relationalDesign, rDBMSSite, design);
    }

    @Override
    public abstract PropertyHolder getPropertyHolder();

    public abstract void updateGeneralRule();

    public abstract PKProxySetSqlServer getPKProxySet();

    public abstract DesignPartView getSelectedSubView();

    public UniqueProxySetSqlServer getUniqueProxySet() {
        return null;
    }

    public abstract FKProxySetSqlServer getFKProxySet();

    @Override
    public StructuredTypeProxySet getStructuredTypeProxySet() {
        return null;
    }

    @Override
    public CollectionTypeProxySet getCollectionTypeProxySet() {
        return null;
    }

    public DistinctTypeProxySet getDistinctTypeProxySet() {
        if (this.distinctTypeProxies == null) {
            this.distinctTypeProxies = new DistinctTypeSetSqlServerv2k5(this);
            this.distinctTypeProxies.setDesign(this.getDesign());
        }
        return this.distinctTypeProxies;
    }

    @Override
    public TypeElementProxySet getTypeElementProxySet() {
        return null;
    }

    @Override
    public MethodProxySet getMethodProxySet() {
        return null;
    }

    public abstract InstanceDescriptorColumnSetSqlServer getInstanceDescriptorColumnSet();

    @Override
    public StorageObjectSet getStorageObjectSetForType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("DataBase")) {
            return this.getDataBaseSet();
        }
        if (string.equalsIgnoreCase("Role")) {
            return this.getRoleSet();
        }
        if (string.equalsIgnoreCase("User")) {
            return this.getUserSet();
        }
        if (string.equalsIgnoreCase("Schema")) {
            return this.getSchemaSet();
        }
        if (string.equalsIgnoreCase("DataFile")) {
            return this.getDataFileSet();
        }
        if (string.equalsIgnoreCase("FileGroup")) {
            return this.getFileGroupSet();
        }
        if (string.equalsIgnoreCase("Permissions")) {
            return this.getPermissionsSet();
        }
        if (string.equalsIgnoreCase("Login")) {
            return this.getLoginSet();
        }
        if (string.equalsIgnoreCase("Rule")) {
            return this.getRuleSet();
        }
        if (string.equalsIgnoreCase("Default")) {
            return this.getDefaultSet();
        }
        if (string.equalsIgnoreCase("IndexOnView")) {
            return this.getIndexOnViewSet();
        }
        if (string.equalsIgnoreCase("Trigger")) {
            return this.getTriggerSet();
        }
        if (string.equalsIgnoreCase("StProc") || string.equalsIgnoreCase("StoredProcedure")) {
            return this.getStoredProcedureSet();
        }
        if (string.equalsIgnoreCase("UDType") || string.equalsIgnoreCase("UserDefinedType")) {
            return this.getUserDefinedTypeSet();
        }
        if (string.equalsIgnoreCase("InstanceDescriptorCol")) {
            return this.getInstanceDescriptorColumnSet();
        }
        if (string.equalsIgnoreCase("UUDD") || string.equalsIgnoreCase("UsedUserDefinedData")) {
            return this.getUsedUserDefinedDataSet();
        }
        return null;
    }

    @Override
    public List getStorableSetsList() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getDataBaseSet());
        arrayList.add(this.getLoginSet());
        arrayList.add(this.getUserSet());
        arrayList.add(this.getSchemaSet());
        arrayList.add(this.getRoleSet());
        arrayList.add(this.getDefaultSet());
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getRuleSet());
        arrayList.add(this.getTriggerSet());
        arrayList.add(this.getStoredProcedureSet());
        arrayList.add(this.getUserDefinedTypeSet());
        arrayList.add(this.getDistinctTypeProxySet());
        return arrayList;
    }

    @Override
    public List getAllSetsList() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getDataBaseSet());
        arrayList.add(this.getFileGroupSet());
        arrayList.add(this.getDataFileSet());
        arrayList.add(this.getLoginSet());
        arrayList.add(this.getUserSet());
        arrayList.add(this.getSchemaSet());
        arrayList.add(this.getRoleSet());
        arrayList.add(this.getDefaultSet());
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getColumnProxySet());
        arrayList.add(this.getIndexProxySet());
        arrayList.add(this.getPKProxySet());
        arrayList.add(this.getUniqueProxySet());
        arrayList.add(this.getFKProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getIndexOnViewSet());
        arrayList.add(this.getInstanceDescriptorColumnSet());
        arrayList.add(this.getRuleSet());
        arrayList.add(this.getPermissionsSet());
        arrayList.add(this.getTriggerSet());
        arrayList.add(this.getStoredProcedureSet());
        arrayList.add(this.getUserDefinedTypeSet());
        arrayList.add(this.getDistinctTypeProxySet());
        arrayList.add(this.getUsedUserDefinedDataSet());
        return arrayList;
    }

    public abstract DataBaseSetSqlServer getDataBaseSet();

    public abstract RoleSetSqlServer getRoleSet();

    public abstract UserSetSqlServer getUserSet();

    public abstract DataFileSetSqlServer getDataFileSet();

    public abstract FileGroupSetSqlServer getFileGroupSet();

    public abstract PermissionsSetSqlServer getPermissionsSet();

    public abstract RuleSetSqlServer getRuleSet();

    public abstract LoginSetSqlServer getLoginSet();

    public abstract DefaultSetSqlServer getDefaultSet();

    public abstract IndexOnViewSetSqlServer getIndexOnViewSet();

    public abstract TriggerSetSqlServer getTriggerSet();

    public abstract StoredProcedureSetSqlServer getStoredProcedureSet();

    public abstract UserDefinedTypeSetSqlServer getUserDefinedTypeSet();

    public abstract SchemaSetSqlServer getSchemaSet();

    public abstract UsedUserDefinedDataSet getUsedUserDefinedDataSet();

    @Override
    public boolean hasUserDefinedTypes() {
        return true;
    }

    @Override
    public void showUserDefinedTypes() {
        if (!this.dtDialogVisible) {
            UserDefinedTypesDialogSqlServer userDefinedTypesDialogSqlServer = new UserDefinedTypesDialogSqlServer(this.getDesign().getAppView(), this);
            userDefinedTypesDialogSqlServer.showDialog();
        }
    }

    public boolean isDtDialogVisible() {
        return this.dtDialogVisible;
    }

    public void setDtDialogVisible(boolean bl) {
        this.dtDialogVisible = bl;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean bl) {
        this.imported = bl;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getIndexProxySet());
        arrayList.add(this.getFKProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getDataBaseSet());
        return arrayList;
    }

    @Override
    public List getUniqueList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getUniqueProxySet() != null) {
            Object[] objectArray = this.getUniqueProxySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
        }
        return arrayList;
    }

    @Override
    public List getFKProxyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getFKProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    @Override
    public List getPKProxyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getPKProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    @Override
    public void reloadAllProxies() {
        super.reloadAllProxies();
        this.getPKProxySet().setDesign(this.getDesign());
        this.getUniqueProxySet().setDesign(this.getDesign());
        this.getFKProxySet().setDesign(this.getDesign());
        this.getDistinctTypeProxySet().setDesign(this.getDesign());
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> list = super.createDDLSelectionSetsList();
        list.add(this.getDataBaseSet());
        list.add(this.getUserSet());
        list.add(this.getLoginSet());
        list.add(this.getUserDefinedTypeSet());
        list.add(this.getDefaultSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getRoleSet());
        list.add(this.getRuleSet());
        list.add(this.getTableProxySet());
        this.addDDLSelectionViewSetsList(list);
        return list;
    }

    protected void addDDLSelectionViewSetsList(List<ElementSet> list) {
        TableViewProxySet tableViewProxySet = this.getTableViewProxySet();
        Iterator iterator = tableViewProxySet.iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            list.add(tableViewProxySqlServer.getIndexesOnView());
            list.add(tableViewProxySqlServer.getTriggers());
        }
        list.add(tableViewProxySet);
    }

    @Override
    public void sortCollections() {
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getDataBaseSet().sort();
        this.getFileGroupSet().sort();
        this.getDataFileSet().sort();
        this.getRoleSet().sort();
        this.getLoginSet().sort();
        this.getUserSet().sort();
        this.getSchemaSet().sort();
        this.getDefaultSet().sort();
        this.getUserDefinedTypeSet().sort();
        this.getIndexOnViewSet().sort();
        this.getPermissionsSet().sort();
        this.getRuleSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getUsedUserDefinedDataSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getUserSet();
    }

    @Override
    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES_WITH_DEFAULT;
    }

    @Override
    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITH_DEFAULT_WITHOUT_NULL;
    }

    @Override
    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_NOACTION_CASCADE;
    }

    @Override
    public String getValidFKRule(String string) {
        if ("RESTRICT".equals(string)) {
            return "NO ACTION";
        }
        return string;
    }
}

