/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;

public class PermissionsSqlServer
extends AbstractStorageObjectSqlServer {
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"ALL PRIVILEGES", "UPDATE", "SELECT"};
    private static final String[] TABLE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "REFERENCES", "SELECT", "UPDATE"};
    private TableProxySqlServer table = null;
    private TableViewProxySqlServer view = null;
    private InlineList privilegesSet = null;
    private InlineList privilegesWithGrantOptionSet = null;
    private UserSqlServer user = null;
    private RoleSqlServer role = null;
    private String privileges = "";
    private String privilegesWithGrantOption = "";
    private String columnList = "";
    private RoleSqlServer asRole = null;
    public static final String TYPE_NAME = "Permissions";

    public static List getColumnPermissionsValues() {
        List<String> list = Arrays.asList(COLUMNS_PRIVILEGES);
        Collections.sort(list, new StringComparator());
        return list;
    }

    public static List getTablePermissionsValues() {
        List<String> list = Arrays.asList(TABLE_PRIVILEGES);
        Collections.sort(list, new StringComparator());
        return list;
    }

    public static List getViewPermissionsValues() {
        List<String> list = Arrays.asList(VIEW_PRIVILEGES);
        Collections.sort(list, new StringComparator());
        return list;
    }

    public static String[] getColumnPrivilegesValues() {
        return COLUMNS_PRIVILEGES;
    }

    public static String[] getTablePrivilegesValues() {
        return TABLE_PRIVILEGES;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    private void recreatePrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.privilegesSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void addPrivileges(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
            this.getPrivilegesWithGrantOptionSet().remove(string);
        }
    }

    private void recreatePrivilegesWithGrantOptionSet(String string) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.privilegesWithGrantOptionSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void addPrivilegesWithGrantOption(String string) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(string)) {
            this.getPrivilegesWithGrantOptionSet().add(string);
            this.getPrivilegesSet().remove(string);
        }
    }

    private void addColumn(String string) {
        if (!this.columnList.trim().equalsIgnoreCase("")) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + string;
    }

    public RoleSqlServer getAsRole() {
        return this.asRole;
    }

    @Override
    public String getIDPrefix() {
        return "Prm";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public InlineList getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new InlineList();
        }
        return this.privilegesSet;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public InlineList getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new InlineList();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public TableProxySqlServer getTable() {
        return this.table;
    }

    public RoleSqlServer getRole() {
        return this.role;
    }

    public void setRole(RoleSqlServer roleSqlServer) {
        if (this.role != roleSqlServer) {
            this.role = roleSqlServer;
            if (roleSqlServer != null) {
                this.setPAC_Element(roleSqlServer);
            }
            this.fireDataFieldChange();
        }
    }

    public UserSqlServer getUser() {
        return this.user;
    }

    public void setUser(UserSqlServer userSqlServer) {
        if (this.user != userSqlServer) {
            this.user = userSqlServer;
            if (userSqlServer != null) {
                this.setPAC_Element(userSqlServer);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setAsRole(RoleSqlServer roleSqlServer) {
        this.asRole = roleSqlServer;
        this.fireDataFieldChange();
    }

    public void setPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesSet(string);
        } else {
            this.addPrivileges(string);
        }
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithGrantOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(string);
        } else {
            this.addPrivilegesWithGrantOption(string);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.fireDataFieldChange();
    }

    public void setTable(TableProxySqlServer tableProxySqlServer) {
        this.table = tableProxySqlServer;
        if (tableProxySqlServer != null) {
            this.setView(null);
        }
        this.fireDataFieldChange();
    }

    public void setView(TableViewProxySqlServer tableViewProxySqlServer) {
        this.view = tableViewProxySqlServer;
        if (tableViewProxySqlServer != null) {
            this.setTable(null);
        }
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(string);
        } else {
            this.addColumn(string);
        }
        this.fireDataFieldChange();
    }

    public void clearColPermissions() {
        this.columnList = "";
    }

    private void recreateColumnList(String string) {
        this.columnList = string;
    }

    public ArrayList getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf(44) > -1) {
                string = string.substring(0, string.indexOf(44));
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getPrivs(ColumnProxySqlServer columnProxySqlServer) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(44) <= -1 || !(string = string2.substring(0, string2.indexOf(44)).trim()).equalsIgnoreCase(columnProxySqlServer.getName())) continue;
            return string2.substring(string2.indexOf(44) + 1);
        }
        return string;
    }

    public String getPrivs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(44) <= -1 || !(string2 = string3.substring(0, string3.indexOf(44)).trim()).equalsIgnoreCase(string)) continue;
            return string3.substring(string3.indexOf(44) + 1);
        }
        return string2;
    }

    public boolean hasColPrivilege(String string) {
        ArrayList arrayList = this.getColumns();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.getPrivs((String)arrayList.get(i)).indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.privileges = "";
        this.privilegesWithGrantOption = "";
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

