/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PartitionSchemePropertyDialog;

public class PartitionSchemeSqlServer
extends AbstractStorageObjectSqlServer {
    private PartitionFunctionSqlServer partitionFunction;
    public static final String MULTIPLE_FILE_GROUPS = "MULTIPLE FILE GROUPS";
    public static final String SINGLE_FILE_GROUP = "SINGLE FILE GROUP";
    private static final String[] mapTypeChoices = new String[]{"MULTIPLE FILE GROUPS", "SINGLE FILE GROUP"};
    public static final String MAXVALUE = "MAXVALUE";
    private String mappingType = "MULTIPLE FILE GROUPS";
    private FileGroupSqlServer singleFileGroup;
    private MappingTable mappingTableSet = null;
    protected String mappingTable = "";
    public static final String TYPE_NAME = "PartitionScheme";

    public PartitionFunctionSqlServer getPartitionFunction() {
        return this.partitionFunction;
    }

    public void setPartitionFunction(PartitionFunctionSqlServer partitionFunctionSqlServer) {
        this.partitionFunction = partitionFunctionSqlServer;
        this.setPAC_Element(partitionFunctionSqlServer);
        this.fireDataFieldChange();
    }

    public FileGroupSqlServer getSingleFileGroup() {
        return this.singleFileGroup;
    }

    public void setSingleFileGroup(FileGroupSqlServer fileGroupSqlServer) {
        this.singleFileGroup = fileGroupSqlServer;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PartitionSchemePropertyDialog partitionSchemePropertyDialog = new PartitionSchemePropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            partitionSchemePropertyDialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "PS";
    }

    public static String[] getMapTypeChoices() {
        return mapTypeChoices;
    }

    public boolean isSingleFileGroupSelected() {
        return this.getMappingType().equalsIgnoreCase(SINGLE_FILE_GROUP);
    }

    public String getMappingType() {
        return this.mappingType;
    }

    public MappingTable getMappingTableSet() {
        if (this.mappingTableSet == null) {
            this.mappingTableSet = new MappingTable();
        }
        return this.mappingTableSet;
    }

    public void setMappingTable(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateMappingTableSet(string);
        } else {
            this.addMappingTableValue(string);
        }
        this.mappingTable = this.getMappingTableSet().toString();
        this.fireDataFieldChange();
    }

    private void addMappingTableValue(String string) {
        this.getMappingTableSet().add(string);
    }

    public void recreateMappingTableSet(String string) {
        this.getMappingTableSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.mappingTableSet = new MappingTable();
        while (stringTokenizer.hasMoreTokens()) {
            this.getMappingTableSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public String getMappingTable() {
        return this.mappingTable;
    }

    public void setMappingType(String string) {
        this.mappingType = string;
    }

    public void clear() {
        if (this.mappingTableSet != null) {
            this.mappingTableSet.removeAllElements();
            this.mappingTable = "";
        }
    }

    public void removeFileGroup(FileGroupSqlServer fileGroupSqlServer) {
        for (int i = 0; i < this.getMappingTableSet().size(); ++i) {
            String string = (String)this.getMappingTableSet().get(++i);
            if (!string.equalsIgnoreCase(fileGroupSqlServer.getName())) continue;
            this.getMappingTableSet().set(i, "");
        }
        this.mappingTable = this.getMappingTableSet().toString();
    }

    public void removeBoundaruValue(String string) {
        int n = this.getMappingTableSet().size();
        if (n >= 2) {
            if (this.getMappingTableSet().contains(MAXVALUE)) {
                n = this.getMappingTableSet().indexOf(MAXVALUE);
            }
            this.getMappingTableSet().removeElementAt(n - 1);
            this.getMappingTableSet().removeElementAt(n - 2);
        }
        this.mappingTable = this.getMappingTableSet().toString();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SCHEMA_ICON", 16);
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        if (this.getPartitionFunction() != null) {
            return this.getPartitionFunction().getDatabase();
        }
        return null;
    }

    public class MappingTable
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

