/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PartitionFunctionPropertyDialog;

public class PartitionFunctionSqlServer
extends AbstractStorageObjectSqlServer
implements ModelObjectSetListener,
StorageObjectListener {
    protected String inputType = "";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    private static final String[] LEFT_RIGHT = new String[]{"LEFT", "RIGHT"};
    protected String rangeType = "LEFT";
    protected String boundaryValues = "";
    protected InlineList bValuesSet = null;
    protected DataBaseSqlServer database = null;
    private StorageObjectCollection partitionScheme;
    public static final String TYPE_NAME = "PartitionFunction";

    public PartitionFunctionSqlServer(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        StorageDesignSqlServerv2k5 storageDesignSqlServerv2k5 = (StorageDesignSqlServerv2k5)storageDesign;
        this.partitionScheme = new StorageObjectCollection(((StorageDesignSqlServerv2k5)this.getStorageDesign()).getPartitionSchemeSet());
        this.partitionScheme.setParent(this);
        this.partitionScheme.setName(Messages.getString("PartitionFunctionSqlServer.PartitionScheme"));
        this.partitionScheme.setSetMethod("setPartitionFunction");
        this.partitionScheme.setClassForParent(PartitionFunctionSqlServer.class);
        this.partitionScheme.setIcon(GUIConfiguration.getInstance().getIcon("SCHEMA_FOLDER_ICON", 16));
        storageDesignSqlServerv2k5.getPartitionSchemeSet().addSetListener(this);
        this.addPartSchemeFromDesign(((StorageDesignSqlServerv2k5)this.getStorageDesign()).getPartitionSchemeSet());
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.partitionScheme) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.partitionScheme) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.partitionScheme;
            }
        }
        return null;
    }

    public void clear() {
        this.getBValuesSet().removeAllElements();
        this.boundaryValues = "";
    }

    public InlineList getBValuesSet() {
        if (this.bValuesSet == null) {
            this.bValuesSet = new InlineList();
        }
        return this.bValuesSet;
    }

    public String getBoundaryValues() {
        return this.boundaryValues;
    }

    public void setBoundaryValues(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateBValuesSet(string);
        } else {
            this.addBoundaryValue(string);
        }
        this.boundaryValues = this.getBValuesSet().toString();
        this.fireDataFieldChange();
    }

    private void addBoundaryValue(String string) {
        this.getBValuesSet().add(string);
    }

    public void recreateBValuesSet(String string) {
        this.getBValuesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.bValuesSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getBValuesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PartitionFunctionPropertyDialog partitionFunctionPropertyDialog = new PartitionFunctionPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            partitionFunctionPropertyDialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "PF";
    }

    public void setBValuesSet(InlineList inlineList) {
        this.bValuesSet = inlineList;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public static String[] getLEFT_RIGHT() {
        return LEFT_RIGHT;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String string) {
        this.inputType = string;
    }

    public String getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(String string) {
        this.rangeType = string;
    }

    private void addPartSchemeFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            PartitionSchemeSqlServer partitionSchemeSqlServer = (PartitionSchemeSqlServer)iterator.next();
            if (partitionSchemeSqlServer.getPartitionFunction() != null && partitionSchemeSqlServer.getPartitionFunction() == this) {
                partitionSchemeSqlServer.setParent(this.partitionScheme);
                this.partitionScheme.add(partitionSchemeSqlServer);
                continue;
            }
            this.partitionScheme.remove(partitionSchemeSqlServer);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof PartitionSchemeSqlServer) {
                PartitionSchemeSqlServer partitionSchemeSqlServer = (PartitionSchemeSqlServer)modelObjectSetEvent.getAffected();
                partitionSchemeSqlServer.addObjectListener(this);
                if (partitionSchemeSqlServer.getPartitionFunction() != null && partitionSchemeSqlServer.getPartitionFunction() == this) {
                    partitionSchemeSqlServer.setParent(this.partitionScheme);
                    this.partitionScheme.add(partitionSchemeSqlServer);
                } else {
                    this.partitionScheme.remove(partitionSchemeSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof PartitionSchemeSqlServer) {
            PartitionSchemeSqlServer partitionSchemeSqlServer = (PartitionSchemeSqlServer)modelObjectSetEvent.getAffected();
            this.partitionScheme.remove(partitionSchemeSqlServer);
            partitionSchemeSqlServer.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof PartitionSchemeSqlServer) {
            PartitionSchemeSqlServer partitionSchemeSqlServer = (PartitionSchemeSqlServer)objectChangeEvent.getAffected();
            if (partitionSchemeSqlServer.getPartitionFunction() != null && partitionSchemeSqlServer.getPartitionFunction() == this) {
                partitionSchemeSqlServer.setParent(this.partitionScheme);
                this.partitionScheme.add(partitionSchemeSqlServer);
            } else {
                this.partitionScheme.remove(partitionSchemeSqlServer);
            }
        }
    }

    public StorageObjectCollection getPartitionScheme() {
        return this.partitionScheme;
    }

    public PartitionSchemeSqlServer createPartitionScheme() {
        if (this.partitionScheme.getStorageObjectSet() != null) {
            return (PartitionSchemeSqlServer)this.partitionScheme.createElement(null);
        }
        return null;
    }

    @Override
    public void clearChildren() {
        this.partitionScheme.removeAll();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("FUNCTION_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

