/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.LoginPropertyDialogSqlServer;
import oracle.dbtools.crest.util.string.Crypt;

public class LoginSqlServer
extends AbstractStorageObjectSqlServer {
    public static final String[] AUTH_CHOICES = new String[]{"WINDOWS", "SQL Server"};
    private static List authList = Arrays.asList(AUTH_CHOICES);
    private static Set authSet = null;
    private static Crypt crypt = new Crypt();
    private String authentication = "SQL Server";
    private String password = "";
    private DataBaseSqlServer defaultDatabase;
    private String language = "English";
    private String users = "";
    private UserSet userSet = null;
    public static final String TYPE_NAME = "Login";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LoginPropertyDialogSqlServer loginPropertyDialogSqlServer = new LoginPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            loginPropertyDialogSqlServer.show();
        }
    }

    public static List getAuthenticationValues() {
        return authList;
    }

    protected boolean checkAuth(String string) {
        if (authSet == null) {
            authSet = new HashSet();
            authSet.addAll(Arrays.asList(LoginSqlServer.getAuthChoices()));
        }
        return authSet.contains(string);
    }

    public static String[] getAuthChoices() {
        return AUTH_CHOICES;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String string) {
        if (this.checkAuth(string)) {
            this.authentication = string;
            this.fireDataFieldChange();
        }
    }

    public DataBaseSqlServer getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(DataBaseSqlServer dataBaseSqlServer) {
        this.defaultDatabase = dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
        this.fireDataFieldChange();
    }

    public String getPassword() {
        return this.password;
    }

    public String decodePassword() {
        String string = this.getDesign().getLoadedVersion() < 3.3f ? this.password : crypt.decrypt(this.password);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setPassword(String string) {
        this.password = string;
        this.fireDataFieldChange();
    }

    public void encodePassword(String string) {
        this.password = crypt.encrypt(string);
        this.fireDataFieldChange();
    }

    private void addUser(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getUserSet().contains(string2)) {
            this.getUserSet().add(string2);
        }
    }

    public void recreateUserSet(String string) {
        this.getUserSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getUserSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setUsers(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(string);
        } else {
            this.addUser(string);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
        UserSqlServer[] userSqlServerArray = (UserSqlServer[])((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().toArray();
        for (int i = 0; i < userSqlServerArray.length; ++i) {
            UserSqlServer userSqlServer = userSqlServerArray[i];
            if (userSqlServer.getLogin() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().remove(userSqlServer);
        }
    }

    @Override
    public void remove() {
        UserSqlServer[] userSqlServerArray = (UserSqlServer[])((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().toArray();
        for (int i = 0; i < userSqlServerArray.length; ++i) {
            UserSqlServer userSqlServer = userSqlServerArray[i];
            if (userSqlServer.getLogin() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().remove(userSqlServer);
        }
        super.remove();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

