/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.IndexPropertyDialogSqlServer;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxySqlServer
extends IndexProxy
implements PropertiesPropagator {
    private FileGroupSqlServer filegroup;
    private String padIndex = "NO";
    private int fillFactor = 0;
    private String recomputeStatistics = "AUTO";
    private String sortInTempDB = "NO";
    private String ignoreDupKey = "NO";
    private String props = "";
    private InlineList extPropsSet = null;
    private List propertyWrapperList = null;

    public IndexProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogSqlServer indexPropertyDialogSqlServer = new IndexPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogSqlServer.show();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getFKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        }
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer fileGroupSqlServer) {
        this.filegroup = fileGroupSqlServer;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int n) {
        if (n >= 0 && n <= 100) {
            this.fillFactor = n;
        }
    }

    public String getIgnoreDupKey() {
        return this.ignoreDupKey;
    }

    public void setIgnoreDupKey(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.ignoreDupKey = string;
            this.fireDataFieldChange();
        }
    }

    public String getPadIndex() {
        return this.padIndex;
    }

    public void setPadIndex(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.padIndex = string;
            this.fireDataFieldChange();
        }
    }

    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    public void setRecomputeStatistics(String string) {
        if (ConstantsSqlServer.checkAutoNo(string)) {
            this.recomputeStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public String getSortInTempDB() {
        return this.sortInTempDB;
    }

    public void setSortInTempDB(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.sortInTempDB = string;
            this.fireDataFieldChange();
        }
    }

    public String getUnique() {
        if (this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index")) {
            return "YES";
        }
        return "NO";
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(string);
        } else {
            this.addExtProperty(string);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String string) {
        this.getExtPropsSet().add(string);
    }

    protected void recreateExtPropertiesSet(String string) {
        this.getExtPropsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extPropsSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getExtPropsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "isClustered", "setClustered", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Pad Index", this, "getPadIndex", "setPadIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Fill Factor[0,100]", this, "getFillFactor", "setFillFactor", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Recompute Stat", this, "getRecomputeStatistics", "setRecomputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Sort in temp DB", this, "getSortInTempDB", "setSortInTempDB", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            string = index.getFKAssociation().getName();
        }
        string = this.applyNameSubstitution(string);
        return string;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

