/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.IndexOnViewPropertyDialogSqlServer;

public class IndexOnViewSqlServer
extends AbstractStorageObjectSqlServer {
    private TableViewProxySqlServer view;
    private String unique = "YES";
    private String clustered = "YES";
    private FileGroupSqlServer filegroup;
    private String padIndex = "NO";
    private int fillFactor = 0;
    private String recomputeStatistics = "AUTO";
    private String sortInTempDB = "NO";
    private String ignoreDupKey = "NO";
    private String props = "";
    private InlineList extPropsSet = null;
    private String cols = "";
    private InlineList colSet = null;
    public static final String TYPE_NAME = "IndexOnView";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexOnViewPropertyDialogSqlServer indexOnViewPropertyDialogSqlServer = new IndexOnViewPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexOnViewPropertyDialogSqlServer.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ViewIndex";
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setView(TableViewProxySqlServer tableViewProxySqlServer) {
        this.view = tableViewProxySqlServer;
        this.setPAC_Element(tableViewProxySqlServer);
        this.fireDataFieldChange();
    }

    public String getUnique() {
        return this.unique;
    }

    public void setUnique(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.unique = string;
            if (this.view != null && ((StorageObjectCollection)this.view.getChild(0)).size() != 1) {
                this.fireDataFieldChange();
            }
        }
    }

    public String getClustered() {
        return this.clustered;
    }

    public void setClustered(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.clustered = string;
            if (this.view != null && ((StorageObjectCollection)this.view.getChild(0)).size() != 1) {
                this.fireDataFieldChange();
            }
        }
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer fileGroupSqlServer) {
        this.filegroup = fileGroupSqlServer;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int n) {
        if (n >= 0 && n <= 100) {
            this.fillFactor = n;
        }
    }

    public String getIgnoreDupKey() {
        return this.ignoreDupKey;
    }

    public void setIgnoreDupKey(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.ignoreDupKey = string;
            this.fireDataFieldChange();
        }
    }

    public String getPadIndex() {
        return this.padIndex;
    }

    public void setPadIndex(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.padIndex = string;
            this.fireDataFieldChange();
        }
    }

    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    public void setRecomputeStatistics(String string) {
        if (ConstantsSqlServer.checkAutoNo(string)) {
            this.recomputeStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public String getSortInTempDB() {
        return this.sortInTempDB;
    }

    public void setSortInTempDB(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.sortInTempDB = string;
            this.fireDataFieldChange();
        }
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(string);
        } else {
            this.addExtProperty(string);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String string) {
        this.getExtPropsSet().add(string);
    }

    protected void recreateExtPropertiesSet(String string) {
        this.getExtPropsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extPropsSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getExtPropsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
        this.getColSet().removeAllElements();
        this.cols = "";
    }

    private void addCol(String string) {
        this.getColSet().add(string);
    }

    protected void recreateColSet(String string) {
        this.getColSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setCols(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColSet(string);
        } else {
            this.addCol(string);
        }
        this.cols = this.getColSet().toString();
        this.fireDataFieldChange();
    }

    public String getCols() {
        return this.cols;
    }

    public String getPartKeySortOrder(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.cols, ",");
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            string3 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            return string3;
        }
        return "ASC";
    }

    public InlineList getColSet() {
        if (this.colSet == null) {
            this.colSet = new InlineList();
        }
        return this.colSet;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        if (this.getView() != null) {
            return this.getView().getDataBase();
        }
        return null;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

