/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.FKPropertyDialogSqlServer;

public class FKProxySqlServer
extends IndexProxy
implements StorageObjectListener {
    public static final String[] ON_CHOICES = new String[]{"NO ACTION", "CASCADE"};
    private static List onList = Arrays.asList(ON_CHOICES);
    private static Set onSet = null;
    private String onDelete = "NO ACTION";
    private String onUpdate = "NO ACTION";
    private String forReplication = "YES";
    public static final String TYPE_NAME = "FKey";

    public FKProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxySqlServer(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        this.fireChange(objectChangeEvent);
    }

    public String getColumns() {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(columnProxyArray[i].getName());
        }
        return stringBuffer.toString();
    }

    public String getReferenceColumns() {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        Column[] columnArray = (Column[])index.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(columnArray[i].getName());
        }
        return stringBuffer.toString();
    }

    public Column[] getRefColumns() {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        return (Column[])index.getElements();
    }

    private Table getRemoteTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getReferenceTable() {
        TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(this.getRemoteTable().getObjectID());
        return tableProxySqlServer.getLongName();
    }

    public String getReferenceOwner() {
        TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)this.getStorageDesign().getTableProxySet().getProxy(this.getRemoteTable().getObjectID());
        if (tableProxySqlServer.getUser() != null) {
            return tableProxySqlServer.getUser().getName();
        }
        return "";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "ForeignKey";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogSqlServer fKPropertyDialogSqlServer = new FKPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            fKPropertyDialogSqlServer.show();
        }
    }

    public static List getOnValues() {
        return onList;
    }

    protected boolean checkOn(String string) {
        if (onSet == null) {
            onSet = new HashSet();
            onSet.addAll(Arrays.asList(FKProxySqlServer.getOnChoices()));
        }
        return onSet.contains(string);
    }

    public static String[] getOnChoices() {
        return ON_CHOICES;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public String getTableSchema() {
        if (((TableProxySqlServer)this.getTableProxy()).getSchema() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getSchema().getName();
        }
        return "";
    }

    public String getForReplication() {
        return this.forReplication;
    }

    public void setForReplication(String string) {
        if (ConstantsSqlServer.checkYesNo(string)) {
            this.forReplication = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(String string) {
        if (this.checkOn(string)) {
            this.onDelete = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(String string) {
        if (this.checkOn(string)) {
            this.onUpdate = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.isFK() && index.getFKAssociation() != null ? index.getFKAssociation().getName() : index.getName();
        string = this.applyNameSubstitution(string);
        return string;
    }
}

