/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.DefaultPropertyDialogSqlServer;

public class DefaultSqlServer
extends AbstractStorageObjectSqlServer {
    private String constant;
    private UserSqlServer owner;
    private SchemaSqlServer schema;
    private DataBaseSqlServer database;
    public static final String TYPE_NAME = "Default";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DefaultPropertyDialogSqlServer defaultPropertyDialogSqlServer = new DefaultPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            defaultPropertyDialogSqlServer.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Dfl";
    }

    public String getConstant() {
        if (this.constant == null) {
            this.constant = "";
        }
        return this.constant;
    }

    public void setConstant(String string) {
        this.constant = string;
        this.fireDataFieldChange();
    }

    public DataBaseSqlServer getDataBase() {
        return this.database;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.getDataBase();
    }

    public void setDataBase(DataBaseSqlServer dataBaseSqlServer) {
        this.database = dataBaseSqlServer;
        this.fireDataFieldChange();
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer userSqlServer) {
        this.owner = userSqlServer;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schemaSqlServer) {
        this.schema = schemaSqlServer;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return this.getSchema() + "." + this.getName();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getSchema() != null) {
            string = this.getSchema().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DEFAULT_ICON", 16);
    }
}

