/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.DataFilePropertyDialogSqlServer;

public class DataFileSqlServer
extends AbstractStorageObjectSqlServer {
    private static final String[] GROWTH_STATES = new String[]{"In MegaBytes", "By Percent"};
    private static List growthList = Arrays.asList(GROWTH_STATES);
    private static Set growthSet = null;
    private String fileName = "";
    private int initialSize = 0;
    private int maxSize = 0;
    private String growthMethod = "In MegaBytes";
    private int growthValue = 0;
    private boolean isUnlimited = true;
    private DataBaseSqlServer dataBase = null;
    private FileGroupSqlServer filegroup = null;
    public static final String TYPE_NAME = "DataFile";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataFilePropertyDialogSqlServer dataFilePropertyDialogSqlServer = new DataFilePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dataFilePropertyDialogSqlServer.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DF";
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.fireDataFieldChange();
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int n) {
        this.initialSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    protected boolean checkGrowth(String string) {
        if (growthSet == null) {
            growthSet = new HashSet();
            growthSet.addAll(Arrays.asList(DataFileSqlServer.getGrowthChoices()));
        }
        return growthSet.contains(string);
    }

    public static String[] getGrowthChoices() {
        return GROWTH_STATES;
    }

    public void setGrowthMethod(String string) {
        if (this.checkGrowth(string)) {
            this.growthMethod = string;
            this.fireDataFieldChange();
        }
    }

    public String getGrowthMethod() {
        return this.growthMethod;
    }

    public int getGrowthValue() {
        return this.growthValue;
    }

    public void setGrowthValue(int n) {
        this.growthValue = n;
    }

    public static List getGrowthValues() {
        return growthList;
    }

    public void setDataBase(DataBaseSqlServer dataBaseSqlServer) {
        this.dataBase = dataBaseSqlServer;
        if (dataBaseSqlServer != null) {
            this.filegroup = null;
            this.setPAC_Element(dataBaseSqlServer);
        }
        this.fireDataFieldChange();
    }

    public DataBaseSqlServer getDataBase() {
        return this.dataBase;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.getDataBase();
    }

    public FileGroupSqlServer getFileGroup() {
        return this.filegroup;
    }

    public void setFileGroup(FileGroupSqlServer fileGroupSqlServer) {
        if (fileGroupSqlServer != null) {
            this.dataBase = null;
            this.filegroup = fileGroupSqlServer;
            this.setPAC_Element(fileGroupSqlServer.getPAC_Element());
            this.fireDataFieldChange();
        }
    }

    public boolean getIsUnlimited() {
        return this.isUnlimited;
    }

    public void setIsUnlimited(boolean bl) {
        this.isUnlimited = bl;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

