/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.DataBasePropertyDialogSqlServer;

public class DataBaseSqlServer
extends AbstractStorageObjectSqlServer
implements ModelObjectSetListener,
StorageObjectListener,
RelationalObjectProxySetListener {
    private StorageObjectCollection transactionLogs;
    private StorageObjectCollection filegroups;
    private StorageObjectCollection defaults;
    private StorageObjectCollection users;
    private StorageObjectCollection roles;
    private StorageObjectCollection rules;
    private StorageObjectCollection procedures;
    private StorageObjectCollection tables;
    private StorageObjectCollection views;
    public static final String[] USER_STATES = new String[]{"SINGLE_USER", "RESTRICTED_USER", "MULTI_USER"};
    private static Set userSet = null;
    public static final String[] ON_OFF_STATES = new String[]{"ON", "OFF"};
    private static Set onOffSet = null;
    public static final String[] CURSOR_DEFAULT_STATES = new String[]{"LOCAL", "GLOBAL"};
    private static Set cursorDefaultSet = null;
    public static final String[] RECOVERY_STATES = new String[]{"FULL", "BULK_LOGGED", "SIMPLE"};
    private static Set recoverySet = null;
    private String userState = "MULTI_USER";
    private String collationName = " ";
    private String cursorCloseOnCommit = "ON";
    private String cursorDefault = "GLOBAL";
    private String autoClose = "ON";
    private String autoCreateStatistics = "ON";
    private String autoUpdateStatistics = "ON";
    private String autoShrink = "ON";
    private String recovery = "FULL";
    private String tornPageDetection = "ON";
    private String ansiNulls = "OFF";
    private String ansiPadding = "";
    private String ansiWarnings = "";
    private String arithabort = "";
    private String concatNullYieldsNull = "";
    private String numericRoundabort = "";
    private String quotedIdentifier = "OFF";
    private String recursiveTriggers = "";
    public static final String TYPE_NAME = "DataBase";

    public DataBaseSqlServer(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)storageDesign;
        this.filegroups = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getFileGroupSet());
        this.filegroups.setParent(this);
        this.filegroups.setName(Messages.getString("DataBaseSqlServer.FileGroups"));
        this.filegroups.setSetMethod("setDataBase");
        this.filegroups.setClassForParent(DataBaseSqlServer.class);
        this.filegroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        this.transactionLogs = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDataFileSet());
        this.transactionLogs.setParent(this);
        this.transactionLogs.setName(Messages.getString("DataBaseSqlServer.LogsFiles"));
        this.transactionLogs.setSetMethod("setDataBase");
        this.transactionLogs.setClassForParent(DataBaseSqlServer.class);
        this.transactionLogs.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        this.defaults = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDefaultSet());
        this.defaults.setParent(this);
        this.defaults.setName(Messages.getString("DataBaseSqlServer.Defaults"));
        this.defaults.setSetMethod("setDataBase");
        this.defaults.setClassForParent(DataBaseSqlServer.class);
        this.defaults.setIcon(GUIConfiguration.getInstance().getIcon("DEFAULT_ICON", 16));
        this.users = new StorageObjectCollection();
        this.users.setParent(this);
        this.users.setName(Messages.getString("StorageDesignOracle.Users"));
        this.users.setSetMethod("setDatabase");
        this.users.setClassForParent(DataBaseSqlServer.class);
        this.users.setIcon(GUIConfiguration.getInstance().getIcon("USER_FOLDER_ICON", 16));
        this.roles = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRoleSet());
        this.roles.setParent(this);
        this.roles.setName(Messages.getString("StorageDesignOracle.Roles"));
        this.roles.setSetMethod("setDatabase");
        this.roles.setClassForParent(DataBaseSqlServer.class);
        this.roles.setIcon(GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16));
        this.rules = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRuleSet());
        this.rules.setParent(this);
        this.rules.setName(Messages.getString("DataBaseSqlServer.Rules"));
        this.rules.setSetMethod("setDatabase");
        this.rules.setClassForParent(DataBaseSqlServer.class);
        this.rules.setIcon(GUIConfiguration.getInstance().getIcon("RULE_ICON", 16));
        this.tables = new StorageObjectCollection();
        this.tables.setParent(this);
        this.tables.setName(Messages.getString("StorageDesignOracle.Tables"));
        this.tables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        this.registerToTableProxyFromDesign(storageDesign.getTableProxySet());
        storageDesign.getTableProxySet().addSetListener(this);
        this.views = new StorageObjectCollection();
        this.views.setParent(this);
        this.views.setName(Messages.getString("StorageDesignOracle.Views"));
        this.views.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON", 16));
        this.registerToViewProxyFromDesign(storageDesign.getTableViewProxySet());
        storageDesign.getTableViewProxySet().addSetListener(this);
        this.procedures = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getStoredProcedureSet());
        this.procedures.setParent(this);
        this.procedures.setName(Messages.getString("StorageDesignOracle.StoredProcedures"));
        this.procedures.setSetMethod("setDatabase");
        this.procedures.setClassForParent(DataBaseSqlServer.class);
        this.procedures.setIcon(GUIConfiguration.getInstance().getIcon("PROCEDURE_FOLDER_ICON", 16));
        storageDesignSqlServer.getDataFileSet().addSetListener(this);
        storageDesignSqlServer.getFileGroupSet().addSetListener(this);
        storageDesignSqlServer.getDefaultSet().addSetListener(this);
        storageDesignSqlServer.getUserSet().addSetListener(this);
        storageDesignSqlServer.getRoleSet().addSetListener(this);
        storageDesignSqlServer.getRuleSet().addSetListener(this);
        storageDesignSqlServer.getStoredProcedureSet().addSetListener(this);
        storageDesignSqlServer.getDistinctTypeProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DB";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogSqlServer dataBasePropertyDialogSqlServer = new DataBasePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dataBasePropertyDialogSqlServer.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 9;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.filegroups;
            }
            case 1: {
                return this.transactionLogs;
            }
            case 2: {
                return this.defaults;
            }
            case 3: {
                return this.users;
            }
            case 4: {
                return this.roles;
            }
            case 5: {
                return this.rules;
            }
            case 6: {
                return this.tables;
            }
            case 7: {
                return this.views;
            }
            case 8: {
                return this.procedures;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.filegroups) {
            return 0;
        }
        if (modelObject == this.transactionLogs) {
            return 1;
        }
        if (modelObject == this.defaults) {
            return 2;
        }
        if (modelObject == this.users) {
            return 3;
        }
        if (modelObject == this.roles) {
            return 4;
        }
        if (modelObject == this.rules) {
            return 5;
        }
        if (modelObject == this.tables) {
            return 6;
        }
        if (modelObject == this.views) {
            return 7;
        }
        if (modelObject == this.procedures) {
            return 8;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.filegroups) {
            return 0;
        }
        if (object == this.transactionLogs) {
            return 1;
        }
        if (object == this.defaults) {
            return 2;
        }
        if (object == this.users) {
            return 3;
        }
        if (object == this.roles) {
            return 4;
        }
        if (object == this.rules) {
            return 5;
        }
        if (object == this.tables) {
            return 6;
        }
        if (object == this.views) {
            return 7;
        }
        if (object == this.procedures) {
            return 8;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.filegroups.removeAll();
        this.transactionLogs.removeAll();
        this.defaults.removeAll();
        this.users.removeAll();
        this.roles.removeAll();
        this.rules.removeAll();
        this.tables.removeAll();
        this.views.removeAll();
        this.procedures.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)modelObjectSetEvent.getAffected();
                dataFileSqlServer.addObjectListener(this);
                if (dataFileSqlServer.getDataBase() != null && dataFileSqlServer.getDataBase() == this) {
                    dataFileSqlServer.setParent(this.transactionLogs);
                    this.transactionLogs.add(dataFileSqlServer);
                } else {
                    this.transactionLogs.remove(dataFileSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)modelObjectSetEvent.getAffected();
                fileGroupSqlServer.addObjectListener(this);
                if (fileGroupSqlServer.getDataBase() != null && fileGroupSqlServer.getDataBase() == this) {
                    fileGroupSqlServer.setParent(this.filegroups);
                    this.filegroups.add(fileGroupSqlServer);
                } else {
                    this.filegroups.remove(fileGroupSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer defaultSqlServer = (DefaultSqlServer)modelObjectSetEvent.getAffected();
                defaultSqlServer.addObjectListener(this);
                if (defaultSqlServer.getDataBase() != null && defaultSqlServer.getDataBase() == this) {
                    defaultSqlServer.setParent(this.defaults);
                    this.defaults.add(defaultSqlServer);
                } else {
                    this.defaults.remove(defaultSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof UserSqlServer) {
                UserSqlServer userSqlServer = (UserSqlServer)modelObjectSetEvent.getAffected();
                userSqlServer.addObjectListener(this);
                if (userSqlServer.getDatabase() != null && userSqlServer.getDatabase() == this) {
                    userSqlServer.setParent(this.users);
                    this.users.add(userSqlServer);
                } else {
                    this.users.remove(userSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer roleSqlServer = (RoleSqlServer)modelObjectSetEvent.getAffected();
                roleSqlServer.addObjectListener(this);
                if (roleSqlServer.getDatabase() != null && roleSqlServer.getDatabase() == this) {
                    roleSqlServer.setParent(this.roles);
                    this.roles.add(roleSqlServer);
                } else {
                    this.roles.remove(roleSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer ruleSqlServer = (RuleSqlServer)modelObjectSetEvent.getAffected();
                ruleSqlServer.addObjectListener(this);
                if (ruleSqlServer.getDatabase() != null && ruleSqlServer.getDatabase() == this) {
                    ruleSqlServer.setParent(this.rules);
                    this.rules.add(ruleSqlServer);
                } else {
                    this.rules.remove(ruleSqlServer);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)modelObjectSetEvent.getAffected();
                storedProcedureSqlServer.addObjectListener(this);
                if (storedProcedureSqlServer.getDatabase() != null && storedProcedureSqlServer.getDatabase() == this) {
                    storedProcedureSqlServer.setParent(this.procedures);
                    this.procedures.add(storedProcedureSqlServer);
                } else {
                    this.procedures.remove(storedProcedureSqlServer);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)modelObjectSetEvent.getAffected();
                this.transactionLogs.remove(dataFileSqlServer);
                dataFileSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)modelObjectSetEvent.getAffected();
                this.filegroups.remove(fileGroupSqlServer);
                fileGroupSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer defaultSqlServer = (DefaultSqlServer)modelObjectSetEvent.getAffected();
                this.defaults.remove(defaultSqlServer);
                defaultSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof UserSqlServer) {
                UserSqlServer userSqlServer = (UserSqlServer)modelObjectSetEvent.getAffected();
                this.users.remove(userSqlServer);
                userSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer roleSqlServer = (RoleSqlServer)modelObjectSetEvent.getAffected();
                this.roles.remove(roleSqlServer);
                roleSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer ruleSqlServer = (RuleSqlServer)modelObjectSetEvent.getAffected();
                this.rules.remove(ruleSqlServer);
                ruleSqlServer.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)modelObjectSetEvent.getAffected();
                this.procedures.remove(storedProcedureSqlServer);
                storedProcedureSqlServer.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof DataFileSqlServer) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)objectChangeEvent.getAffected();
            if (dataFileSqlServer.getDataBase() != null && dataFileSqlServer.getDataBase() == this) {
                dataFileSqlServer.setParent(this.transactionLogs);
                this.transactionLogs.add(dataFileSqlServer);
            } else {
                this.transactionLogs.remove(dataFileSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof FileGroupSqlServer) {
            FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)objectChangeEvent.getAffected();
            if (fileGroupSqlServer.getDataBase() != null && fileGroupSqlServer.getDataBase() == this) {
                fileGroupSqlServer.setParent(this.filegroups);
                this.filegroups.add(fileGroupSqlServer);
            } else {
                this.filegroups.remove(fileGroupSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof DefaultSqlServer) {
            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)objectChangeEvent.getAffected();
            if (defaultSqlServer.getDataBase() != null && defaultSqlServer.getDataBase() == this) {
                defaultSqlServer.setParent(this.defaults);
                this.defaults.add(defaultSqlServer);
            } else {
                this.defaults.remove(defaultSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof UserSqlServer) {
            UserSqlServer userSqlServer = (UserSqlServer)objectChangeEvent.getAffected();
            if (userSqlServer.getDatabase() != null && userSqlServer.getDatabase() == this) {
                userSqlServer.setParent(this.users);
                this.users.add(userSqlServer);
            } else {
                this.users.remove(userSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof RoleSqlServer) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)objectChangeEvent.getAffected();
            if (roleSqlServer.getDatabase() != null && roleSqlServer.getDatabase() == this) {
                roleSqlServer.setParent(this.roles);
                this.roles.add(roleSqlServer);
            } else {
                this.roles.remove(roleSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof RuleSqlServer) {
            RuleSqlServer ruleSqlServer = (RuleSqlServer)objectChangeEvent.getAffected();
            if (ruleSqlServer.getDatabase() != null && ruleSqlServer.getDatabase() == this) {
                ruleSqlServer.setParent(this.rules);
                this.rules.add(ruleSqlServer);
            } else {
                this.rules.remove(ruleSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof StoredProcedureSqlServer) {
            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)objectChangeEvent.getAffected();
            if (storedProcedureSqlServer.getDatabase() != null && storedProcedureSqlServer.getDatabase() == this) {
                storedProcedureSqlServer.setParent(this.procedures);
                this.procedures.add(storedProcedureSqlServer);
            } else {
                this.procedures.remove(storedProcedureSqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof TableProxy) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)objectChangeEvent.getAffected();
            if (tableProxySqlServer.getDatabase() != null && tableProxySqlServer.getDatabase() == this) {
                StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableProxySqlServer);
                storageObjectPlaceHolder.setParent(this.tables);
                storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                this.tables.add(storageObjectPlaceHolder);
            } else if (tableProxySqlServer.getDatabase() == null || tableProxySqlServer.getDatabase() != null && tableProxySqlServer.getDatabase() != this) {
                this.tables.removePlaceHolderFor(tableProxySqlServer);
            }
        } else if (objectChangeEvent.getAffected() instanceof TableViewProxy) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)objectChangeEvent.getAffected();
            if (tableViewProxySqlServer.getDataBase() != null && tableViewProxySqlServer.getDataBase() == this) {
                StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableViewProxySqlServer);
                storageObjectPlaceHolder.setParent(this.views);
                this.views.add(storageObjectPlaceHolder);
                storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
            } else if (tableViewProxySqlServer.getDataBase() == null || tableViewProxySqlServer.getDataBase() != null && tableViewProxySqlServer.getDataBase() != this) {
                this.views.removePlaceHolderFor(tableViewProxySqlServer);
            }
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TableProxy) {
                TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)modelObjectSetEvent.getAffected();
                tableProxySqlServer.addObjectListener(this);
                if (this == tableProxySqlServer.getDatabase()) {
                    StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableProxySqlServer);
                    storageObjectPlaceHolder.setParent(this.tables);
                    storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                    this.tables.add(storageObjectPlaceHolder);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)modelObjectSetEvent.getAffected();
                tableViewProxySqlServer.addObjectListener(this);
                if (this == tableViewProxySqlServer.getDataBase()) {
                    StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableViewProxySqlServer);
                    storageObjectPlaceHolder.setParent(this.views);
                    storageObjectPlaceHolder.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
                    this.views.add(storageObjectPlaceHolder);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TableProxy) {
                TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)modelObjectSetEvent.getAffected();
                tableProxySqlServer.removeObjectListener(this);
                this.tables.removePlaceHolderFor(tableProxySqlServer);
            } else if (modelObjectSetEvent.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)modelObjectSetEvent.getAffected();
                tableViewProxySqlServer.removeObjectListener(this);
                this.views.removePlaceHolderFor(tableViewProxySqlServer);
            }
        }
    }

    public void registerToTableProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            tableProxySqlServer.addObjectListener(this);
        }
    }

    public void registerToViewProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            tableViewProxySqlServer.addObjectListener(this);
        }
    }

    public static String[] getUserChoices() {
        return USER_STATES;
    }

    protected boolean checkUser(String string) {
        if (userSet == null) {
            userSet = new HashSet();
            userSet.addAll(Arrays.asList(DataBaseSqlServer.getUserChoices()));
        }
        return userSet.contains(string);
    }

    public static String[] getOnOffChoices() {
        return ON_OFF_STATES;
    }

    protected boolean checkOnOff(String string) {
        if (onOffSet == null) {
            onOffSet = new HashSet();
            onOffSet.addAll(Arrays.asList(DataBaseSqlServer.getOnOffChoices()));
        }
        return onOffSet.contains(string);
    }

    public static String[] getCursorDefaultChoices() {
        return CURSOR_DEFAULT_STATES;
    }

    protected boolean checkCursorDefault(String string) {
        if (cursorDefaultSet == null) {
            cursorDefaultSet = new HashSet();
            cursorDefaultSet.addAll(Arrays.asList(DataBaseSqlServer.getCursorDefaultChoices()));
        }
        return cursorDefaultSet.contains(string);
    }

    public static String[] getRecoveryChoices() {
        return RECOVERY_STATES;
    }

    protected boolean checkRecovery(String string) {
        if (recoverySet == null) {
            recoverySet = new HashSet();
            recoverySet.addAll(Arrays.asList(DataBaseSqlServer.getRecoveryChoices()));
        }
        return recoverySet.contains(string);
    }

    public String getUserState() {
        return this.userState;
    }

    public String getAnsiNulls() {
        return this.ansiNulls;
    }

    public String getAnsiPadding() {
        return this.ansiPadding;
    }

    public String getAnsiWarnings() {
        return this.ansiWarnings;
    }

    public String getArithabort() {
        return this.arithabort;
    }

    public String getAutoClose() {
        return this.autoClose;
    }

    public String getAutoCreateStatistics() {
        return this.autoCreateStatistics;
    }

    public String getAutoUpdateStatistics() {
        return this.autoUpdateStatistics;
    }

    public String getAutoShrink() {
        return this.autoShrink;
    }

    public String getConcatNullYieldsNull() {
        return this.concatNullYieldsNull;
    }

    public String getCursorCloseOnCommit() {
        return this.cursorCloseOnCommit;
    }

    public String getCursorDefault() {
        return this.cursorDefault;
    }

    public String getRecovery() {
        return this.recovery;
    }

    public String getRecursiveTriggers() {
        return this.recursiveTriggers;
    }

    public String getTornPageDetection() {
        return this.tornPageDetection;
    }

    public String getNumericRoundabort() {
        return this.numericRoundabort;
    }

    public String getQuotedIdentifier() {
        return this.quotedIdentifier;
    }

    public void setAnsiNulls(String string) {
        if (this.checkOnOff(string)) {
            this.ansiNulls = string;
            this.fireDataFieldChange();
        }
    }

    public void setAnsiPadding(String string) {
        if (this.checkOnOff(string)) {
            this.ansiPadding = string;
            this.fireDataFieldChange();
        }
    }

    public void setAnsiWarnings(String string) {
        if (this.checkOnOff(string)) {
            this.ansiWarnings = string;
            this.fireDataFieldChange();
        }
    }

    public void setArithabort(String string) {
        if (this.checkOnOff(string)) {
            this.arithabort = string;
            this.fireDataFieldChange();
        }
    }

    public void setAutoClose(String string) {
        if (this.checkOnOff(string)) {
            this.autoClose = string;
            this.fireDataFieldChange();
        }
    }

    public void setAutoCreateStatistics(String string) {
        if (this.checkOnOff(string)) {
            this.autoCreateStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public void setAutoUpdateStatistics(String string) {
        if (this.checkOnOff(string)) {
            this.autoUpdateStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public void setAutoShrink(String string) {
        if (this.checkOnOff(string)) {
            this.autoShrink = string;
            this.fireDataFieldChange();
        }
    }

    public void setConcatNullYieldsNull(String string) {
        if (this.checkOnOff(string)) {
            this.concatNullYieldsNull = string;
            this.fireDataFieldChange();
        }
    }

    public void setCursorCloseOnCommit(String string) {
        if (this.checkOnOff(string)) {
            this.cursorCloseOnCommit = string;
            this.fireDataFieldChange();
        }
    }

    public void setCursorDefault(String string) {
        if (this.checkCursorDefault(string)) {
            this.cursorDefault = string;
            this.fireDataFieldChange();
        }
    }

    public void setNumericRoundabort(String string) {
        if (this.checkOnOff(string)) {
            this.numericRoundabort = string;
            this.fireDataFieldChange();
        }
    }

    public void setQuotedIdentifier(String string) {
        if (this.checkOnOff(string)) {
            this.quotedIdentifier = string;
            this.fireDataFieldChange();
        }
    }

    public void setRecovery(String string) {
        if (this.checkRecovery(string)) {
            this.recovery = string;
            this.fireDataFieldChange();
        }
    }

    public void setRecursiveTriggers(String string) {
        if (this.checkOnOff(string)) {
            this.recursiveTriggers = string;
            this.fireDataFieldChange();
        }
    }

    public void setUserState(String string) {
        if (this.checkUser(string)) {
            this.userState = string;
            this.fireDataFieldChange();
        }
    }

    public void setTornPageDetection(String string) {
        if (this.checkOnOff(string)) {
            this.tornPageDetection = string;
            this.fireDataFieldChange();
        }
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String string) {
        if (string != null) {
            this.collationName = string;
            this.fireDataFieldChange();
        }
    }

    public StorageObjectCollection getDefaults() {
        return this.defaults;
    }

    public StorageObjectCollection getFilegroups() {
        return this.filegroups;
    }

    public StorageObjectCollection getProcedures() {
        return this.procedures;
    }

    public StorageObjectCollection getRoles() {
        return this.roles;
    }

    public StorageObjectCollection getRules() {
        return this.rules;
    }

    public StorageObjectCollection getTables() {
        return this.tables;
    }

    public StorageObjectCollection getTransactionLogs() {
        return this.transactionLogs;
    }

    public StorageObjectCollection getUsers() {
        return this.users;
    }

    public StorageObjectCollection getViews() {
        return this.views;
    }

    public StorageObjectCollection getSchemas() {
        return null;
    }

    public FileGroupSqlServer createFilegroup() {
        if (this.filegroups.getStorageObjectSet() != null) {
            return (FileGroupSqlServer)this.filegroups.createElement(null);
        }
        return null;
    }

    public DataFileSqlServer createTransactionLog() {
        if (this.transactionLogs.getStorageObjectSet() != null) {
            return (DataFileSqlServer)this.transactionLogs.createElement(null);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.transactionLogs.addAllElementsTo(arrayList);
            this.filegroups.addAllElementsTo(arrayList);
            this.defaults.addAllElementsTo(arrayList);
            this.users.addAllElementsTo(arrayList);
            this.roles.addAllElementsTo(arrayList);
            this.rules.addAllElementsTo(arrayList);
            this.procedures.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    @Override
    public void setIsNullInstance(boolean bl) {
        super.setIsNullInstance(bl);
        this.filegroups.setForbiddenCreateElement(bl);
        this.transactionLogs.setForbiddenCreateElement(bl);
    }

    @Override
    public void setObjectID(String string) {
        UserSqlServer userSqlServer;
        super.setObjectID(string);
        String string2 = this.getObjectID();
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.getStorageDesign();
        RoleSqlServer roleSqlServer = (RoleSqlServer)storageDesignSqlServer.getRoleSet().getByNameAndDatabase("PUBLIC", this);
        if (roleSqlServer != null) {
            roleSqlServer.setObjectID(string2 + "_" + "PUBLIC");
        }
        if ((userSqlServer = (UserSqlServer)storageDesignSqlServer.getUserSet().getByNameAndDatabase("dbo", this)) != null) {
            userSqlServer.setObjectID(string2 + "_" + "dbo");
        }
    }
}

