/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TableSpacePropertyDialogOraclev9i;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceOraclev9i
extends TableSpaceOracle {
    private int blockSize;
    private static Set segManageSet = null;
    private String segmentManagement = SEGMENT_MANAGE_STATES[0];
    private static final String[] SEGMENT_MANAGE_STATES = new String[]{"", "MANUAL", "AUTO"};
    private String forceLogging = "NO";
    private List propertyWrapperList = null;

    public TableSpaceOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
        this.extentManagement = EXTEND_MANAGE_STATES[1];
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
        this.fireDataFieldChange();
    }

    public String getSegmentManagement() {
        return this.segmentManagement;
    }

    public void setSegmentManagement(String string) {
        if (this.checkSegManageState(string)) {
            this.segmentManagement = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkSegManageState(String string) {
        if (segManageSet == null) {
            segManageSet = new HashSet();
            segManageSet.addAll(Arrays.asList(TableSpaceOraclev9i.getSegManageStates()));
        }
        return segManageSet.contains(string);
    }

    public static String[] getSegManageStates() {
        return SEGMENT_MANAGE_STATES;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogOraclev9i tableSpacePropertyDialogOraclev9i = new TableSpacePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableSpacePropertyDialogOraclev9i.show();
        }
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public void setForceLogging(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.forceLogging = string;
            this.fireDataFieldChange();
        }
    }

    public String getManagedFiles() {
        if (this.getDfiles().toArray().length == 0) {
            return "NO";
        }
        return "YES";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Min Ext Len", this, "getMinExtLen", "setMinExtLen", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Block Size", this, "getBlockSize", "setBlockSize", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Logging", this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Force Logging", this, "getForceLogging", "setForceLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Status", this, "getStatus", "setStatus", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Contents", this, "getContents", "setContents", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("DS Initial Extent", this, "getDSInitialExtent", "setDSInitialExtent", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("DS Next Extent", this, "getDSNextExtent", "setDSNextExtent", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("DS Min Extents", this, "getDSMinExtents", "setDSMinExtents", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("DS Max Extents", this, "getDSMaxExtents", "setDSMaxExtents", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("DS PCT Increase", this, "getDSPctIncrease", "setDSPctIncrease", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Ext Management", this, "getExtentManagement", "setExtentManagement", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("EM Local SubType", this, "getEMLocalSubtype", "setEMLocalSubtype", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("EM Uniform Size", this, "getEMUniformSize", "setEMUniformSize", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Segment Management", this, "getSegmentManagement", "setSegmentManagement", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TableSpaceOraclev9i tableSpaceOraclev9i = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev9i)storageDesign).getTableSpaceSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                tableSpaceOraclev9i = (TableSpaceOraclev9i)storageObject;
            }
        } else {
            tableSpaceOraclev9i = (TableSpaceOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpaceOraclev9i != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            StorageObject storageObject4;
            tableSpaceOraclev9i.setObjectID(this.getObjectID());
            tableSpaceOraclev9i.setName(this.getName());
            Iterator iterator = this.getTabcoll().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (StorageObjectPlaceHolder)iterator.next();
                storageObject3 = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableProxySet()).getByName(((StorageObjectPlaceHolder)storageObject4).getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableProxySet()).createProxy(storageObject4.getGenerator());
                    ((RelationalObjectProxy)storageObject2).setName(((StorageObjectPlaceHolder)storageObject4).getName());
                    ((TableProxyOracle)storageObject2).setTableSpace(tableSpaceOraclev9i);
                    storageObject2.setRawObject(true);
                    tableSpaceOraclev9i.registerToTableProxyFromDesign(((StorageDesignOraclev9i)storageDesign).getTableProxySet());
                    continue;
                }
                ((TableProxyOracle)storageObject3).setTableSpace(tableSpaceOraclev9i);
                tableSpaceOraclev9i.registerToTableProxyFromDesign(((StorageDesignOraclev9i)storageDesign).getTableProxySet());
            }
            iterator = this.getDfiles().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (DataFileOraclev9i)iterator.next();
                storageObject3 = (DataFileOraclev9i)((StorageDesignOraclev9i)storageDesign).getDataFileSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (DataFileOraclev9i)((StorageDesignOraclev9i)storageDesign).getDataFileSet().createDataFile();
                    storageObject2.setName(storageObject4.getName());
                    ((DataFileOracle)storageObject2).setTableSpace(tableSpaceOraclev9i);
                    storageObject2.setRawObject(true);
                    tableSpaceOraclev9i.getDfiles().add(storageObject2);
                    continue;
                }
                ((DataFileOracle)storageObject3).setTableSpace(tableSpaceOraclev9i);
                tableSpaceOraclev9i.getDfiles().add(storageObject3);
            }
            tableSpaceOraclev9i.setMinExtLen(this.getMinExtLen());
            tableSpaceOraclev9i.setBlockSize(this.getBlockSize());
            tableSpaceOraclev9i.setLogging(this.getLogging());
            tableSpaceOraclev9i.setForceLogging(this.getForceLogging());
            tableSpaceOraclev9i.setStatus(this.getStatus());
            tableSpaceOraclev9i.setContents(this.getContents());
            tableSpaceOraclev9i.setDSInitialExtent(this.getDSInitialExtent());
            tableSpaceOraclev9i.setDSNextExtent(this.getDSNextExtent());
            tableSpaceOraclev9i.setDSMinExtents(this.getDSMinExtents());
            tableSpaceOraclev9i.setDSMaxExtents(this.getDSMaxExtents());
            tableSpaceOraclev9i.setDSPctIncrease(this.getDSPctIncrease());
            tableSpaceOraclev9i.setExtentManagement(this.getExtentManagement());
            tableSpaceOraclev9i.setEMLocalSubtype(this.getEMLocalSubtype());
            tableSpaceOraclev9i.setEMUniformSize(this.getEMUniformSize());
            tableSpaceOraclev9i.setSegmentManagement(this.getSegmentManagement());
            tableSpaceOraclev9i.setComment(this.getComment());
            tableSpaceOraclev9i.setRawObject(false);
        }
    }
}

