/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableCheckConstraintOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableCheckConstraintSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TriggerOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TablePropertyDialogOraclev9i;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyOraclev9i
extends TableProxyOracle
implements TableCheckConstraintListener {
    protected String suplementalLogGroupName = "";
    protected String suplementalLogConditions = suplementalLogConditionChoices[0];
    protected String IOTMappingTable = "NO";
    public static String[] suplementalLogConditionChoices = new String[]{"ON UPDATE", "ALWAYS"};
    private static Set suplementalLogConditionsSet = null;
    protected String suplementalLogColumns = "";
    protected TableProxyOracle.InlineList suplementalLogColumnSet = null;
    private String partitioned = "NO";
    private String partType = "";
    private String subpartType = "";
    private List propertyWrapperList = null;

    public TableProxyOraclev9i(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxyOraclev9i(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            try {
                TablePropertyDialogOraclev9i tablePropertyDialogOraclev9i = new TablePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
                tablePropertyDialogOraclev9i.show();
            }
            catch (RuntimeException runtimeException) {
                this.setDialogVisible(false, null);
            }
        }
    }

    public TableProxyOracle.InlineList getSuplementalLogColumnSet() {
        if (this.suplementalLogColumnSet == null) {
            this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        }
        return this.suplementalLogColumnSet;
    }

    public void clearSuplementalLogColumns() {
        this.getSuplementalLogColumnSet().removeAllElements();
        this.suplementalLogColumns = "";
    }

    public String getSuplementalLogColumns() {
        return this.suplementalLogColumns;
    }

    public String getAllSuplementalLogColumns() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.suplementalLogColumns, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            ColumnProxy columnProxy = this.getColumnProxy(string);
            if (columnProxy == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(columnProxy.getLongName());
        }
        return stringBuffer.toString();
    }

    public void setSuplementalLogColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSuplementalLogColumnSet(string);
        } else {
            this.addSuplementalLogColumn(string);
        }
        this.suplementalLogColumns = this.getSuplementalLogColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addSuplementalLogColumn(String string) {
        this.getSuplementalLogColumnSet().add(string);
    }

    private void recreateSuplementalLogColumnSet(String string) {
        this.getSuplementalLogColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getSuplementalLogColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)objectChangeEvent.getAffected();
            if (lobStorageOracle.getTable() == this) {
                lobStorageOracle.setParent(this.lobs);
                this.lobs.add(lobStorageOracle);
            } else {
                this.lobs.remove(lobStorageOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof PartitionOracle) {
            PartitionOracle partitionOracle = (PartitionOracle)objectChangeEvent.getAffected();
            if (partitionOracle.getPartitionList() == this.partitionList && this.partitionList != null) {
                partitionOracle.setParent(this.partitions);
                this.partitions.add(partitionOracle);
                if (partitionOracle.getPosition() == 0) {
                    partitionOracle.removeObjectListener(this);
                    partitionOracle.setPosition(this.partitions.size());
                    partitionOracle.addObjectListener(this);
                }
            } else {
                this.partitions.remove(partitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListStorageTemplatePartitionOraclev9i) {
            ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)objectChangeEvent.getAffected();
            if (listStorageTemplatePartitionOraclev9i.getPartOfStorageTable() == this) {
                listStorageTemplatePartitionOraclev9i.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(listStorageTemplatePartitionOraclev9i);
            } else {
                this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev9i);
            }
        } else if (objectChangeEvent.getAffected() instanceof HashPartitionOraclev9i) {
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)objectChangeEvent.getAffected();
            if (hashPartitionOraclev9i.getPartitionList() != null && hashPartitionOraclev9i.getPartitionList() == this.getPartitionList() && hashPartitionOraclev9i.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                hashPartitionOraclev9i.setParent(this.partitions);
                this.partitions.add(hashPartitionOraclev9i);
            } else {
                this.partitions.remove(hashPartitionOraclev9i);
            }
            if (hashPartitionOraclev9i.getPartOfStorageTable() == this) {
                hashPartitionOraclev9i.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(hashPartitionOraclev9i);
            } else {
                this.listStorageTemplates.remove(hashPartitionOraclev9i);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListPartitionOraclev9i) {
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)objectChangeEvent.getAffected();
            if (listPartitionOraclev9i.getPartitionList() != null && listPartitionOraclev9i.getPartitionList() == this.getPartitionList()) {
                listPartitionOraclev9i.setParent(this.partitions);
                this.partitions.add(listPartitionOraclev9i);
            } else {
                this.partitions.remove(listPartitionOraclev9i);
            }
        } else if (objectChangeEvent.getAffected() instanceof BitmapJoinIndexOraclev9i) {
            BitmapJoinIndexOraclev9i bitmapJoinIndexOraclev9i = (BitmapJoinIndexOraclev9i)objectChangeEvent.getAffected();
            if (bitmapJoinIndexOraclev9i.getTable() == this) {
                bitmapJoinIndexOraclev9i.setParent(this.bjIndexes);
                this.bjIndexes.add(bitmapJoinIndexOraclev9i);
            } else {
                this.bjIndexes.remove(bitmapJoinIndexOraclev9i);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                lobStorageOracle.addObjectListener(this);
                if (lobStorageOracle.getTable() == this) {
                    lobStorageOracle.setParent(this.lobs);
                    this.lobs.add(lobStorageOracle);
                } else {
                    this.lobs.remove(lobStorageOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
                PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
                partitionOracle.addObjectListener(this);
                if (partitionOracle.getPartitionList() != null && partitionOracle.getPartitionList() == this.getPartitionList()) {
                    partitionOracle.setParent(this.partitions);
                    this.partitions.add(partitionOracle);
                    partitionOracle.removeObjectListener(this);
                    partitionOracle.setPosition(this.partitions.size());
                    partitionOracle.addObjectListener(this);
                } else if (this.partitions.remove(partitionOracle)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject modelObject = this.partitions.getElement(i);
                        if (!(modelObject instanceof PartitionOracle)) continue;
                        ((PartitionOracle)modelObject).setPosition(i + 1);
                    }
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOraclev9i) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)modelObjectSetEvent.getAffected();
                listStorageTemplatePartitionOraclev9i.addObjectListener(this);
                if (listStorageTemplatePartitionOraclev9i.getPartOfStorageTable() == this) {
                    listStorageTemplatePartitionOraclev9i.setParent(this.listStorageTemplates);
                    this.listStorageTemplates.add(listStorageTemplatePartitionOraclev9i);
                } else {
                    this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev9i);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof HashPartitionOraclev9i) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)modelObjectSetEvent.getAffected();
                hashPartitionOraclev9i.addObjectListener(this);
                if (hashPartitionOraclev9i.getPartitionList() != null && hashPartitionOraclev9i.getPartitionList() == this.getPartitionList() && hashPartitionOraclev9i.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                    hashPartitionOraclev9i.setParent(this.partitions);
                } else if (hashPartitionOraclev9i.getPartOfStorageTable() == this) {
                    hashPartitionOraclev9i.setParent(this.partitions);
                    this.partitions.add(hashPartitionOraclev9i);
                } else {
                    this.partitions.remove(hashPartitionOraclev9i);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListPartitionOraclev9i) {
                ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)modelObjectSetEvent.getAffected();
                listPartitionOraclev9i.addObjectListener(this);
                if (listPartitionOraclev9i.getPartitionList() != null && listPartitionOraclev9i.getPartitionList() == this.getPartitionList()) {
                    listPartitionOraclev9i.setParent(this.partitions);
                    this.partitions.add(listPartitionOraclev9i);
                } else {
                    this.partitions.remove(listPartitionOraclev9i);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof BitmapJoinIndexOraclev9i) {
                BitmapJoinIndexOraclev9i bitmapJoinIndexOraclev9i = (BitmapJoinIndexOraclev9i)modelObjectSetEvent.getAffected();
                bitmapJoinIndexOraclev9i.addObjectListener(this);
                if (bitmapJoinIndexOraclev9i.getTable() == this) {
                    bitmapJoinIndexOraclev9i.setParent(this.bjIndexes);
                    this.bjIndexes.add(bitmapJoinIndexOraclev9i);
                } else {
                    this.bjIndexes.remove(bitmapJoinIndexOraclev9i);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                this.lobs.remove(lobStorageOracle);
                lobStorageOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
                PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
                if (this.partitions.remove(partitionOracle)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject modelObject = this.partitions.getElement(i);
                        if (!(modelObject instanceof PartitionOracle)) continue;
                        ((PartitionOracle)modelObject).setPosition(i + 1);
                    }
                }
                partitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOraclev9i) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)modelObjectSetEvent.getAffected();
                this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev9i);
                listStorageTemplatePartitionOraclev9i.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                this.partitions.remove(hashPartitionOracle);
                this.listStorageTemplates.remove(hashPartitionOracle);
                hashPartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof ListPartitionOraclev9i) {
                ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)modelObjectSetEvent.getAffected();
                this.partitions.remove(listPartitionOraclev9i);
                listPartitionOraclev9i.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof BitmapJoinIndexOraclev9i) {
                BitmapJoinIndexOraclev9i bitmapJoinIndexOraclev9i = (BitmapJoinIndexOraclev9i)modelObjectSetEvent.getAffected();
                this.bjIndexes.remove(bitmapJoinIndexOraclev9i);
                bitmapJoinIndexOraclev9i.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(TableLevelConstraint tableLevelConstraint, TableLevelConstraintEvent tableLevelConstraintEvent) {
        if (tableLevelConstraintEvent.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED)) {
            StorageDesignOraclev9i storageDesignOraclev9i = (StorageDesignOraclev9i)this.getStorageDesign();
            TableCheckConstraintSetOraclev9i tableCheckConstraintSetOraclev9i = (TableCheckConstraintSetOraclev9i)storageDesignOraclev9i.getTableCheckConstraintSet();
            tableCheckConstraintSetOraclev9i.addTableCheckConstraint(this, tableLevelConstraint);
            this.setDirty(true);
        } else if (tableLevelConstraintEvent.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED)) {
            StorageDesignOraclev9i storageDesignOraclev9i = (StorageDesignOraclev9i)this.getStorageDesign();
            TableCheckConstraintSetOraclev9i tableCheckConstraintSetOraclev9i = (TableCheckConstraintSetOraclev9i)storageDesignOraclev9i.getTableCheckConstraintSet();
            tableCheckConstraintSetOraclev9i.removeTableCheckConstraint(this, tableLevelConstraint);
            this.setDirty(true);
        }
    }

    @Override
    protected void addTableCheckConstraintFromDesign(TableCheckConstraintSetOracle tableCheckConstraintSetOracle) {
        ModelIDObject modelIDObject;
        Iterator iterator = tableCheckConstraintSetOracle.iterator();
        while (iterator.hasNext()) {
            modelIDObject = (TableCheckConstraintOracle)iterator.next();
            if (((TableCheckConstraintOracle)modelIDObject).getTable() == null || ((TableCheckConstraintOracle)modelIDObject).getTable() != this || TableProxyOraclev9i.containsTCCWithID(this.tableCheckConstraints, modelIDObject.getObjectID())) continue;
            modelIDObject.setParent(this.tableCheckConstraints);
            this.tableCheckConstraints.add(modelIDObject);
        }
        modelIDObject = (Table)this.getObject();
        for (TableLevelConstraint tableLevelConstraint : ((Table)modelIDObject).getCheckConstraints()) {
            ((TableCheckConstraintSetOraclev9i)tableCheckConstraintSetOracle).addTableCheckConstraint(this, tableLevelConstraint);
            this.fireDataFieldChange();
        }
        this.fireDataFieldChange();
    }

    public String getIOTMappingTable() {
        return this.IOTMappingTable;
    }

    public void setIOTMappingTable(String string) {
        this.IOTMappingTable = string;
        this.fireDataFieldChange();
    }

    public String getSuplementalLogConditions() {
        return this.suplementalLogConditions;
    }

    public void setSuplementalLogConditions(String string) {
        if (this.checkSuplementalLogConditions(string)) {
            this.suplementalLogConditions = string;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkSuplementalLogConditions(String string) {
        if (suplementalLogConditionsSet == null) {
            suplementalLogConditionsSet = new HashSet();
            suplementalLogConditionsSet.addAll(Arrays.asList(suplementalLogConditionChoices));
        }
        return suplementalLogConditionsSet.contains(string);
    }

    public String getSuplementalLogGroupName() {
        return this.suplementalLogGroupName;
    }

    public void setSuplementalLogGroupName(String string) {
        this.suplementalLogGroupName = string;
        this.fireDataFieldChange();
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionListOracle) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)partitionListOracle;
        String string = "";
        String string2 = "";
        if (partitionListOraclev9i != null) {
            string = partitionListOraclev9i.getPartitionType();
            if (string.equalsIgnoreCase("COMPOSITE BY HASH") || string.equalsIgnoreCase("COMPOSITE BY LIST")) {
                string = "RANGE";
            }
            string2 = partitionListOraclev9i.getSubpartitionType();
        }
        if (this.partitionList != null) {
            if (!this.partType.equalsIgnoreCase(string)) {
                this.partitions.removeAll();
            }
            if (!this.subpartType.equalsIgnoreCase(string2)) {
                this.listStorageTemplates.removeAll();
            }
        }
        this.partType = string;
        this.subpartType = string2;
        this.partitionList = partitionListOraclev9i;
        if (this.partitionList == null) {
            this.partitions.setForbiddenCreateElement(true);
            this.listStorageTemplates.setForbiddenCreateElement(true);
        } else {
            this.partitionList.setTable(this);
            this.partitioned = "YES";
            if (this.partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                this.partitions.setForbiddenCreateElement(true);
            } else {
                this.partitions.setForbiddenCreateElement(false);
                this.partitions.setLogicalParent(partitionListOraclev9i);
            }
            if (this.partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.partType.equalsIgnoreCase("LIST")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getListPartitionSet());
                this.addListPartFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getListPartitionSet());
            } else {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getPartitionSet());
                this.addPartFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getPartitionSet());
            }
            if ("NO".equalsIgnoreCase(partitionListOraclev9i.getUseSubpartStorageTemplate())) {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            } else if (this.subpartType.equalsIgnoreCase("HASH")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesignToTemplates(((StorageDesignOraclev9i)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.subpartType.equalsIgnoreCase("LIST")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev9i)this.getStorageDesign()).getListStorageTemplatePartitionSet());
                this.addStorageTemplatePartitionsFromDesign(((StorageDesignOraclev9i)this.getStorageDesign()).getListStorageTemplatePartitionSet());
            } else {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    @Override
    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    @Override
    public void setPartitioned(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.partitioned = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getPartitioned() {
        return this.partitioned;
    }

    private void addHashPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
            if (hashPartitionOraclev9i.getPartitionList() == this.partitionList && this.partitionList != null) {
                hashPartitionOraclev9i.addObjectListener(this);
                hashPartitionOraclev9i.setParent(this.partitions);
                this.partitions.add(hashPartitionOraclev9i);
                continue;
            }
            this.partitions.remove(hashPartitionOraclev9i);
        }
    }

    private void addListPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (listPartitionOraclev9i.getPartitionList() == this.partitionList && this.partitionList != null) {
                listPartitionOraclev9i.addObjectListener(this);
                listPartitionOraclev9i.setParent(this.partitions);
                this.partitions.add(listPartitionOraclev9i);
                continue;
            }
            this.partitions.remove(listPartitionOraclev9i);
        }
    }

    private void addStorageTemplatePartitionsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)iterator.next();
            if (listStorageTemplatePartitionOraclev9i.getPartOfStorageTable() == this) {
                listStorageTemplatePartitionOraclev9i.addObjectListener(this);
                listStorageTemplatePartitionOraclev9i.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(listStorageTemplatePartitionOraclev9i);
                continue;
            }
            this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev9i);
        }
    }

    private void addHashPartFromDesignToTemplates(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
            if (hashPartitionOraclev9i.getPartOfStorageTable() == this) {
                hashPartitionOraclev9i.addObjectListener(this);
                hashPartitionOraclev9i.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(hashPartitionOraclev9i);
                continue;
            }
            this.listStorageTemplates.remove(hashPartitionOraclev9i);
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("User", this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Temporary", this, "getTemporary", "setTemporary", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Preserve Rows", this, "getTempPreserveRows", "setTempPreserveRows", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Organization", this, "getOrganization", "setOrganization", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", ClusterOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Logging", this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Storage", this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Monitoring", this, "getMonitoring", "setMonitoring", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Parallel", this, "getParallel", "setParallel", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Degree", this, "getDegree", "setDegree", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Row Dependency", this, "getRowDependency", "setRowDependency", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Row Movement", this, "getParttitionedRowMovement", "setParttitionedRowMovement", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Compression", this, "getDataSegmentCompression", "setDataSegmentCompression", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Table table = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyOraclev9i tableProxyOraclev9i = null;
        RelationalObjectProxy relationalObjectProxy = storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableProxyOraclev9i = (TableProxyOraclev9i)relationalObjectProxy;
        }
        if (tableProxyOraclev9i != null) {
            StorageObject storageObject;
            StorageObject storageObject2;
            StorageObject storageObject3;
            tableProxyOraclev9i.setName(this.getName());
            Iterator iterator = this.getTableCheckConstraints().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TableCheckConstraintOraclev9i)iterator.next();
                storageObject2 = (TableCheckConstraintOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableCheckConstraintSet().getByName(((TableCheckConstraintOracle)storageObject3).getName());
                if (storageObject2 == null) {
                    storageObject = (TableCheckConstraintOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableCheckConstraintSet().createTableCheckConstraint();
                    ((TableCheckConstraintOracle)storageObject).setName(((TableCheckConstraintOracle)storageObject3).getName());
                    storageObject.setRawObject(true);
                    ((TableCheckConstraintOracle)storageObject).setTable(tableProxyOraclev9i);
                    tableProxyOraclev9i.addTableCheckConstraintFromDesign(((StorageDesignOraclev9i)storageDesign).getTableCheckConstraintSet());
                    continue;
                }
                ((TableCheckConstraintOracle)storageObject2).setTable(tableProxyOraclev9i);
                tableProxyOraclev9i.addTableCheckConstraintFromDesign(((StorageDesignOraclev9i)storageDesign).getTableCheckConstraintSet());
            }
            iterator = this.getBjIndexes().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (BitmapJoinIndexOraclev9i)iterator.next();
                storageObject2 = (BitmapJoinIndexOraclev9i)((StorageDesignOraclev9i)storageDesign).getBitmapJoinIndexSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (BitmapJoinIndexOraclev9i)((StorageDesignOraclev9i)storageDesign).getBitmapJoinIndexSet().createBitmapJoinIndex();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((BitmapJoinIndexOracle)storageObject).setTable(tableProxyOraclev9i);
                    tableProxyOraclev9i.addBJIFromDesign(((StorageDesignOraclev9i)storageDesign).getBitmapJoinIndexSet());
                    continue;
                }
                ((BitmapJoinIndexOracle)storageObject2).setTable(tableProxyOraclev9i);
                tableProxyOraclev9i.addBJIFromDesign(((StorageDesignOraclev9i)storageDesign).getBitmapJoinIndexSet());
            }
            iterator = this.getLobStorages().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (LobStorageOraclev9i)iterator.next();
                storageObject2 = (LobStorageOraclev9i)((StorageDesignOraclev9i)storageDesign).getLobStorageSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (LobStorageOraclev9i)((StorageDesignOraclev9i)storageDesign).getLobStorageSet().createLobStorage();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((LobStorageOracle)storageObject).setTable(tableProxyOraclev9i);
                    continue;
                }
                ((LobStorageOracle)storageObject2).setTable(tableProxyOraclev9i);
            }
            iterator = this.triggers.iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TriggerOraclev9i)iterator.next();
                storageObject2 = (TriggerOraclev9i)((StorageDesignOraclev9i)storageDesign).getTriggerSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (TriggerOraclev9i)((StorageDesignOraclev9i)storageDesign).getTriggerSet().createTrigger();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((TriggerOracle)storageObject).setTable(tableProxyOraclev9i);
                    tableProxyOraclev9i.addTriggersFromDesign(((StorageDesignOraclev9i)storageDesign).getTriggerSet());
                    continue;
                }
                ((TriggerOracle)storageObject2).setTable(tableProxyOraclev9i);
                tableProxyOraclev9i.addTriggersFromDesign(((StorageDesignOraclev9i)storageDesign).getTriggerSet());
            }
            iterator = this.getUniqueKeys().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (UniqueOraclev9i)iterator.next();
                storageObject2 = (UniqueOraclev9i)((StorageDesignOraclev9i)storageDesign).getUniqueSet().getByName(((IndexProxyOracle)storageObject3).getName());
                if (storageObject2 == null) {
                    storageObject = (UniqueOraclev9i)((UniqueSetOraclev9i)((StorageDesignOraclev9i)storageDesign).getUniqueSet()).createProxy(((RelationalObjectProxy)storageObject3).getObject());
                    ((RelationalObjectProxy)storageObject).setName(((IndexProxyOracle)storageObject3).getName());
                    storageObject.setRawObject(true);
                    tableProxyOraclev9i.addIndProxiesFromDesign(((StorageDesignOraclev9i)storageDesign).getUniqueSet());
                    continue;
                }
                tableProxyOraclev9i.addIndProxiesFromDesign(((StorageDesignOraclev9i)storageDesign).getUniqueSet());
            }
            if (this.getPartitionList() != null) {
                storageObject3 = (PartitionListOraclev9i)((StorageDesignOraclev9i)storageDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (storageObject3 == null) {
                    storageObject2 = (PartitionListOraclev9i)((StorageDesignOraclev9i)storageDesign).getPartitionListSet().createPartitionList();
                    storageObject2.setName(this.getPartitionList().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev9i.setPartitionList((PartitionListOracle)storageObject2);
                } else {
                    tableProxyOraclev9i.setPartitionList((PartitionListOracle)storageObject3);
                }
            }
            if (this.getUser() != null) {
                storageObject3 = (UserOraclev9i)((StorageDesignOraclev9i)storageDesign).getUserSet().getByName(this.getUser().getName());
                if (storageObject3 == null) {
                    storageObject2 = (UserOraclev9i)((StorageDesignOraclev9i)storageDesign).getUserSet().createUser();
                    ((UserOracle)storageObject2).setName(this.getUser().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev9i.setUser((UserOracle)storageObject2);
                } else {
                    tableProxyOraclev9i.setUser((UserOracle)storageObject3);
                }
            }
            tableProxyOraclev9i.setTemporary(this.getTemporary());
            tableProxyOraclev9i.setTempPreserveRows(this.getTempPreserveRows());
            if (this.getTableSpace() != null) {
                storageObject3 = (TableSpaceOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableSpaceOraclev9i)((StorageDesignOraclev9i)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject2).setName(this.getTableSpace().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev9i.setTableSpace((TableSpaceOracle)storageObject2);
                } else {
                    tableProxyOraclev9i.setTableSpace((TableSpaceOracle)storageObject3);
                }
            }
            tableProxyOraclev9i.setOrganization(this.getOrganization());
            if (this.getCluster() != null) {
                storageObject3 = (ClusterOraclev9i)((StorageDesignOraclev9i)storageDesign).getClusterSet().getByName(this.getCluster().getName());
                if (storageObject3 == null) {
                    storageObject2 = (ClusterOraclev9i)((StorageDesignOraclev9i)storageDesign).getClusterSet().createCluster();
                    storageObject2.setName(this.getCluster().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev9i.setCluster((ClusterOracle)storageObject2);
                } else {
                    tableProxyOraclev9i.setCluster((ClusterOracle)storageObject3);
                }
            }
            tableProxyOraclev9i.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                storageObject3 = (SegmentOraclev9i)((StorageDesignOraclev9i)storageDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SegmentOraclev9i)((StorageDesignOraclev9i)storageDesign).getSegmentSet().createSegment();
                    storageObject2.setName(this.getSegment().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev9i.setSegment((SegmentOracle)storageObject2);
                } else {
                    tableProxyOraclev9i.setSegment((SegmentOracle)storageObject3);
                }
            }
            tableProxyOraclev9i.setCache(this.getCache());
            tableProxyOraclev9i.setMonitoring(this.getMonitoring());
            tableProxyOraclev9i.setParallel(this.getParallel());
            tableProxyOraclev9i.setDegree(this.getDegree());
            tableProxyOraclev9i.setRowDependency(this.getRowDependency());
            tableProxyOraclev9i.setPartitioned(this.getPartitioned());
            tableProxyOraclev9i.setParttitionedRowMovement(this.getParttitionedRowMovement());
            tableProxyOraclev9i.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getSnapshot() != null) {
                storageObject3 = (SnapshotOraclev9i)((StorageDesignOraclev9i)storageDesign).getSnapshotSet().getByName(this.getSnapshot().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SnapshotOraclev9i)((StorageDesignOraclev9i)storageDesign).getSnapshotSet().createSnapshot();
                    storageObject2.setName(this.getSnapshot().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev9i.setSnapshot((SnapshotOracle)storageObject2);
                } else {
                    tableProxyOraclev9i.setSnapshot((SnapshotOracle)storageObject3);
                }
            }
            tableProxyOraclev9i.recreateColumnsSet(this.getClusterColumnsSet().toString());
            tableProxyOraclev9i.setSuplementalLogGroupName(this.getSuplementalLogGroupName());
            tableProxyOraclev9i.setSuplementalLogConditions(this.getSuplementalLogConditions());
            tableProxyOraclev9i.recreateSuplementalLogColumnSet(this.getSuplementalLogColumnSet().toString());
            tableProxyOraclev9i.setComment(this.getComment());
            tableProxyOraclev9i.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxyOraclev9i.setRawObject(false);
        }
    }
}

