/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;

public class PartitionListOraclev9i
extends PartitionListOracle {
    private static final String COMMA = ",";
    public static final String PARTITION_TYPE_COMPOSITE_BY_HASH = "COMPOSITE BY HASH";
    public static final String PARTITION_TYPE_COMPOSITE_BY_LIST = "COMPOSITE BY LIST";
    public static final String PARTITION_TYPE_LIST = "LIST";
    private static final String[] PARTITION_TYPE = new String[]{"RANGE", "COMPOSITE BY HASH", "COMPOSITE BY LIST", "HASH BY QUANTITY", "HASH BY LIST OF PARTITIONS", "LIST"};
    public static final String SUBPARTITION_TYPE_RANGE = "RANGE";
    public static final String SUBPARTITION_TYPE_HASH = "HASH";
    public static final String SUBPARTITION_TYPE_LIST = "LIST";
    private static Set partitionTypeSet = null;
    private InlineList IOTOverflowHashPTSSet = null;
    private String IOTOverflowHashPTS = "";
    protected String useSubpartStorageTemplate = "NO";

    public PartitionListOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
    }

    public String getIOTOverflowHashPTS() {
        return this.IOTOverflowHashPTS;
    }

    public String getAllIOTOverflowHashPTS() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.IOTOverflowHashPTS, COMMA);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public void setIOTOverflowHashPTSSet(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIOTOverflowHashPTSSet(string);
        } else {
            this.addIOTOverflowHashPTS(string);
        }
        String string2 = this.getIOTOverflowHashPTSSet().toString();
        if (!this.IOTOverflowHashPTS.equals(string2)) {
            this.IOTOverflowHashPTS = string2;
            this.fireDataFieldChange();
        }
    }

    private void addIOTOverflowHashPTS(String string) {
        if (!this.getIOTOverflowHashPTSSet().contains(string)) {
            this.getIOTOverflowHashPTSSet().add(string);
        }
    }

    public void recreateIOTOverflowHashPTSSet(String string) {
        this.getIOTOverflowHashPTSSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA);
        while (stringTokenizer.hasMoreTokens()) {
            this.getIOTOverflowHashPTSSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getIOTOverflowHashPTSSet() {
        if (this.IOTOverflowHashPTSSet == null) {
            this.IOTOverflowHashPTSSet = new InlineList();
        }
        return this.IOTOverflowHashPTSSet;
    }

    public String getUseSubpartStorageTemplate() {
        return this.useSubpartStorageTemplate;
    }

    public void setUseSubpartStorageTemplate(String string) {
        if (!this.useSubpartStorageTemplate.equalsIgnoreCase(string)) {
            if (string.equalsIgnoreCase("NO") && this.getTable() != null) {
                this.getTable().disableListStorageTemplates();
            } else if (string.equalsIgnoreCase("YES") && this.getTable() != null) {
                this.getTable().enableListStorageTemplates();
            }
            this.useSubpartStorageTemplate = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.getIOTOverflowHashPTSSet().clear();
        this.IOTOverflowHashPTS = "";
    }

    @Override
    public void setSubpartitionType(String string) {
        this.subpartitionType = string;
    }

    @Override
    public void setPartitionType(String string) {
        if (!this.partitionType.equals(string) && this.checkPartitionType(string)) {
            this.partitionType = string;
            if (string.equalsIgnoreCase(PARTITION_TYPE_COMPOSITE_BY_HASH)) {
                this.setSubpartitionType(SUBPARTITION_TYPE_HASH);
                this.enableSubPartitionsForCompositeByHash();
            } else if (string.equalsIgnoreCase(PARTITION_TYPE_COMPOSITE_BY_LIST)) {
                this.setSubpartitionType("LIST");
                this.enableSubPartitionsForCompositeByList();
            } else {
                this.setSubpartitionType("");
                this.disableSubPartitionsForNonComposite();
            }
            this.fireDataFieldChange();
        }
    }

    public static String[] getPartitionTypes() {
        return PARTITION_TYPE;
    }

    protected boolean checkPartitionType(String string) {
        if (partitionTypeSet == null) {
            partitionTypeSet = new HashSet();
            partitionTypeSet.addAll(Arrays.asList(PartitionListOraclev9i.getPartitionTypes()));
        }
        return partitionTypeSet.contains(string);
    }

    protected void enableSubPartitionsForCompositeByHash() {
        StorageObjectCollection storageObjectCollection = null;
        TableProxyOracle tableProxyOracle = this.getTable();
        if (tableProxyOracle != null) {
            storageObjectCollection = tableProxyOracle.getPartitions();
        } else if (this.getSnapshot() != null) {
            storageObjectCollection = this.getSnapshot().getPartitionsCollection();
        }
        if (storageObjectCollection != null) {
            for (AbstractStorageObjectOracle abstractStorageObjectOracle : storageObjectCollection.getElementsList()) {
                if (abstractStorageObjectOracle instanceof PartitionOracle) {
                    ((PartitionOracle)abstractStorageObjectOracle).enableSubPartitionsByHash();
                    continue;
                }
                if (!(abstractStorageObjectOracle instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)abstractStorageObjectOracle).enableSubPartitionsByHash();
            }
        }
    }

    protected void enableSubPartitionsForCompositeByList() {
        StorageObjectCollection storageObjectCollection = null;
        TableProxyOracle tableProxyOracle = this.getTable();
        if (tableProxyOracle != null) {
            storageObjectCollection = tableProxyOracle.getPartitions();
        } else if (this.getSnapshot() != null) {
            storageObjectCollection = this.getSnapshot().getPartitionsCollection();
        }
        if (storageObjectCollection != null) {
            for (AbstractStorageObjectOracle abstractStorageObjectOracle : storageObjectCollection.getElementsList()) {
                if (abstractStorageObjectOracle instanceof PartitionOracle) {
                    ((PartitionOracle)abstractStorageObjectOracle).enableSubPartitionsByList();
                    continue;
                }
                if (!(abstractStorageObjectOracle instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)abstractStorageObjectOracle).enableSubPartitionsByList();
            }
        }
    }

    protected void disableSubPartitionsForNonComposite() {
        StorageObjectCollection storageObjectCollection = null;
        TableProxyOracle tableProxyOracle = this.getTable();
        if (tableProxyOracle != null) {
            storageObjectCollection = tableProxyOracle.getPartitions();
        } else if (this.getSnapshot() != null) {
            storageObjectCollection = this.getSnapshot().getPartitionsCollection();
        }
        if (storageObjectCollection != null) {
            for (AbstractStorageObjectOracle abstractStorageObjectOracle : storageObjectCollection.getElementsList()) {
                if (abstractStorageObjectOracle instanceof PartitionOracle) {
                    ((PartitionOracle)abstractStorageObjectOracle).disableSubPartitions();
                    continue;
                }
                if (!(abstractStorageObjectOracle instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)abstractStorageObjectOracle).disableSubPartitions();
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
                PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
                partitionOracle.addObjectListener(this);
                if (partitionOracle.getPartitionList() == this) {
                    if (SUBPARTITION_TYPE_HASH.equalsIgnoreCase(this.getSubpartitionType())) {
                        partitionOracle.enableSubPartitionsByHash();
                    } else if ("LIST".equalsIgnoreCase(this.getSubpartitionType())) {
                        partitionOracle.enableSubPartitionsByList();
                    } else {
                        partitionOracle.disableSubPartitions();
                    }
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
            PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
            partitionOracle.removeObjectListener(this);
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        PartitionListOraclev9i partitionListOraclev9i = null;
        PartitionListOraclev9i partitionListOraclev9i2 = (PartitionListOraclev9i)((StorageDesignOracle)storageDesign).getPartitionListSet().getByName(this.getName());
        if (partitionListOraclev9i2 != null) {
            if (!this.isRawObject()) {
                partitionListOraclev9i = partitionListOraclev9i2;
            }
        } else {
            partitionListOraclev9i = (PartitionListOraclev9i)((StorageDesignOracle)storageDesign).getPartitionListSet().createPartitionList();
        }
        if (partitionListOraclev9i != null) {
            partitionListOraclev9i.setName(this.getName());
            partitionListOraclev9i.setPartitionType(this.getPartitionType());
            partitionListOraclev9i.setSubpartitionType(this.getSubpartitionType());
            partitionListOraclev9i.setUseSubpartStorageTemplate(this.getUseSubpartStorageTemplate());
            partitionListOraclev9i.recreateColumnsSet(this.getColumnSet().toString());
            partitionListOraclev9i.recreateHashPartitionsTSSet(this.getHashPartitionsTableSpacesSet().toString());
            partitionListOraclev9i.recreateIOTOverflowHashPTSSet(this.getIOTOverflowHashPTSSet().toString());
            partitionListOraclev9i.recreateSubPartitionsColumnsSet(this.getSubPartitionsColumnsSet().toString());
            partitionListOraclev9i.recreateSubPartitionsTSSet(this.getSubPartitionsTableSpacesSet().toString());
            partitionListOraclev9i.setHashPQuantity(this.getHashPQuantity());
            partitionListOraclev9i.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partitionListOraclev9i.setRawObject(false);
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

