/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ColumnPropertyDialogOraclev9i;

public class ColumnProxyOraclev9i
extends ColumnProxyOracle {
    public static final String CLOB = "CLOB";
    public static final String OBJECT_RELATIONAL = "OBJECT RELATIONAL";
    public static final String UNLIMITED = "UNLIMITED";
    private static final String[] STORE_AS_CHOICES = new String[]{"CLOB", "OBJECT RELATIONAL"};
    private static Set storeAsSet = null;
    private static final String[] STORAGE_IN_ROW_CHOICES = new String[]{"ENABLE", "DISABLE"};
    private static Set storageInRowSet = null;
    private static final String[] CACHE_CHOICES = new String[]{"CACHE", "NOCACHE", "CACHE READS"};
    private static Set cacheSet = null;
    private static final String[] SUBSTITUTABLE_CHOICES = new String[]{"", "YES", "NO", "ONLY FOR TYPE"};
    private static final String[] RETURN_AS_CHOICES = new String[]{"", "VALUE", "LOCATOR"};
    private static final String[] OLD_VERSIONS = new String[]{"RETENTION", "PCT_VERSION"};
    private static final String[] SC_BUFFER_POOL = new String[]{"DEFAULT", "RECYCLE", "KEEP"};
    protected String storeAs = STORE_AS_CHOICES[0];
    protected String lobSegmentName = "";
    protected String xmlSchemaUrl = "";
    protected String xmlSchemaElement = "";
    protected TableSpaceOraclev9i tablespace;
    protected String storageInRow = STORAGE_IN_ROW_CHOICES[0];
    protected String logging = "";
    protected String cache = CACHE_CHOICES[1];
    protected int chunk = 0;
    protected int pctVersion = 0;
    protected long scInitialExtent = 0L;
    protected long scNextExtent = 0L;
    protected int scMinExtents = 1;
    protected String scMaxExtents = "UNLIMITED";
    protected int scPctIncrease = 0;
    protected static Set scBufferPoolSet = null;
    protected String scBufferPool = SC_BUFFER_POOL[0];
    protected int scFreeLists = 1;
    protected int scFreelistGroups = 1;
    protected String oldVersions = OLD_VERSIONS[0];
    protected static Set oldVersionSet = null;
    protected int freepools;
    protected String ntStorageTable = "";
    protected String ntReturn = "";
    protected String lobSegname = "";
    protected String additionalNTS = "";
    protected String elementType = "";
    protected String subtitutable = "";

    public ColumnProxyOraclev9i(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxyOraclev9i(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogOraclev9i columnPropertyDialogOraclev9i = new ColumnPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            columnPropertyDialogOraclev9i.init();
            columnPropertyDialogOraclev9i.show();
        }
    }

    public static String[] getStoreAsValues() {
        return STORE_AS_CHOICES;
    }

    protected boolean checkStoreAs(String string) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getStoreAsValues()));
        }
        return storeAsSet.contains(string);
    }

    public static String[] getStorageInRowValues() {
        return STORAGE_IN_ROW_CHOICES;
    }

    protected boolean checkStorageInRow(String string) {
        if (storageInRowSet == null) {
            storageInRowSet = new HashSet();
            storageInRowSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getStorageInRowValues()));
        }
        return storageInRowSet.contains(string);
    }

    public static String[] getCacheValues() {
        return CACHE_CHOICES;
    }

    protected boolean checkCache(String string) {
        if (cacheSet == null) {
            cacheSet = new HashSet();
            cacheSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getCacheValues()));
        }
        return cacheSet.contains(string);
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int n) {
        this.chunk = n;
    }

    public int getPCTVersion() {
        return this.pctVersion;
    }

    public void setPCTVersion(int n) {
        this.pctVersion = n;
    }

    public long getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(long l) {
        this.scInitialExtent = l;
    }

    public long getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(long l) {
        this.scNextExtent = l;
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int n) {
        if (n >= 1) {
            this.scMinExtents = n;
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String string) {
        try {
            this.scMaxExtents = Integer.parseInt(string) > 0 ? string : UNLIMITED;
        }
        catch (NumberFormatException numberFormatException) {
            this.scMaxExtents = UNLIMITED;
        }
    }

    public int getSCPctIncrease() {
        return this.scPctIncrease;
    }

    public void setSCPctIncrease(int n) {
        this.scPctIncrease = n;
    }

    public static String[] getSCBufferPoolValues() {
        return SC_BUFFER_POOL;
    }

    protected boolean checkSCBufferPoolValue(String string) {
        if (scBufferPoolSet == null) {
            scBufferPoolSet = new HashSet();
            scBufferPoolSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getSCBufferPoolValues()));
        }
        return scBufferPoolSet.contains(string);
    }

    public void setSCBufferPool(String string) {
        if (this.checkSCBufferPoolValue(string)) {
            this.scBufferPool = string;
            this.fireDataFieldChange();
        }
    }

    public String getSCBufferPool() {
        return this.scBufferPool;
    }

    public int getSCFreeLists() {
        return this.scFreeLists;
    }

    public void setSCFreeLists(int n) {
        if (n >= 1) {
            this.scFreeLists = n;
        }
    }

    public int getSCFreelistGroups() {
        return this.scFreelistGroups;
    }

    public void setSCFreelistGroups(int n) {
        if (n >= 1) {
            this.scFreelistGroups = n;
        }
    }

    public static String[] getOldVersionChoices() {
        return OLD_VERSIONS;
    }

    protected boolean checkOldVersion(String string) {
        if (oldVersionSet == null) {
            oldVersionSet = new HashSet();
            oldVersionSet.addAll(Arrays.asList(ColumnProxyOraclev9i.getOldVersionChoices()));
        }
        return oldVersionSet.contains(string);
    }

    public String getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersions(String string) {
        if (this.checkOldVersion(string)) {
            this.oldVersions = string;
            this.fireDataFieldChange();
        }
    }

    public int getFreepools() {
        return this.freepools;
    }

    public void setFreepools(int n) {
        this.freepools = n;
    }

    public String getCache() {
        return this.cache;
    }

    public String getCacheValue() {
        Datatype datatype = this.getDataType();
        if (datatype.toString().equals("XMLTYPE")) {
            return this.cache;
        }
        return null;
    }

    public void setCache(String string) {
        if (this.checkCache(string)) {
            this.cache = string;
            this.fireDataFieldChange();
        }
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public void setLobSegmentName(String string) {
        this.lobSegmentName = string;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getStoreAs() {
        return this.storeAs;
    }

    public void setStoreAs(String string) {
        if (this.checkStoreAs(string)) {
            this.storeAs = string;
            this.fireDataFieldChange();
        }
    }

    public String getXmlSchemaElement() {
        return this.xmlSchemaElement;
    }

    public void setXmlSchemaElement(String string) {
        this.xmlSchemaElement = string;
        this.fireDataFieldChange();
    }

    public String getXmlSchemaUrl() {
        return this.xmlSchemaUrl;
    }

    public void setXmlSchemaUrl(String string) {
        this.xmlSchemaUrl = string;
        this.fireDataFieldChange();
    }

    public String getStorageInRow() {
        return this.storageInRow;
    }

    public void setStorageInRow(String string) {
        if (this.checkStorageInRow(string)) {
            this.storageInRow = string;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOraclev9i getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOraclev9i tableSpaceOraclev9i) {
        this.tablespace = tableSpaceOraclev9i;
        this.fireDataFieldChange();
    }

    public static String[] getSubstitutableValues() {
        return SUBSTITUTABLE_CHOICES;
    }

    public static String[] getReturnAsValues() {
        return RETURN_AS_CHOICES;
    }

    public String getAdditionalNTS() {
        return this.additionalNTS;
    }

    public void setAdditionalNTS(String string) {
        this.additionalNTS = string;
    }

    public String getLobSegname() {
        return this.lobSegname;
    }

    public void setLobSegname(String string) {
        this.lobSegname = string;
    }

    public String getNtReturn() {
        return this.ntReturn;
    }

    public void setNtReturn(String string) {
        this.ntReturn = string;
    }

    public String getNtStorageTable() {
        return this.ntStorageTable;
    }

    public void setNtStorageTable(String string) {
        this.ntStorageTable = string;
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String string) {
        this.elementType = string;
    }

    public String getSubtitutable() {
        return this.subtitutable;
    }

    public void setSubtitutable(String string) {
        this.subtitutable = string;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Column column = (Column)storageDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyOraclev9i columnProxyOraclev9i = null;
        RelationalObjectProxy relationalObjectProxy = storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            columnProxyOraclev9i = (ColumnProxyOraclev9i)relationalObjectProxy;
        }
        if (columnProxyOraclev9i != null) {
            columnProxyOraclev9i.setObjectID(this.getObjectID());
            columnProxyOraclev9i.setName(this.getName());
            columnProxyOraclev9i.setDefaultValue(this.getDefaultValue());
            columnProxyOraclev9i.setSubtitutable(this.getSubtitutable());
            columnProxyOraclev9i.setInitially(this.getInitially());
            columnProxyOraclev9i.setDeferrable(this.getDeferrable());
            columnProxyOraclev9i.setEnable(this.getEnable());
            columnProxyOraclev9i.setValidate(this.getValidate());
            columnProxyOraclev9i.setNncName(this.getNncName());
            columnProxyOraclev9i.setNncDeferrable(this.getNncDeferrable());
            columnProxyOraclev9i.setNncEnable(this.getNncEnable());
            columnProxyOraclev9i.setNncExceptionsTable(this.getNncExceptionsTable());
            columnProxyOraclev9i.setNncInitially(this.getNncInitially());
            columnProxyOraclev9i.setNncRely(this.getNncRely());
            columnProxyOraclev9i.setNncValidate(this.getNncValidate());
            if (this.getExceptionsTable() != null) {
                TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)storageDesign.getTableProxySet().getProxy(this.getExceptionsTable().getObject().getObjectID());
                if (tableProxyOraclev9i == null) {
                    TableProxyOraclev9i tableProxyOraclev9i2 = (TableProxyOraclev9i)((TableProxySetOraclev9i)storageDesign.getTableProxySet()).createProxy(this.getExceptionsTable().getObject());
                    tableProxyOraclev9i2.setName(this.getExceptionsTable().getName());
                    tableProxyOraclev9i2.setRawObject(true);
                    columnProxyOraclev9i.setExceptionsTable(tableProxyOraclev9i2);
                } else {
                    columnProxyOraclev9i.setExceptionsTable(tableProxyOraclev9i);
                }
            }
            columnProxyOraclev9i.setComment(this.getComment());
            columnProxyOraclev9i.setCommentChanged(this.isCommentChanged());
            columnProxyOraclev9i.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxyOraclev9i.setCommentInRDBMSChanged(this.isCommentInRDBMSChanged());
            columnProxyOraclev9i.setRawObject(false);
        }
    }
}

