/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;

public class PartitionListOraclev11g
extends PartitionListOraclev10g {
    public static final String PARTITION_TYPE_REFERENCE = "REFERENCE";
    public static final String PARTITION_TYPE_SYSTEM = "SYSTEM";
    private static final String[] PARTITION_TYPES = new String[]{"RANGE", "HASH BY QUANTITY", "HASH BY LIST OF PARTITIONS", "LIST", "REFERENCE", "SYSTEM"};
    private static final String[] SUBPARTITION_TYPES = new String[]{"", "RANGE", "HASH", "LIST"};
    private static Set partitionTypeSet = null;
    private static Set subpartitionTypeSet = null;
    private FKProxyOracle refConstraint = null;
    private int systemPartitions = 1;
    private String intervalExpression = "";
    private PartitionListOraclev9i.InlineList intervalTablespaceSet = null;
    private String intervalTablespaces = "";

    public PartitionListOraclev11g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void setPartitionType(String string) {
        if (string.equalsIgnoreCase("COMPOSITE BY HASH")) {
            string = "RANGE";
            this.setSubpartitionType("HASH");
        } else if (string.equalsIgnoreCase("COMPOSITE BY LIST")) {
            string = "RANGE";
            this.setSubpartitionType("LIST");
        }
        if (!this.partitionType.equals(string) && this.checkPartitionType(string)) {
            this.partitionType = string;
            if (!string.equalsIgnoreCase("RANGE") && !string.equalsIgnoreCase("LIST")) {
                this.setSubpartitionType("");
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    protected boolean checkPartitionType(String string) {
        if (partitionTypeSet == null) {
            partitionTypeSet = new HashSet();
            partitionTypeSet.addAll(Arrays.asList(PartitionListOraclev11g.getPartitionTypes()));
        }
        return partitionTypeSet.contains(string);
    }

    public static String[] getPartitionTypes() {
        return PARTITION_TYPES;
    }

    @Override
    public void setSubpartitionType(String string) {
        if (!this.subpartitionType.equals(string) && this.checkSubpartitionType(string)) {
            this.subpartitionType = string;
            if (string.equalsIgnoreCase("HASH")) {
                this.enableSubPartitionsForCompositeByHash();
            } else if (string.equalsIgnoreCase("LIST")) {
                this.enableSubPartitionsForCompositeByList();
            } else if (string.equalsIgnoreCase("RANGE")) {
                this.enableSubPartitionsForCompositeByRange();
            } else {
                this.disableSubPartitionsForNonComposite();
            }
            this.fireDataFieldChange();
        }
    }

    protected boolean checkSubpartitionType(String string) {
        if (subpartitionTypeSet == null) {
            subpartitionTypeSet = new HashSet();
            subpartitionTypeSet.addAll(Arrays.asList(PartitionListOraclev11g.getSubpartitionTypes()));
        }
        return subpartitionTypeSet.contains(string);
    }

    public static String[] getSubpartitionTypes() {
        return SUBPARTITION_TYPES;
    }

    protected void enableSubPartitionsForCompositeByRange() {
        StorageObjectCollection storageObjectCollection = null;
        TableProxyOracle tableProxyOracle = this.getTable();
        if (tableProxyOracle != null) {
            storageObjectCollection = tableProxyOracle.getPartitions();
        } else if (this.getSnapshot() != null) {
            storageObjectCollection = this.getSnapshot().getPartitionsCollection();
        }
        if (storageObjectCollection != null) {
            for (AbstractStorageObjectOracle abstractStorageObjectOracle : storageObjectCollection.getElementsList()) {
                if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                    ((PartitionOraclev11g)abstractStorageObjectOracle).enableSubPartitionsByRange();
                    continue;
                }
                if (!(abstractStorageObjectOracle instanceof ListPartitionOraclev11g)) continue;
                ((ListPartitionOraclev11g)abstractStorageObjectOracle).enableSubPartitionsByRange();
            }
        }
    }

    public void setRefConstraint(FKProxyOracle fKProxyOracle) {
        this.refConstraint = fKProxyOracle;
    }

    public void setRefConstraint(String string) {
        StorageObjectCollection storageObjectCollection = null;
        TableProxyOracle tableProxyOracle = this.getTable();
        if (tableProxyOracle != null) {
            storageObjectCollection = tableProxyOracle.getFKeys();
        }
        if (storageObjectCollection != null) {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                FKProxyOracle fKProxyOracle = (FKProxyOracle)iterator.next();
                if (!fKProxyOracle.getName().equals(string2)) continue;
                this.refConstraint = fKProxyOracle;
                return;
            }
        }
    }

    public FKProxyOracle getRefConstraint() {
        return this.refConstraint;
    }

    public void setSystemPartitions(int n) {
        this.systemPartitions = n;
    }

    public int getSystemPartitions() {
        return this.systemPartitions;
    }

    public void setIntervalExpression(String string) {
        this.intervalExpression = string;
    }

    public String getIntervalExpression() {
        return this.intervalExpression;
    }

    public String getIntervalTablespaces() {
        return this.intervalTablespaces;
    }

    public String getAllIntervalTablespaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.intervalTablespaces, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public void setIntervalTablespaceSet(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIntervalTablespaceSet(string);
        } else {
            this.addIntervalTablespace(string);
        }
        String string2 = this.getIntervalTablespaceSet().toString();
        if (!this.intervalTablespaces.equals(string2)) {
            this.intervalTablespaces = string2;
            this.fireDataFieldChange();
        }
    }

    private void addIntervalTablespace(String string) {
        if (!this.getIntervalTablespaceSet().contains(string)) {
            this.getIntervalTablespaceSet().add(string);
        }
    }

    private void recreateIntervalTablespaceSet(String string) {
        this.getIntervalTablespaceSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getIntervalTablespaceSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public PartitionListOraclev9i.InlineList getIntervalTablespaceSet() {
        if (this.intervalTablespaceSet == null) {
            this.intervalTablespaceSet = new PartitionListOraclev9i.InlineList(this);
        }
        return this.intervalTablespaceSet;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        PartitionListOraclev11g partitionListOraclev11g = null;
        PartitionListOraclev11g partitionListOraclev11g2 = (PartitionListOraclev11g)((StorageDesignOracle)storageDesign).getPartitionListSet().getByName(this.getName());
        if (partitionListOraclev11g2 != null) {
            if (!this.isRawObject()) {
                partitionListOraclev11g = partitionListOraclev11g2;
            }
        } else {
            partitionListOraclev11g = (PartitionListOraclev11g)((StorageDesignOracle)storageDesign).getPartitionListSet().createPartitionList();
        }
        if (partitionListOraclev11g != null) {
            partitionListOraclev11g.setName(this.getName());
            partitionListOraclev11g.setPartitionType(this.getPartitionType());
            partitionListOraclev11g.setSubpartitionType(this.getSubpartitionType());
            partitionListOraclev11g.setUseSubpartStorageTemplate(this.getUseSubpartStorageTemplate());
            partitionListOraclev11g.recreateColumnsSet(this.getColumnSet().toString());
            partitionListOraclev11g.recreateHashPartitionsTSSet(this.getHashPartitionsTableSpacesSet().toString());
            partitionListOraclev11g.recreateIOTOverflowHashPTSSet(this.getIOTOverflowHashPTSSet().toString());
            partitionListOraclev11g.recreateSubPartitionsColumnsSet(this.getSubPartitionsColumnsSet().toString());
            partitionListOraclev11g.recreateSubPartitionsTSSet(this.getSubPartitionsTableSpacesSet().toString());
            partitionListOraclev11g.setHashPQuantity(this.getHashPQuantity());
            partitionListOraclev11g.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partitionListOraclev11g.setRefConstraint(this.getRefConstraint());
            partitionListOraclev11g.setSystemPartitions(this.getSystemPartitions());
            partitionListOraclev11g.setIntervalExpression(this.getIntervalExpression());
            partitionListOraclev11g.recreateIntervalTablespaceSet(this.getIntervalTablespaceSet().toString());
            partitionListOraclev11g.setRawObject(false);
        }
    }
}

