/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ColumnPropertyDialogOraclev11g;

public class ColumnProxyOraclev11g
extends ColumnProxyOraclev10g {
    public static final String BINARY_XML = "BINARY XML";
    public static final String SECUREFILE = "SECUREFILE";
    public static final String BASICFILE = "BASICFILE";
    public static final String FILESYSTEM_LIKE_LOGGING = "FILESYSTEM_LIKE_LOGGING";
    private static final String[] STORE_AS_CHOICES = new String[]{"BINARY XML", "CLOB", "OBJECT RELATIONAL"};
    private static Set storeAsSet = null;
    private static final String[] LOB_STORAGE_CHOICES = new String[]{"", "SECUREFILE", "BASICFILE"};
    private static Set lobStorageTypeSet = null;
    private static final String[] LOGGING_CHOICES = new String[]{"", "YES", "NO", "FILESYSTEM_LIKE_LOGGING"};
    private String lobStorageType = "";
    private String allowAnySchema = "";
    private String allowNonSchema = "";
    private boolean expressionChanged = false;
    private String columnExpression = "";

    public ColumnProxyOraclev11g(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
        this.storeAs = BINARY_XML;
    }

    public ColumnProxyOraclev11g(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.storeAs = BINARY_XML;
    }

    public boolean isComputed() {
        return this.getColumn().isComputed();
    }

    @Override
    public boolean isVirtual() {
        String string;
        return this.isComputed() && (string = this.getColumnExpression()) != null && string.trim().length() > 0;
    }

    public boolean isExpressionChanged() {
        return this.expressionChanged;
    }

    public void setExpressionChanged(boolean bl) {
        this.expressionChanged = bl;
    }

    public String getColumnExpression() {
        if (this.expressionChanged) {
            return this.columnExpression;
        }
        return this.getColumn().getFormulaDesc();
    }

    public void setColumnExpression(String string) {
        this.columnExpression = string;
        this.fireDataFieldChange();
    }

    public String getLobStorageType() {
        return this.lobStorageType;
    }

    public void setLobStorageType(String string) {
        if (!this.lobStorageType.equals(string) && this.checkLobStorageType(string)) {
            this.lobStorageType = string;
            this.fireDataFieldChange();
        }
    }

    public String getAllowAnySchema() {
        return this.allowAnySchema;
    }

    public void setAllowAnySchema(String string) {
        if (!this.allowAnySchema.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.allowAnySchema = string;
            this.fireDataFieldChange();
        }
    }

    public String getAllowNonSchema() {
        return this.allowNonSchema;
    }

    public void setAllowNonSchema(String string) {
        if (!this.allowNonSchema.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.allowNonSchema = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogOraclev11g columnPropertyDialogOraclev11g = new ColumnPropertyDialogOraclev11g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            columnPropertyDialogOraclev11g.init();
            columnPropertyDialogOraclev11g.show();
        }
    }

    public static String[] getStoreAsValues11g() {
        return STORE_AS_CHOICES;
    }

    @Override
    protected boolean checkStoreAs(String string) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(ColumnProxyOraclev11g.getStoreAsValues11g()));
        }
        return storeAsSet.contains(string);
    }

    public static String[] getLobStorageValues11g() {
        return LOB_STORAGE_CHOICES;
    }

    private boolean checkLobStorageType(String string) {
        if (lobStorageTypeSet == null) {
            lobStorageTypeSet = new HashSet();
            lobStorageTypeSet.addAll(Arrays.asList(ColumnProxyOraclev11g.getLobStorageValues11g()));
        }
        return lobStorageTypeSet.contains(string);
    }

    public static String[] getLoggingChoices11g() {
        return LOGGING_CHOICES;
    }

    @Override
    public void setLogging(String string) {
        super.setLogging(string);
        if (!this.logging.equals(string) && FILESYSTEM_LIKE_LOGGING.equals(string)) {
            this.logging = FILESYSTEM_LIKE_LOGGING;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Column column = (Column)storageDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyOraclev11g columnProxyOraclev11g = null;
        RelationalObjectProxy relationalObjectProxy = storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            columnProxyOraclev11g = (ColumnProxyOraclev11g)relationalObjectProxy;
        }
        if (columnProxyOraclev11g != null) {
            super.copy(storageDesign);
            columnProxyOraclev11g.setColumnExpression(this.getColumnExpression());
            columnProxyOraclev11g.setExpressionChanged(this.isExpressionChanged());
            columnProxyOraclev11g.setLobStorageType(this.getLobStorageType());
        }
    }
}

