/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableCheckConstraintOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableCheckConstraintSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyOraclev10g
extends TableProxyOracle
implements TableCheckConstraintListener {
    protected String suplementalLogGroupName = "";
    protected String suplementalLogConditions = suplementalLogConditionChoices[0];
    protected String IOTMappingTable = "NO";
    public static String[] suplementalLogConditionChoices = new String[]{"ON UPDATE", "ALWAYS"};
    private static Set suplementalLogConditionsSet = null;
    protected String suplementalLogColumns = "";
    protected TableProxyOracle.InlineList suplementalLogColumnSet = null;
    private String partitioned = "NO";
    private String partType = "";
    private String subpartType = "";
    private List propertyWrapperList = null;

    public TableProxyOraclev10g(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxyOraclev10g(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public TableProxyOracle.InlineList getSuplementalLogColumnSet() {
        if (this.suplementalLogColumnSet == null) {
            this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        }
        return this.suplementalLogColumnSet;
    }

    public void clearSuplementalLogColumns() {
        this.getSuplementalLogColumnSet().removeAllElements();
        this.suplementalLogColumns = "";
    }

    public String getSuplementalLogColumns() {
        return this.suplementalLogColumns;
    }

    public String getAllSuplementalLogColumns() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.suplementalLogColumns, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            ColumnProxy columnProxy = this.getColumnProxy(string);
            if (columnProxy == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(columnProxy.getLongName());
        }
        return stringBuffer.toString();
    }

    public void setSuplementalLogColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSuplementalLogColumnSet(string);
        } else {
            this.addSuplementalLogColumn(string);
        }
        this.suplementalLogColumns = this.getSuplementalLogColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addSuplementalLogColumn(String string) {
        this.getSuplementalLogColumnSet().add(string);
    }

    private void recreateSuplementalLogColumnSet(String string) {
        this.getSuplementalLogColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.suplementalLogColumnSet = new TableProxyOracle.InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getSuplementalLogColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)objectChangeEvent.getAffected();
            if (lobStorageOracle.getTable() == this) {
                lobStorageOracle.setParent(this.lobs);
                this.lobs.add(lobStorageOracle);
            } else {
                this.lobs.remove(lobStorageOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof PartitionOraclev10g) {
            PartitionOraclev10g partitionOraclev10g = (PartitionOraclev10g)objectChangeEvent.getAffected();
            if (partitionOraclev10g.getPartitionList() == this.partitionList && this.partitionList != null) {
                partitionOraclev10g.setParent(this.partitions);
                this.partitions.add(partitionOraclev10g);
                if (partitionOraclev10g.getPosition() == 0) {
                    partitionOraclev10g.removeObjectListener(this);
                    partitionOraclev10g.setPosition(this.partitions.size());
                    partitionOraclev10g.addObjectListener(this);
                }
            } else {
                this.partitions.remove(partitionOraclev10g);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListStorageTemplatePartitionOraclev10g) {
            ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)objectChangeEvent.getAffected();
            if (listStorageTemplatePartitionOraclev10g.getPartOfStorageTable() == this) {
                listStorageTemplatePartitionOraclev10g.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(listStorageTemplatePartitionOraclev10g);
            } else {
                this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev10g);
            }
        } else if (objectChangeEvent.getAffected() instanceof HashPartitionOraclev10g) {
            HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)objectChangeEvent.getAffected();
            if (hashPartitionOraclev10g.getPartitionList() != null && hashPartitionOraclev10g.getPartitionList() == this.getPartitionList() && hashPartitionOraclev10g.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                hashPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(hashPartitionOraclev10g);
            } else {
                this.partitions.remove(hashPartitionOraclev10g);
            }
            if (hashPartitionOraclev10g.getPartOfStorageTable() == this) {
                hashPartitionOraclev10g.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(hashPartitionOraclev10g);
            } else {
                this.listStorageTemplates.remove(hashPartitionOraclev10g);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListPartitionOraclev10g) {
            ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)objectChangeEvent.getAffected();
            if (listPartitionOraclev10g.getPartitionList() != null && listPartitionOraclev10g.getPartitionList() == this.getPartitionList()) {
                listPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(listPartitionOraclev10g);
            } else {
                this.partitions.remove(listPartitionOraclev10g);
            }
        } else if (objectChangeEvent.getAffected() instanceof BitmapJoinIndexOraclev10g) {
            BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g = (BitmapJoinIndexOraclev10g)objectChangeEvent.getAffected();
            if (bitmapJoinIndexOraclev10g.getTable() == this) {
                bitmapJoinIndexOraclev10g.setParent(this.bjIndexes);
                this.bjIndexes.add(bitmapJoinIndexOraclev10g);
            } else {
                this.bjIndexes.remove(bitmapJoinIndexOraclev10g);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                lobStorageOracle.addObjectListener(this);
                if (lobStorageOracle.getTable() == this) {
                    lobStorageOracle.setParent(this.lobs);
                    this.lobs.add(lobStorageOracle);
                } else {
                    this.lobs.remove(lobStorageOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
                PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
                partitionOracle.addObjectListener(this);
                if (partitionOracle.getPartitionList() != null && partitionOracle.getPartitionList() == this.getPartitionList()) {
                    partitionOracle.setParent(this.partitions);
                    this.partitions.add(partitionOracle);
                    partitionOracle.removeObjectListener(this);
                    partitionOracle.setPosition(this.partitions.size());
                    partitionOracle.addObjectListener(this);
                } else if (this.partitions.remove(partitionOracle)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject modelObject = this.partitions.getElement(i);
                        if (!(modelObject instanceof PartitionOracle)) continue;
                        ((PartitionOracle)modelObject).setPosition(i + 1);
                    }
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOraclev10g) {
                ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)modelObjectSetEvent.getAffected();
                listStorageTemplatePartitionOraclev10g.addObjectListener(this);
                if (listStorageTemplatePartitionOraclev10g.getPartOfStorageTable() == this) {
                    listStorageTemplatePartitionOraclev10g.setParent(this.listStorageTemplates);
                    this.listStorageTemplates.add(listStorageTemplatePartitionOraclev10g);
                } else {
                    this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev10g);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof HashPartitionOraclev10g) {
                HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)modelObjectSetEvent.getAffected();
                hashPartitionOraclev10g.addObjectListener(this);
                if (hashPartitionOraclev10g.getPartitionList() != null && hashPartitionOraclev10g.getPartitionList() == this.getPartitionList() && hashPartitionOraclev10g.getPartitionList().getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                    hashPartitionOraclev10g.setParent(this.partitions);
                } else if (hashPartitionOraclev10g.getPartOfStorageTable() == this) {
                    hashPartitionOraclev10g.setParent(this.partitions);
                    this.partitions.add(hashPartitionOraclev10g);
                } else {
                    this.partitions.remove(hashPartitionOraclev10g);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListPartitionOraclev10g) {
                ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)modelObjectSetEvent.getAffected();
                listPartitionOraclev10g.addObjectListener(this);
                if (listPartitionOraclev10g.getPartitionList() != null && listPartitionOraclev10g.getPartitionList() == this.getPartitionList()) {
                    listPartitionOraclev10g.setParent(this.partitions);
                    this.partitions.add(listPartitionOraclev10g);
                } else {
                    this.partitions.remove(listPartitionOraclev10g);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof BitmapJoinIndexOraclev10g) {
                BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g = (BitmapJoinIndexOraclev10g)modelObjectSetEvent.getAffected();
                bitmapJoinIndexOraclev10g.addObjectListener(this);
                if (bitmapJoinIndexOraclev10g.getTable() == this) {
                    bitmapJoinIndexOraclev10g.setParent(this.bjIndexes);
                    this.bjIndexes.add(bitmapJoinIndexOraclev10g);
                } else {
                    this.bjIndexes.remove(bitmapJoinIndexOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                this.lobs.remove(lobStorageOracle);
                lobStorageOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
                PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
                if (this.partitions.remove(partitionOracle)) {
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        ModelObject modelObject = this.partitions.getElement(i);
                        if (!(modelObject instanceof PartitionOracle)) continue;
                        ((PartitionOracle)modelObject).setPosition(i + 1);
                    }
                }
                partitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOraclev10g) {
                ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)modelObjectSetEvent.getAffected();
                this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev10g);
                listStorageTemplatePartitionOraclev10g.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                this.partitions.remove(hashPartitionOracle);
                this.listStorageTemplates.remove(hashPartitionOracle);
                hashPartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof ListPartitionOraclev10g) {
                ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)modelObjectSetEvent.getAffected();
                this.partitions.remove(listPartitionOraclev10g);
                listPartitionOraclev10g.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof BitmapJoinIndexOraclev10g) {
                BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g = (BitmapJoinIndexOraclev10g)modelObjectSetEvent.getAffected();
                this.bjIndexes.remove(bitmapJoinIndexOraclev10g);
                bitmapJoinIndexOraclev10g.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(TableLevelConstraint tableLevelConstraint, TableLevelConstraintEvent tableLevelConstraintEvent) {
        if (tableLevelConstraintEvent.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED)) {
            StorageDesignOraclev10g storageDesignOraclev10g = (StorageDesignOraclev10g)this.getStorageDesign();
            TableCheckConstraintSetOraclev10g tableCheckConstraintSetOraclev10g = (TableCheckConstraintSetOraclev10g)storageDesignOraclev10g.getTableCheckConstraintSet();
            tableCheckConstraintSetOraclev10g.addTableCheckConstraint(this, tableLevelConstraint);
            this.setDirty(true);
        } else if (tableLevelConstraintEvent.isType(TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED)) {
            StorageDesignOraclev10g storageDesignOraclev10g = (StorageDesignOraclev10g)this.getStorageDesign();
            TableCheckConstraintSetOraclev10g tableCheckConstraintSetOraclev10g = (TableCheckConstraintSetOraclev10g)storageDesignOraclev10g.getTableCheckConstraintSet();
            tableCheckConstraintSetOraclev10g.removeTableCheckConstraint(this, tableLevelConstraint);
            this.setDirty(true);
        }
    }

    @Override
    protected void addTableCheckConstraintFromDesign(TableCheckConstraintSetOracle tableCheckConstraintSetOracle) {
        ModelIDObject modelIDObject;
        Iterator iterator = tableCheckConstraintSetOracle.iterator();
        while (iterator.hasNext()) {
            modelIDObject = (TableCheckConstraintOracle)iterator.next();
            if (((TableCheckConstraintOracle)modelIDObject).getTable() == null || ((TableCheckConstraintOracle)modelIDObject).getTable() != this || TableProxyOraclev10g.containsTCCWithID(this.tableCheckConstraints, modelIDObject.getObjectID())) continue;
            modelIDObject.setParent(this.tableCheckConstraints);
            this.tableCheckConstraints.add(modelIDObject);
        }
        modelIDObject = (Table)this.getObject();
        for (TableLevelConstraint tableLevelConstraint : ((Table)modelIDObject).getCheckConstraints()) {
            ((TableCheckConstraintSetOraclev10g)tableCheckConstraintSetOracle).addTableCheckConstraint(this, tableLevelConstraint);
        }
        this.fireDataFieldChange();
    }

    public String getIOTMappingTable() {
        return this.IOTMappingTable;
    }

    public void setIOTMappingTable(String string) {
        this.IOTMappingTable = string;
        this.fireDataFieldChange();
    }

    public String getSuplementalLogConditions() {
        return this.suplementalLogConditions;
    }

    public void setSuplementalLogConditions(String string) {
        if (this.checkSuplementalLogConditions(string)) {
            this.suplementalLogConditions = string;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkSuplementalLogConditions(String string) {
        if (suplementalLogConditionsSet == null) {
            suplementalLogConditionsSet = new HashSet();
            suplementalLogConditionsSet.addAll(Arrays.asList(suplementalLogConditionChoices));
        }
        return suplementalLogConditionsSet.contains(string);
    }

    public String getSuplementalLogGroupName() {
        return this.suplementalLogGroupName;
    }

    public void setSuplementalLogGroupName(String string) {
        this.suplementalLogGroupName = string;
        this.fireDataFieldChange();
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionListOracle) {
        PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)partitionListOracle;
        String string = "";
        String string2 = "";
        if (partitionListOraclev10g != null) {
            string = partitionListOraclev10g.getPartitionType();
            if (string.equalsIgnoreCase("COMPOSITE BY HASH") || string.equalsIgnoreCase("COMPOSITE BY LIST")) {
                string = "RANGE";
            }
            string2 = partitionListOraclev10g.getSubpartitionType();
        }
        if (this.partitionList != null) {
            if (!this.partType.equalsIgnoreCase(string)) {
                this.partitions.removeAll();
            }
            if (!this.subpartType.equalsIgnoreCase(string2)) {
                this.listStorageTemplates.removeAll();
            }
        }
        this.partType = string;
        this.subpartType = string2;
        this.partitionList = partitionListOraclev10g;
        if (this.partitionList == null) {
            this.partitions.setForbiddenCreateElement(true);
            this.listStorageTemplates.setForbiddenCreateElement(true);
        } else {
            this.partitionList.setTable(this);
            this.partitioned = "YES";
            if (this.partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                this.partitions.setForbiddenCreateElement(true);
            } else {
                this.partitions.setForbiddenCreateElement(false);
                this.partitions.setLogicalParent(partitionListOraclev10g);
            }
            if (this.partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.partType.equalsIgnoreCase("LIST")) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getListPartitionSet());
                this.addListPartFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getListPartitionSet());
            } else {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet());
                this.addPartFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet());
            }
            if ("NO".equalsIgnoreCase(partitionListOraclev10g.getUseSubpartStorageTemplate())) {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            } else if (this.subpartType.equalsIgnoreCase("HASH")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet());
                this.addHashPartFromDesignToTemplates(((StorageDesignOraclev10g)this.getStorageDesign()).getHashPartitionSet());
            } else if (this.subpartType.equalsIgnoreCase("LIST")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getListStorageTemplatePartitionSet());
                this.addStorageTemplatePartitionsFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getListStorageTemplatePartitionSet());
            } else if (this.subpartType.equalsIgnoreCase("RANGE")) {
                this.listStorageTemplates.setForbiddenCreateElement(false);
                this.listStorageTemplates.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet());
                this.addRangePartFromDesignToTemplates(((StorageDesignOraclev10g)this.getStorageDesign()).getPartitionSet());
            } else {
                this.listStorageTemplates.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    @Override
    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    @Override
    public void setPartitioned(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.partitioned = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getPartitioned() {
        return this.partitioned;
    }

    private void addHashPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
            if (hashPartitionOraclev10g.getPartitionList() == this.partitionList && this.partitionList != null) {
                hashPartitionOraclev10g.addObjectListener(this);
                hashPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(hashPartitionOraclev10g);
                continue;
            }
            this.partitions.remove(hashPartitionOraclev10g);
        }
    }

    private void addListPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)iterator.next();
            if (listPartitionOraclev10g.getPartitionList() == this.partitionList && this.partitionList != null) {
                listPartitionOraclev10g.addObjectListener(this);
                listPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(listPartitionOraclev10g);
                continue;
            }
            this.partitions.remove(listPartitionOraclev10g);
        }
    }

    private void addStorageTemplatePartitionsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)iterator.next();
            if (listStorageTemplatePartitionOraclev10g.getPartOfStorageTable() == this) {
                listStorageTemplatePartitionOraclev10g.addObjectListener(this);
                listStorageTemplatePartitionOraclev10g.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(listStorageTemplatePartitionOraclev10g);
                continue;
            }
            this.listStorageTemplates.remove(listStorageTemplatePartitionOraclev10g);
        }
    }

    private void addHashPartFromDesignToTemplates(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
            if (hashPartitionOraclev10g.getPartOfStorageTable() == this) {
                hashPartitionOraclev10g.addObjectListener(this);
                hashPartitionOraclev10g.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(hashPartitionOraclev10g);
                continue;
            }
            this.listStorageTemplates.remove(hashPartitionOraclev10g);
        }
    }

    protected void addRangePartFromDesignToTemplates(StorageObjectSet storageObjectSet) {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogOraclev10g tablePropertyDialogOraclev10g = new TablePropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogOraclev10g.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("User", this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Temporary", this, "getTemporary", "setTemporary", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Preserve Rows", this, "getTempPreserveRows", "setTempPreserveRows", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Organization", this, "getOrganization", "setOrganization", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", ClusterOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Logging", this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Storage", this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Parallel", this, "getParallel", "setParallel", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Degree", this, "getDegree", "setDegree", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Row Dependency", this, "getRowDependency", "setRowDependency", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Row Movement", this, "getParttitionedRowMovement", "setParttitionedRowMovement", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Compression", this, "getDataSegmentCompression", "setDataSegmentCompression", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Table table = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyOraclev10g tableProxyOraclev10g = null;
        RelationalObjectProxy relationalObjectProxy = storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableProxyOraclev10g = (TableProxyOraclev10g)relationalObjectProxy;
        }
        if (tableProxyOraclev10g != null) {
            StorageObject storageObject;
            StorageObject storageObject2;
            StorageObject storageObject3;
            tableProxyOraclev10g.setName(this.getName());
            Iterator iterator = this.getTableCheckConstraints().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TableCheckConstraintOraclev10g)iterator.next();
                storageObject2 = (TableCheckConstraintOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableCheckConstraintSet().getByName(((TableCheckConstraintOracle)storageObject3).getName());
                if (storageObject2 == null) {
                    storageObject = (TableCheckConstraintOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableCheckConstraintSet().createTableCheckConstraint();
                    ((TableCheckConstraintOracle)storageObject).setName(((TableCheckConstraintOracle)storageObject3).getName());
                    storageObject.setRawObject(true);
                    ((TableCheckConstraintOracle)storageObject).setTable(tableProxyOraclev10g);
                    tableProxyOraclev10g.addTableCheckConstraintFromDesign(((StorageDesignOraclev10g)storageDesign).getTableCheckConstraintSet());
                    continue;
                }
                ((TableCheckConstraintOracle)storageObject2).setTable(tableProxyOraclev10g);
                tableProxyOraclev10g.addTableCheckConstraintFromDesign(((StorageDesignOraclev10g)storageDesign).getTableCheckConstraintSet());
            }
            iterator = this.getBjIndexes().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (BitmapJoinIndexOraclev10g)iterator.next();
                storageObject2 = (BitmapJoinIndexOraclev10g)((StorageDesignOraclev10g)storageDesign).getBitmapJoinIndexSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (BitmapJoinIndexOraclev10g)((StorageDesignOraclev10g)storageDesign).getBitmapJoinIndexSet().createBitmapJoinIndex();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((BitmapJoinIndexOracle)storageObject).setTable(tableProxyOraclev10g);
                    tableProxyOraclev10g.getBjIndexes().add(storageObject);
                    continue;
                }
                ((BitmapJoinIndexOracle)storageObject2).setTable(tableProxyOraclev10g);
                tableProxyOraclev10g.getBjIndexes().add(storageObject2);
            }
            iterator = this.getLobStorages().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (LobStorageOraclev10g)iterator.next();
                storageObject2 = (LobStorageOraclev10g)((StorageDesignOraclev10g)storageDesign).getLobStorageSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (LobStorageOraclev10g)((StorageDesignOraclev10g)storageDesign).getLobStorageSet().createLobStorage();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((LobStorageOracle)storageObject).setTable(tableProxyOraclev10g);
                    continue;
                }
                ((LobStorageOracle)storageObject2).setTable(tableProxyOraclev10g);
            }
            iterator = this.triggers.iterator();
            while (iterator.hasNext()) {
                storageObject3 = (TriggerOraclev10g)iterator.next();
                storageObject2 = (TriggerOraclev10g)((StorageDesignOraclev10g)storageDesign).getTriggerSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    storageObject = (TriggerOraclev10g)((StorageDesignOraclev10g)storageDesign).getTriggerSet().createTrigger();
                    storageObject.setName(storageObject3.getName());
                    storageObject.setRawObject(true);
                    ((TriggerOracle)storageObject).setTable(tableProxyOraclev10g);
                    tableProxyOraclev10g.addTriggersFromDesign(((StorageDesignOraclev10g)storageDesign).getTriggerSet());
                    continue;
                }
                ((TriggerOracle)storageObject2).setTable(tableProxyOraclev10g);
                tableProxyOraclev10g.addTriggersFromDesign(((StorageDesignOraclev10g)storageDesign).getTriggerSet());
            }
            iterator = this.getUniqueKeys().iterator();
            while (iterator.hasNext()) {
                storageObject3 = (UniqueOraclev10g)iterator.next();
                storageObject2 = (UniqueOraclev10g)((StorageDesignOraclev10g)storageDesign).getUniqueSet().getByName(((IndexProxyOracle)storageObject3).getName());
                if (storageObject2 == null) {
                    storageObject = (UniqueOraclev10g)((UniqueSetOraclev10g)((StorageDesignOraclev10g)storageDesign).getUniqueSet()).createProxy(((RelationalObjectProxy)storageObject3).getObject());
                    ((RelationalObjectProxy)storageObject).setName(((IndexProxyOracle)storageObject3).getName());
                    storageObject.setRawObject(true);
                    tableProxyOraclev10g.addIndProxiesFromDesign(((StorageDesignOraclev10g)storageDesign).getUniqueSet());
                    continue;
                }
                tableProxyOraclev10g.addIndProxiesFromDesign(((StorageDesignOraclev10g)storageDesign).getUniqueSet());
            }
            if (this.getUser() != null) {
                storageObject3 = (UserOraclev10g)((StorageDesignOraclev10g)storageDesign).getUserSet().getByName(this.getUser().getName());
                if (storageObject3 == null) {
                    storageObject2 = (UserOraclev10g)((StorageDesignOraclev10g)storageDesign).getUserSet().createUser();
                    ((UserOracle)storageObject2).setName(this.getUser().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev10g.setUser((UserOracle)storageObject2);
                } else {
                    tableProxyOraclev10g.setUser((UserOracle)storageObject3);
                }
            }
            tableProxyOraclev10g.setTemporary(this.getTemporary());
            tableProxyOraclev10g.setTempPreserveRows(this.getTempPreserveRows());
            if (this.getTableSpace() != null) {
                storageObject3 = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject2).setName(this.getTableSpace().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev10g.setTableSpace((TableSpaceOracle)storageObject2);
                } else {
                    tableProxyOraclev10g.setTableSpace((TableSpaceOracle)storageObject3);
                }
            }
            tableProxyOraclev10g.setOrganization(this.getOrganization());
            if (this.getCluster() != null) {
                storageObject3 = (ClusterOraclev10g)((StorageDesignOraclev10g)storageDesign).getClusterSet().getByName(this.getCluster().getName());
                if (storageObject3 == null) {
                    storageObject2 = (ClusterOraclev10g)((StorageDesignOraclev10g)storageDesign).getClusterSet().createCluster();
                    storageObject2.setName(this.getCluster().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev10g.setCluster((ClusterOracle)storageObject2);
                } else {
                    tableProxyOraclev10g.setCluster((ClusterOracle)storageObject3);
                }
            }
            tableProxyOraclev10g.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                storageObject3 = (SegmentOraclev10g)((StorageDesignOraclev10g)storageDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SegmentOraclev10g)((StorageDesignOraclev10g)storageDesign).getSegmentSet().createSegment();
                    storageObject2.setName(this.getSegment().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev10g.setSegment((SegmentOracle)storageObject2);
                } else {
                    tableProxyOraclev10g.setSegment((SegmentOracle)storageObject3);
                }
            }
            tableProxyOraclev10g.setCache(this.getCache());
            tableProxyOraclev10g.setMonitoring(this.getMonitoring());
            tableProxyOraclev10g.setParallel(this.getParallel());
            tableProxyOraclev10g.setDegree(this.getDegree());
            tableProxyOraclev10g.setRowDependency(this.getRowDependency());
            tableProxyOraclev10g.setPartitioned(this.getPartitioned());
            tableProxyOraclev10g.setParttitionedRowMovement(this.getParttitionedRowMovement());
            tableProxyOraclev10g.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getSnapshot() != null) {
                storageObject3 = (SnapshotOraclev10g)((StorageDesignOraclev10g)storageDesign).getSnapshotSet().getByName(this.getSnapshot().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SnapshotOraclev10g)((StorageDesignOraclev10g)storageDesign).getSnapshotSet().createSnapshot();
                    storageObject2.setName(this.getSnapshot().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev10g.setSnapshot((SnapshotOracle)storageObject2);
                } else {
                    tableProxyOraclev10g.setSnapshot((SnapshotOracle)storageObject3);
                }
            }
            tableProxyOraclev10g.recreateColumnsSet(this.getClusterColumnsSet().toString());
            if (this.getPartitionList() != null) {
                storageObject3 = (PartitionListOraclev10g)((StorageDesignOraclev10g)storageDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (storageObject3 == null) {
                    storageObject2 = (PartitionListOraclev10g)((StorageDesignOraclev10g)storageDesign).getPartitionListSet().createPartitionList();
                    storageObject2.setName(this.getPartitionList().getName());
                    storageObject2.setRawObject(true);
                    tableProxyOraclev10g.setPartitionList((PartitionListOracle)storageObject2);
                } else {
                    tableProxyOraclev10g.setPartitionList((PartitionListOracle)storageObject3);
                }
            }
            tableProxyOraclev10g.setComment(this.getComment());
            tableProxyOraclev10g.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxyOraclev10g.setRawObject(false);
        }
    }
}

