/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;

public class IndexProxySetOraclev10g
extends IndexProxySet
implements Constants {
    public IndexProxySetOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new IndexProxyOraclev10g((Index)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new IndexProxyOraclev10g(design, string, string2, this.getStorageDesign());
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && !((KeyObject)designObject).isPK() && !((KeyObject)designObject).isFK() && !((Index)designObject).getIndexState().equalsIgnoreCase("Unique Constraint")) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            try {
                this.add(relationalObjectProxy);
                if (!this.getStorageDesign().isLoading()) {
                    IndexProxyOracle indexProxyOracle = (IndexProxyOracle)relationalObjectProxy;
                    TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
                    if (tableProxyOracle != null) {
                        indexProxyOracle.setUser(tableProxyOracle.getUser());
                        indexProxyOracle.setTableSpace(tableProxyOracle.getTableSpace());
                    }
                    this.applyTemplate(indexProxyOracle);
                }
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in IndexProxySetOraclev10g.add");
            }
            this.fireUpdate();
        }
    }

    protected void applyTemplate(IndexProxyOracle indexProxyOracle) {
        if (this.getDesign().getAppView().getSettings().useOracleIndexTemplate()) {
            Object object;
            OracleIndexTemplate oracleIndexTemplate = this.getDesign().getAppView().getSettings().getOracleIndexTemplate();
            indexProxyOracle.setBitmapIndex(oracleIndexTemplate.isBitmapIndex());
            indexProxyOracle.setIndexPartitioned(oracleIndexTemplate.getPartitioned());
            String string = oracleIndexTemplate.getTableSpace().trim();
            if (!"".equalsIgnoreCase(string)) {
                object = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string);
                if (object == null) {
                    object = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)object).setName(string);
                }
                indexProxyOracle.setTableSpace((TableSpaceOracle)object);
            }
            indexProxyOracle.setLogging(oracleIndexTemplate.getLogging());
            object = oracleIndexTemplate.getSegment().trim();
            if (!"".equalsIgnoreCase((String)object)) {
                SegmentOracle segmentOracle = (SegmentOracle)((StorageDesignOracle)this.getStorageDesign()).getSegmentSet().getByName((String)object);
                if (segmentOracle == null) {
                    segmentOracle = ((StorageDesignOracle)this.getStorageDesign()).getSegmentSet().createSegment();
                    segmentOracle.setName((String)object);
                }
                indexProxyOracle.setSegment(segmentOracle);
            }
            indexProxyOracle.setCompress(oracleIndexTemplate.getCompress());
            indexProxyOracle.setParallel(oracleIndexTemplate.getParallel());
            indexProxyOracle.setDegree(oracleIndexTemplate.getDegree());
            indexProxyOracle.setSortedRows(oracleIndexTemplate.getSortedRows());
            indexProxyOracle.setComputeStatistics(oracleIndexTemplate.getComputeStatistics());
            indexProxyOracle.setOnline(oracleIndexTemplate.getOnline());
        }
    }
}

