/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.IndexPropertyDialogOraclev10g;

public class IndexProxyOraclev10g
extends IndexProxyOracle {
    private static final String[] PARTITIONED = new String[]{"NON_PARTITIONED", "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST"};
    private static Set partitionedSet = null;
    private String nonLeaf = "NO";
    private int batchSize = 1000;
    TableSpaceOracle workTablespace = null;

    public IndexProxyOraclev10g(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyOraclev10g(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    protected void initPartitions(StorageDesignOracle storageDesignOracle) {
        super.initPartitions(storageDesignOracle);
        ((StorageDesignOraclev10g)storageDesignOracle).getIndexHashPartitionSet().addSetListener(this);
    }

    public static String[] getPartitionedChoices() {
        return PARTITIONED;
    }

    @Override
    public void setIndexPartitioned(String string) {
        if (this.checkPartitionedChoices(string)) {
            if (!this.partitioned.equalsIgnoreCase(string)) {
                this.partitions.removeAll();
            }
            this.partitioned = string;
            if (string.equalsIgnoreCase(PARTITIONED[2])) {
                this.enableSubPartitionsByRange();
            } else if (string.equalsIgnoreCase(PARTITIONED[4])) {
                this.enableSubPartitionsByHash();
            } else {
                this.partitions.setForbiddenCreateElement(true);
                this.partitions.removeAll();
            }
            this.fireDataFieldChange();
        }
    }

    private void enableSubPartitionsByRange() {
        Iterator iterator = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet().iterator();
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev10g indexGlobalPartitionOraclev10g = (IndexGlobalPartitionOraclev10g)iterator.next();
            if (indexGlobalPartitionOraclev10g.getIndexGlobalPartList() == null || indexGlobalPartitionOraclev10g.getIndexGlobalPartList() != this.getIndexGlobalPartitionsList()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private void enableSubPartitionsByHash() {
        Iterator iterator = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet().iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() == null || indexHashPartitionOraclev10g.getIndexGlobalPartList() != this.getIndexGlobalPartitionsList()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private boolean checkPartitionedChoices(String string) {
        if (partitionedSet == null) {
            partitionedSet = new HashSet();
            partitionedSet.addAll(Arrays.asList(IndexProxyOraclev10g.getPartitionedChoices()));
        }
        return partitionedSet.contains(string);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogOraclev10g indexPropertyDialogOraclev10g = new IndexPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogOraclev10g.show();
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)objectChangeEvent.getAffected();
            if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                indexGlobalPartitionOracle.setParent(this.partitions);
                this.partitions.add(indexGlobalPartitionOracle);
            } else {
                this.partitions.remove(indexGlobalPartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof IndexHashPartitionOraclev10g) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)objectChangeEvent.getAffected();
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() != null && indexHashPartitionOraclev10g.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                indexHashPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(indexHashPartitionOraclev10g);
            } else {
                this.partitions.remove(indexHashPartitionOraclev10g);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
                indexGlobalPartitionOracle.addObjectListener(this);
                if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList() && !this.partitions.contains(indexGlobalPartitionOracle)) {
                    indexGlobalPartitionOracle.setParent(this.partitions);
                    this.partitions.add(indexGlobalPartitionOracle);
                } else {
                    this.partitions.remove(indexGlobalPartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)modelObjectSetEvent.getAffected();
                indexHashPartitionOraclev10g.addObjectListener(this);
                if (indexHashPartitionOraclev10g.getIndexGlobalPartList() != null && indexHashPartitionOraclev10g.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList() && !this.partitions.contains(indexHashPartitionOraclev10g)) {
                    indexHashPartitionOraclev10g.setParent(this.partitions);
                    this.partitions.add(indexHashPartitionOraclev10g);
                } else {
                    this.partitions.remove(indexHashPartitionOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
                this.partitions.remove(indexGlobalPartitionOracle);
                indexGlobalPartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)modelObjectSetEvent.getAffected();
                this.partitions.remove(indexHashPartitionOraclev10g);
                indexHashPartitionOraclev10g.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setIndexGlobalPartitionsList(IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle) {
        if (this.indexGlobalPartList != null && this.indexGlobalPartList != indexGlobalPartitionsListOracle) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        if (indexGlobalPartitionsListOracle != null) {
            this.indexGlobalPartList = indexGlobalPartitionsListOracle;
            this.indexGlobalPartList.setIndex(this);
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionsListOracle);
            if (((IndexProxyOracle)indexGlobalPartitionsListOracle.getIndex()).getIndexPartitioned().equalsIgnoreCase(PARTITIONED[2])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
                this.addIGPFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
            } else if (((IndexProxyOracle)indexGlobalPartitionsListOracle.getIndex()).getIndexPartitioned().equalsIgnoreCase(PARTITIONED[4])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
                this.addIndexHashPartitionFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
            } else {
                this.partitions.removeAll();
                this.partitions.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    protected void addIndexHashPartitionFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            indexHashPartitionOraclev10g.addObjectListener(this);
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() != null && indexHashPartitionOraclev10g.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                indexHashPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(indexHashPartitionOraclev10g);
                continue;
            }
            this.partitions.remove(indexHashPartitionOraclev10g);
        }
    }

    public String getLayerType() {
        return this.getIndex().getLayerType();
    }

    public String etGeodetic() {
        return this.getIndex().getGeodetic();
    }

    public String getDimensionsNumber() {
        return String.valueOf(this.getIndex().getDimensionsNumber());
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public TableSpaceOracle getWorkTablespace() {
        return this.workTablespace;
    }

    public void setWorkTablespace(TableSpaceOracle tableSpaceOracle) {
        this.workTablespace = tableSpaceOracle;
    }

    public String getNonLeaf() {
        return this.nonLeaf;
    }

    public void setNonLeaf(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.nonLeaf = string;
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Index index = (Index)storageDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxyOraclev10g indexProxyOraclev10g = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignOraclev10g)storageDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            indexProxyOraclev10g = (IndexProxyOraclev10g)relationalObjectProxy;
        }
        if (indexProxyOraclev10g != null) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            AbstractStorageObjectOracle abstractStorageObjectOracle2;
            Object object;
            indexProxyOraclev10g.setName(this.getName());
            if (this.getIndexGlobalPartitionsList() != null) {
                object = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionsListSet().getByName(this.getIndexGlobalPartitionsList().getName());
                if (object == null) {
                    abstractStorageObjectOracle2 = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    abstractStorageObjectOracle2.setName(this.getIndexGlobalPartitionsList().getName());
                    abstractStorageObjectOracle2.setRawObject(true);
                    ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle2).setIndex(indexProxyOraclev10g);
                    indexProxyOraclev10g.setIndexGlobalPartitionsList((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle2);
                } else {
                    ((IndexGlobalPartitionsListOracle)object).setIndex(indexProxyOraclev10g);
                    indexProxyOraclev10g.setIndexGlobalPartitionsList((IndexGlobalPartitionsListOracle)object);
                }
            }
            object = this.partitions.iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle2 = (IndexGlobalPartitionOraclev10g)object.next();
                abstractStorageObjectOracle = (IndexGlobalPartitionOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionSet().getByName(abstractStorageObjectOracle2.getName());
                if (abstractStorageObjectOracle == null) {
                    IndexGlobalPartitionOraclev10g indexGlobalPartitionOraclev10g = (IndexGlobalPartitionOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionSet().createIndexGlobalPartition();
                    indexGlobalPartitionOraclev10g.setName(abstractStorageObjectOracle2.getName());
                    indexGlobalPartitionOraclev10g.setRawObject(true);
                    indexGlobalPartitionOraclev10g.setIndexGlobalPartList(indexProxyOraclev10g.getIndexGlobalPartitionsList());
                    indexProxyOraclev10g.addIGPFromDesign(((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionSet());
                    continue;
                }
                ((IndexGlobalPartitionOracle)abstractStorageObjectOracle2).setIndexGlobalPartList(indexProxyOraclev10g.getIndexGlobalPartitionsList());
                indexProxyOraclev10g.addIGPFromDesign(((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionSet());
            }
            if (this.getUser() != null) {
                abstractStorageObjectOracle2 = (UserOraclev10g)((StorageDesignOraclev10g)storageDesign).getUserSet().getByName(this.getUser().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (UserOraclev10g)((StorageDesignOraclev10g)storageDesign).getUserSet().createUser();
                    ((UserOracle)abstractStorageObjectOracle).setName(this.getUser().getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    indexProxyOraclev10g.setUser((UserOracle)abstractStorageObjectOracle);
                } else {
                    indexProxyOraclev10g.setUser((UserOracle)abstractStorageObjectOracle2);
                }
            }
            indexProxyOraclev10g.setBitmapIndex(this.getBitmapIndex());
            indexProxyOraclev10g.setIndexPartitioned(this.getIndexPartitioned());
            if (this.getTableSpace() != null) {
                abstractStorageObjectOracle2 = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)abstractStorageObjectOracle).setName(this.getTableSpace().getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    indexProxyOraclev10g.setTableSpace((TableSpaceOracle)abstractStorageObjectOracle);
                } else {
                    indexProxyOraclev10g.setTableSpace((TableSpaceOracle)abstractStorageObjectOracle2);
                }
            }
            indexProxyOraclev10g.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                abstractStorageObjectOracle2 = (SegmentOraclev10g)((StorageDesignOraclev10g)storageDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (SegmentOraclev10g)((StorageDesignOraclev10g)storageDesign).getSegmentSet().createSegment();
                    abstractStorageObjectOracle.setName(this.getSegment().getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    indexProxyOraclev10g.setSegment((SegmentOracle)abstractStorageObjectOracle);
                } else {
                    indexProxyOraclev10g.setSegment((SegmentOracle)abstractStorageObjectOracle2);
                }
            }
            indexProxyOraclev10g.setCompress(this.getCompress());
            indexProxyOraclev10g.setParallel(this.getParallel());
            indexProxyOraclev10g.setDegree(this.getDegree());
            indexProxyOraclev10g.setSortedRows(this.getSortedRows());
            indexProxyOraclev10g.setComputeStatistics(this.getComputeStatistics());
            indexProxyOraclev10g.setOnline(this.getOnline());
            indexProxyOraclev10g.setRawObject(false);
        }
    }
}

