/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;

public class IndexGlobalPartitionsListOraclev10g
extends IndexGlobalPartitionsListOracle {
    private IndexGlobalPartitionsListOracle.InlineList hashPartitionsTableSpacesSet = null;
    private String hashpTableSpaces = "";
    private int hashpQuantity = 0;
    private IndexGlobalPartitionsListOracle.InlineList IOTOverflowHashPTSSet = null;
    private String IOTOverflowHashPTS = "";

    public String getIOTOverflowHashPTS() {
        return this.IOTOverflowHashPTS;
    }

    public void setIOTOverflowHashPTSSet(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIOTOverflowHashPTSSet(string);
        } else {
            this.addIOTOverflowHashPTS(string);
        }
        this.IOTOverflowHashPTS = this.getIOTOverflowHashPTSSet().toString();
        this.fireDataFieldChange();
    }

    public String getAllIOTOverflowHashPTS() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.IOTOverflowHashPTS, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    private void addIOTOverflowHashPTS(String string) {
        if (!this.getIOTOverflowHashPTSSet().contains(string)) {
            this.getIOTOverflowHashPTSSet().add(string);
        }
    }

    private void recreateIOTOverflowHashPTSSet(String string) {
        this.getIOTOverflowHashPTSSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getIOTOverflowHashPTSSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public IndexGlobalPartitionsListOracle.InlineList getIOTOverflowHashPTSSet() {
        if (this.IOTOverflowHashPTSSet == null) {
            this.IOTOverflowHashPTSSet = new IndexGlobalPartitionsListOracle.InlineList();
        }
        return this.IOTOverflowHashPTSSet;
    }

    public String getHashPTableSpaces() {
        return this.hashpTableSpaces;
    }

    public String getAllHashPTS() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.hashpTableSpaces, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public void setHashPTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashPartitionsTSSet(string);
        } else {
            this.addHashPartitionsTS(string);
        }
        this.hashpTableSpaces = this.getHashPartitionsTableSpacesSet().toString();
        this.fireDataFieldChange();
    }

    private void recreateHashPartitionsTSSet(String string) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void addHashPartitionsTS(String string) {
        if (!this.getHashPartitionsTableSpacesSet().contains(string)) {
            this.getHashPartitionsTableSpacesSet().add(string);
        }
    }

    public IndexGlobalPartitionsListOracle.InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new IndexGlobalPartitionsListOracle.InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    @Override
    public void clear() {
        super.clear();
        this.getIOTOverflowHashPTSSet().clear();
        this.getHashPartitionsTableSpacesSet().clear();
        this.IOTOverflowHashPTS = "";
        this.hashpTableSpaces = "";
    }

    public int getHashPQuantity() {
        return this.hashpQuantity;
    }

    public void setHashPQuantity(int n) {
        this.hashpQuantity = n;
        this.fireDataFieldChange();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = null;
        IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g2 = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionsListSet().getByName(this.getName());
        if (indexGlobalPartitionsListOraclev10g2 != null) {
            if (!this.isRawObject()) {
                indexGlobalPartitionsListOraclev10g = indexGlobalPartitionsListOraclev10g2;
            }
        } else {
            indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
        }
        if (indexGlobalPartitionsListOraclev10g != null) {
            indexGlobalPartitionsListOraclev10g.setName(this.getName());
            if (this.getIndex() != null) {
                IndexProxyOraclev10g indexProxyOraclev10g = (IndexProxyOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexProxySet().getByName(this.getIndex().getName());
                if (indexProxyOraclev10g == null) {
                    IndexProxyOraclev10g indexProxyOraclev10g2 = (IndexProxyOraclev10g)((IndexProxySetOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexProxySet()).createProxy(this.getIndex().getObject());
                    indexProxyOraclev10g2.setName(this.getIndex().getName());
                    indexProxyOraclev10g2.setRawObject(true);
                    indexProxyOraclev10g2.setIndexGlobalPartitionsList(indexGlobalPartitionsListOraclev10g);
                    indexGlobalPartitionsListOraclev10g.setIndex(indexProxyOraclev10g2);
                } else {
                    indexProxyOraclev10g.setIndexGlobalPartitionsList(indexGlobalPartitionsListOraclev10g);
                    indexGlobalPartitionsListOraclev10g.setIndex(indexProxyOraclev10g);
                }
            }
            indexGlobalPartitionsListOraclev10g.setHashPQuantity(this.getHashPQuantity());
            indexGlobalPartitionsListOraclev10g.recreateHashPartitionsTSSet(this.getHashPartitionsTableSpacesSet().toString());
            indexGlobalPartitionsListOraclev10g.recreateIOTOverflowHashPTSSet(this.getIOTOverflowHashPTSSet().toString());
            indexGlobalPartitionsListOraclev10g.recreateColumnsSet(this.getColumnSet().toString());
            indexGlobalPartitionsListOraclev10g.setRawObject(false);
        }
    }
}

