/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.DiskGroupPropertyDialogOraclev10g;

public class DiskGroupOraclev10g
extends AbstractStorageObjectOracle
implements StorageObjectListener,
ModelObjectSetListener {
    StorageObjectCollection failGroups;
    private static Set redundancySet = null;
    private String redundancy = REDUNDANCY_STATES[0];
    private static final String[] REDUNDANCY_STATES = new String[]{"NORMAL", "HIGH", "EXTERNAL"};
    public static final String TYPE_NAME = "DiskGroup";

    public DiskGroupOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.failGroups = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getFailGroupSet());
        this.failGroups.setParent(this);
        this.failGroups.setName(Messages.getString("DiskGroupOraclev10g.FailGroup"));
        this.failGroups.setSetMethod("setDiskGroup");
        this.failGroups.setClassForParent(DiskGroupOraclev10g.class);
        this.failGroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        ((StorageDesignOraclev10g)storageDesign).getFailGroupSet().addSetListener(this);
    }

    public String getRedundancy() {
        return this.redundancy;
    }

    public void setRedundancy(String string) {
        if (this.checkRedundancyState(string)) {
            this.redundancy = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkRedundancyState(String string) {
        if (redundancySet == null) {
            redundancySet = new HashSet();
            redundancySet.addAll(Arrays.asList(DiskGroupOraclev10g.getRedundancyStates()));
        }
        return redundancySet.contains(string);
    }

    public static String[] getRedundancyStates() {
        return REDUNDANCY_STATES;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DiskGroupPropertyDialogOraclev10g diskGroupPropertyDialogOraclev10g = new DiskGroupPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            diskGroupPropertyDialogOraclev10g.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DG";
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.failGroups;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.failGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.failGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.failGroups.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof FailGroupOraclev10g) {
                FailGroupOraclev10g failGroupOraclev10g = (FailGroupOraclev10g)modelObjectSetEvent.getAffected();
                failGroupOraclev10g.addObjectListener(this);
                if (failGroupOraclev10g.getDiskGroup() != null && failGroupOraclev10g.getDiskGroup() == this) {
                    failGroupOraclev10g.setParent(this.failGroups);
                    this.failGroups.add(failGroupOraclev10g);
                } else {
                    this.failGroups.remove(failGroupOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof FailGroupOraclev10g) {
            FailGroupOraclev10g failGroupOraclev10g = (FailGroupOraclev10g)modelObjectSetEvent.getAffected();
            this.failGroups.remove(failGroupOraclev10g);
            failGroupOraclev10g.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof FailGroupOraclev10g) {
            FailGroupOraclev10g failGroupOraclev10g = (FailGroupOraclev10g)objectChangeEvent.getAffected();
            if (failGroupOraclev10g.getDiskGroup() != null && failGroupOraclev10g.getDiskGroup() == this) {
                failGroupOraclev10g.setParent(this.failGroups);
                this.failGroups.add(failGroupOraclev10g);
            } else {
                this.failGroups.remove(failGroupOraclev10g);
            }
        }
    }

    public List getFailGroups() {
        ArrayList arrayList = new ArrayList();
        this.failGroups.addAllElementsTo(arrayList);
        return arrayList;
    }

    public StorageObjectCollection getFailGroupCollection() {
        return this.failGroups;
    }

    public FailGroupOraclev10g createFailGroup() {
        if (this.failGroups.getStorageObjectSet() != null) {
            return (FailGroupOraclev10g)this.failGroups.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        DiskGroupOraclev10g diskGroupOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)storageDesign).getDiskGroupSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                diskGroupOraclev10g = (DiskGroupOraclev10g)storageObject;
            }
        } else {
            diskGroupOraclev10g = ((StorageDesignOraclev10g)storageDesign).getDiskGroupSet().createDiskGroup();
        }
        if (diskGroupOraclev10g != null) {
            diskGroupOraclev10g.setName(this.getName());
            for (FailGroupOraclev10g failGroupOraclev10g : this.getFailGroups()) {
                FailGroupOraclev10g failGroupOraclev10g2 = (FailGroupOraclev10g)((StorageDesignOraclev10g)storageDesign).getFailGroupSet().getByName(failGroupOraclev10g.getName());
                if (failGroupOraclev10g2 == null) {
                    FailGroupOraclev10g failGroupOraclev10g3 = ((StorageDesignOraclev10g)storageDesign).getFailGroupSet().createFailGroup();
                    failGroupOraclev10g3.setName(failGroupOraclev10g.getName());
                    failGroupOraclev10g3.setDiskGroup(diskGroupOraclev10g);
                    failGroupOraclev10g3.setRawObject(true);
                    diskGroupOraclev10g.getFailGroups().add(failGroupOraclev10g3);
                    continue;
                }
                failGroupOraclev10g2.setDiskGroup(diskGroupOraclev10g);
                diskGroupOraclev10g.getFailGroups().add(failGroupOraclev10g2);
            }
            diskGroupOraclev10g.setRedundancy(this.getRedundancy());
            diskGroupOraclev10g.setComment(this.getComment());
            diskGroupOraclev10g.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DISK_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.failGroups.removeAll();
    }
}

