/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.string.Crypt;

public abstract class UserOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private static final String[] AUTH_TYPES = new String[]{"BY_PASSWORD", "EXTERNALLY", "GLOBALLY"};
    private static List authTypesList = Arrays.asList(AUTH_TYPES);
    private static Set authTypeSet = null;
    private String authType = AUTH_TYPES[0];
    private String identifier = "";
    private TableSpaceOracle defTableSpace = null;
    private TemporaryTablespaceOracle tempTableSpace = null;
    private String profile = "";
    private String passwordExpire = "NO";
    private String accountLock = "NO";
    private StorageObjectCollection quotaitems;
    private String externalName = "";
    private static Crypt crypt = new Crypt();
    protected InlineList roleSet = null;
    protected InlineList rolesWithAdminOptionSet = null;
    protected InlineList systemPrivilegesSet = null;
    protected InlineList privilegesWithAdminOptionSet = null;
    protected String roles = "";
    protected String rolesWithAdminOption = "";
    protected String systemPrivileges = "";
    protected String privilegesWithAdminOption = "";
    protected String adminOption = "NO";
    public static final String NAME_SUBSTITUTION_TYPE = "User";
    public static final String TYPE_NAME = "User";

    public UserOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.quotaitems = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getQuotaItemSet());
        this.quotaitems.setParent(this);
        this.quotaitems.setName(Messages.getString("UserOracle.Quotas"));
        this.quotaitems.setClassForParent(UserOracle.class);
        this.quotaitems.setSetMethod("setUser");
        this.quotaitems.setIcon(GUIConfiguration.getInstance().getIcon("QUOTA_ITEM_ICON", 16));
        ((StorageDesignOracle)storageDesign).getQuotaItemSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "User";
    }

    @Override
    public String getObjectTypeName() {
        return "User";
    }

    public static String[] getAuthTypes() {
        return AUTH_TYPES;
    }

    protected boolean checkAuthType(String string) {
        if (authTypeSet == null) {
            authTypeSet = new HashSet();
            authTypeSet.addAll(Arrays.asList(UserOracle.getAuthTypes()));
        }
        return authTypeSet.contains(string);
    }

    public void setAuthType(String string) {
        if (this.checkAuthType(string)) {
            this.authType = string;
            this.fireDataFieldChange();
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String decodeIdentifier() {
        String string = this.getDesign().getLoadedVersion() < 3.3f ? this.identifier : crypt.decrypt(this.identifier);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public void encodeIdentifier(String string) {
        this.identifier = crypt.encrypt(string);
    }

    public TableSpaceOracle getDefTableSpace() {
        return this.defTableSpace;
    }

    public void setDefTableSpace(TableSpaceOracle tableSpaceOracle) {
        this.defTableSpace = tableSpaceOracle;
        this.fireDataFieldChange();
    }

    public TemporaryTablespaceOracle getTempTableSpace() {
        return this.tempTableSpace;
    }

    public void setTempTableSpace(TemporaryTablespaceOracle temporaryTablespaceOracle) {
        this.tempTableSpace = temporaryTablespaceOracle;
        this.fireDataFieldChange();
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String string) {
        this.profile = string;
    }

    public void setPasswordExpire(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.passwordExpire = string;
            this.fireDataFieldChange();
        }
    }

    public String getPasswordExpire() {
        return this.passwordExpire;
    }

    public void setAccountLock(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.accountLock = string;
            this.fireDataFieldChange();
        }
    }

    public String getAccountLock() {
        return this.accountLock;
    }

    public static List getAuthTypesValues() {
        return authTypesList;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof QuotaItemOracle) {
                QuotaItemOracle quotaItemOracle = (QuotaItemOracle)modelObjectSetEvent.getAffected();
                quotaItemOracle.addObjectListener(this);
                if (quotaItemOracle.getUser() != null && quotaItemOracle.getUser() == this) {
                    quotaItemOracle.setParent(this.quotaitems);
                    this.quotaitems.add(quotaItemOracle);
                } else {
                    this.quotaitems.remove(quotaItemOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof HashPartitionLobItemOracle) {
            QuotaItemOracle quotaItemOracle = (QuotaItemOracle)modelObjectSetEvent.getAffected();
            this.quotaitems.remove(quotaItemOracle);
            quotaItemOracle.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof QuotaItemOracle) {
            QuotaItemOracle quotaItemOracle = (QuotaItemOracle)objectChangeEvent.getAffected();
            if (quotaItemOracle.getUser() != null && quotaItemOracle.getUser() == this) {
                quotaItemOracle.setParent(this.quotaitems);
                this.quotaitems.add(quotaItemOracle);
            } else {
                this.quotaitems.remove(quotaItemOracle);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.quotaitems;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.quotaitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.quotaitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void setAdminOption(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.adminOption = string;
            this.fireDataFieldChange();
        }
    }

    public String getAdminOption() {
        return this.adminOption;
    }

    public void setRoles(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRoleSet(string);
        } else {
            this.addRole(string);
        }
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public String getRoles() {
        return this.roles;
    }

    public void addRole(String string) {
        if (!this.getRolesSet().contains(string)) {
            this.getRolesSet().add(string);
        }
    }

    public void recreateRoleSet(String string) {
        this.getRolesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getRolesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getRolesSet() {
        if (this.roleSet == null) {
            this.roleSet = new InlineList();
        }
        return this.roleSet;
    }

    public void setRolesWithAdminOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRolesWithAdminOptionSet(string);
        } else {
            this.addRoleWithAdminOption(string);
        }
        this.rolesWithAdminOption = this.getRolesWithAdminOptionSet().toString();
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getRolesWithAdminOptionSet() {
        if (this.rolesWithAdminOptionSet == null) {
            this.rolesWithAdminOptionSet = new InlineList();
        }
        return this.rolesWithAdminOptionSet;
    }

    public String getRolesWithAdminOptionNames() {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle roleSetOracle = storageDesignOracle.getRoleSet();
        String string = "";
        boolean bl = true;
        Object[] objectArray = this.getRolesWithAdminOptionSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            RoleOracle roleOracle = (RoleOracle)roleSetOracle.getById(string2);
            if (roleOracle == null) continue;
            if (!bl) {
                string = string + "," + roleOracle.getName();
                continue;
            }
            string = roleOracle.getName();
            bl = false;
        }
        return string;
    }

    public String getRolesNames() {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle roleSetOracle = storageDesignOracle.getRoleSet();
        String string = "";
        boolean bl = true;
        Object[] objectArray = this.getRolesSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            RoleOracle roleOracle = (RoleOracle)roleSetOracle.getById(string2);
            if (roleOracle == null) continue;
            if (!bl) {
                string = string + "," + roleOracle.getName();
                continue;
            }
            string = roleOracle.getName();
            bl = false;
        }
        return string;
    }

    protected void recreateRolesWithAdminOptionSet(String string) {
        this.getRolesWithAdminOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getRolesWithAdminOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void addRoleWithAdminOption(String string) {
        if (!this.getRolesWithAdminOptionSet().contains(string)) {
            this.getRolesWithAdminOptionSet().add(string);
        }
    }

    public String getRolesWithAdminOption() {
        return this.rolesWithAdminOption;
    }

    public void setPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else {
            this.addPrivilege(string);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void addPrivilege(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
        }
    }

    public void setPrivilegesWithAdminOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithAdminOptionSet(string);
        } else {
            this.addPrivilegeWithAdminOption(string);
        }
        this.privilegesWithAdminOption = this.getPrivilegesWithAdminOptionSet().toString();
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesWithAdminOptionSet() {
        if (this.privilegesWithAdminOptionSet == null) {
            this.privilegesWithAdminOptionSet = new InlineList();
        }
        return this.privilegesWithAdminOptionSet;
    }

    public String getPrivilegesWithAdminOption() {
        return this.privilegesWithAdminOption;
    }

    protected void recreatePrivilegesWithAdminOptionSet(String string) {
        this.getPrivilegesWithAdminOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesWithAdminOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void addPrivilegeWithAdminOption(String string) {
        if (!this.getPrivilegesWithAdminOptionSet().contains(string)) {
            this.getPrivilegesWithAdminOptionSet().add(string);
        }
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithAdminOptionSet().removeAllElements();
        this.getRolesSet().removeAllElements();
        this.getRolesWithAdminOptionSet().removeAllElements();
        this.roles = "";
        this.rolesWithAdminOption = "";
        this.systemPrivileges = "";
        this.privilegesWithAdminOption = "";
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String string) {
        this.externalName = string;
    }

    @Override
    public String getNameSubstitutionType() {
        return "User";
    }

    public List getQuotaItems() {
        ArrayList arrayList = new ArrayList();
        this.quotaitems.addAllElementsTo(arrayList);
        return arrayList;
    }

    public StorageObjectCollection getQuotaItemsCollection() {
        return this.quotaitems;
    }

    public QuotaItemOracle createQuotaItem() {
        if (this.quotaitems.getStorageObjectSet() != null) {
            return (QuotaItemOracle)this.quotaitems.createElement(null);
        }
        return null;
    }

    public List getPermissions() {
        ArrayList<PermissionsOracle> arrayList = new ArrayList<PermissionsOracle>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getUser() != this) continue;
            arrayList.add(permissionsOracle);
        }
        return arrayList;
    }

    public PermissionsOracle createPermission() {
        PermissionsOracle permissionsOracle = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permissionsOracle.setUser(this);
        return permissionsOracle;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.quotaitems.removeAll();
    }

    @Override
    public void setSchemaObject(SchemaObject schemaObject) {
        if (schemaObject != null && this.schemaObject != schemaObject) {
            ((StorageDesignOracle)this.getStorageDesign()).getUserSet().clearSchemaObjectForOthers(schemaObject, this);
        }
        this.schemaObject = schemaObject;
    }

    public String getDDLName() {
        if (this.isNameChanged() || this.getSchemaObject() == null) {
            return this.getName();
        }
        return this.getSchemaObject().getName();
    }

    @Override
    public boolean setName(String string) {
        return super.setName(string);
    }

    @Override
    public void remove() {
        this.removePermissions();
        super.remove();
    }

    @Override
    public void remove(boolean bl) {
        this.removePermissions();
        super.remove(bl);
    }

    private void removePermissions() {
        for (PermissionsOracle permissionsOracle : this.getPermissions()) {
            permissionsOracle.clear();
            permissionsOracle.remove();
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }
}

