/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class UniqueOracle
extends IndexProxyOracle
implements StorageObjectListener,
ModelObjectSetListener {
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static List initiallyList = Arrays.asList(INITIALLY);
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String deferrable = "NO";
    private String enable = "YES";
    private String validate = "YES";
    protected IndexGlobalPartitionsListOracle indexGlobalPartitionList = null;
    private TableSpaceOracle tableSpace = null;
    private String logging = "YES";
    private SegmentOracle indexSegment = null;
    private TableProxyOracle exceptionsTable = null;
    protected StorageObjectCollection partitions;
    protected IndexProxyOracle existingIndexProxy = null;

    public UniqueOracle(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    public UniqueOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    @Override
    protected void initPartitions(StorageDesignOracle storageDesignOracle) {
        this.partitions = new StorageObjectCollection(storageDesignOracle.getIndexGlobalPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("UniqueOracle.GlobalPartitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(IndexGlobalPartitionsListOracle.class);
        this.partitions.setSetMethod("setIndexGlobalPartList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getIndexGlobalPartitionSet().addSetListener(this);
        this.addIGPFromDesign(storageDesignOracle.getIndexGlobalPartitionSet());
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            ((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        }
    }

    @Override
    public String getIDPrefix() {
        return "Unique";
    }

    @Override
    public String getObjectTypeName() {
        return "Unique";
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        this.fireChange(objectChangeEvent);
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    private boolean checkInitially(String string) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(UniqueOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(string);
    }

    public void setInitially(String string) {
        if (this.checkInitially(string)) {
            this.initially = string;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.deferrable = string;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.enable = string;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.validate = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public abstract void setIndexSort(String var1);

    public abstract String getIndexSort();

    public IndexGlobalPartitionsListOracle getUsingIndexGlobalPL() {
        return this.indexGlobalPartitionList;
    }

    public void setUsingIndexGlobalPL(IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle) {
        if (this.indexGlobalPartitionList != null && this.indexGlobalPartitionList != indexGlobalPartitionsListOracle) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        this.indexGlobalPartitionList = indexGlobalPartitionsListOracle;
        if (this.indexGlobalPartitionList != null) {
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionsListOracle);
            this.addIGPFromDesign(((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionSet());
        }
        this.fireDataFieldChange();
    }

    @Override
    public TableSpaceOracle getTableSpace() {
        if (this.tableSpace == null && this.indexSegment != null) {
            this.tableSpace = this.indexSegment.getTableSpace();
        }
        return this.tableSpace;
    }

    @Override
    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        this.tableSpace = tableSpaceOracle;
        this.fireDataFieldChange();
    }

    @Override
    public String getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getIndexSegment() {
        return this.indexSegment;
    }

    public void setIndexSegment(SegmentOracle segmentOracle) {
        this.indexSegment = segmentOracle;
        this.fireDataFieldChange();
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle tableProxyOracle) {
        this.exceptionsTable = tableProxyOracle;
        this.fireDataFieldChange();
    }

    public static List getInitiallyValues() {
        return initiallyList;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
                if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getUsingIndexGlobalPL() && !this.partitions.contains(indexGlobalPartitionOracle)) {
                    indexGlobalPartitionOracle.setParent(this.partitions);
                    this.partitions.add(indexGlobalPartitionOracle);
                } else {
                    this.partitions.remove(indexGlobalPartitionOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
            this.partitions.remove(indexGlobalPartitionOracle);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.partitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.partitions.removeAll();
    }

    @Override
    protected void addIGPFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)iterator.next();
            if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                indexGlobalPartitionOracle.setParent(this.partitions);
                this.partitions.add(indexGlobalPartitionOracle);
                continue;
            }
            this.partitions.remove(indexGlobalPartitionOracle);
        }
    }

    public abstract void setUsingIndex(String var1);

    public abstract String getUsingIndex();

    private void removeNonExistingIndex() {
        Index index;
        if (!(this.existingIndexProxy == null || (index = this.existingIndexProxy.getIndex()) != null && this.getTable().getKeySet().contains(index))) {
            this.existingIndexProxy = null;
        }
    }

    public IndexProxyOracle getExistingIndex() {
        this.removeNonExistingIndex();
        return this.existingIndexProxy;
    }

    public void setExistingIndex(IndexProxyOracle indexProxyOracle) {
        this.existingIndexProxy = indexProxyOracle;
        this.fireDataFieldChange();
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public StorageObjectCollection getGlobalPartitions() {
        return this.partitions;
    }

    @Override
    public StorageObject createGlobalPartition() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public IndexGlobalPartitionsListOracle createIndexGlobalPL() {
        IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle = (IndexGlobalPartitionsListOracle)((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionsListSet().createElement(null);
        indexGlobalPartitionsListOracle.setIndex(this);
        return indexGlobalPartitionsListOracle;
    }

    public void clearIndexGlobalPL() {
        IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle = this.indexGlobalPartitionList;
        if (indexGlobalPartitionsListOracle != null) {
            this.setUsingIndexGlobalPL(null);
            indexGlobalPartitionsListOracle.remove();
        }
    }
}

