/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class TableViewProxyOracle
extends TableViewProxy
implements ModelObjectSetListener,
StorageObjectListener {
    private UserOracle user = null;
    private String force = "NO";
    private String readOnly = "NO";
    private String checkOptionName = "";
    protected StorageObjectCollection triggers;
    private String useOID = "";
    public static final String[] USE_OID_CHOICES = new String[]{"", "DEFAULT", "LIST OF ATTRIBUTES"};
    private static Set useOidSet = null;

    public TableViewProxyOracle(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
        this.triggers = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyOracle.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignOracle)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignOracle)storageDesign).getTriggerSet());
    }

    public TableViewProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.triggers = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyOracle.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignOracle)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignOracle)storageDesign).getTriggerSet());
    }

    @Override
    public String getIDPrefix() {
        return "VIEW";
    }

    @Override
    public String getObjectTypeName() {
        return "View";
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setForce(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.force = string;
            this.fireDataFieldChange();
        }
    }

    public String getForce() {
        return this.force;
    }

    public void setReadOnly(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.readOnly = string;
            this.fireDataFieldChange();
        }
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public void setViewReadOnly(String string) {
        this.setReadOnly(string);
    }

    public String getViewReadOnly() {
        return this.getReadOnly();
    }

    public String getCheckOptionName() {
        return this.checkOptionName;
    }

    public void setCheckOptionName(String string) {
        this.checkOptionName = string;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            UserOracle userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(schemaObject);
            if (userOracle != null) {
                return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TriggerOracle) {
            TriggerOracle triggerOracle = (TriggerOracle)objectChangeEvent.getAffected();
            if (triggerOracle.getView() != null && triggerOracle.getView() == this) {
                triggerOracle.setParent(this.triggers);
                this.triggers.add(triggerOracle);
            } else if (!ApplicationView.loading) {
                this.triggers.remove(triggerOracle);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerOracle) {
                TriggerOracle triggerOracle = (TriggerOracle)modelObjectSetEvent.getAffected();
                triggerOracle.addObjectListener(this);
                if (triggerOracle.getView() != null && triggerOracle.getView() == this) {
                    triggerOracle.setParent(this.triggers);
                    this.triggers.add(triggerOracle);
                } else if (!ApplicationView.loading) {
                    this.triggers.remove(triggerOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof TriggerOracle) {
            TriggerOracle triggerOracle = (TriggerOracle)modelObjectSetEvent.getAffected();
            this.triggers.remove(triggerOracle);
            triggerOracle.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.triggers;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.triggers) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.triggers) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.triggers.removeAll();
    }

    protected void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerOracle triggerOracle = (TriggerOracle)iterator.next();
            triggerOracle.addObjectListener(this);
            if (triggerOracle.getView() != null && triggerOracle.getView() == this) {
                triggerOracle.setParent(this.triggers);
                this.triggers.add(triggerOracle);
                continue;
            }
            this.triggers.remove(triggerOracle);
        }
    }

    public ColumnProxyOracle getColumnProxyByName(String string) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
            if (!string.equals(columnProxyOracle.getName())) continue;
            return columnProxyOracle;
        }
        return null;
    }

    public String getOidAttributes() {
        return ((TableView)this.getObject()).getOidText();
    }

    public void setOidAttributes(String string) {
    }

    public String getUseOID() {
        return this.useOID;
    }

    public void setUseOID(String string) {
        if (this.checkUseOid(string)) {
            this.useOID = string;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkUseOid(String string) {
        if (useOidSet == null) {
            useOidSet = new HashSet();
            useOidSet.addAll(Arrays.asList(USE_OID_CHOICES));
        }
        return useOidSet.contains(string);
    }

    public String getBasedOnStructuredType() {
        if (((TableView)this.getObject()).getBasedOnStructuredType() == null) {
            return "";
        }
        return ((TableView)this.getObject()).getBasedOnStructuredType().getName();
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getUser();
    }

    @Override
    public void setUserSchema(String string) {
        if (string != null) {
            UserOracle userOracle = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(string);
            if (userOracle == null) {
                userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().createUser();
                userOracle.setName(string);
            }
            if (userOracle != null) {
                this.setUser(userOracle);
            }
        }
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.triggers.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }
}

