/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;

public abstract class TableSpaceOracle
extends AbstractStorageObjectOracle
implements RelationalObjectProxySetListener,
ModelObjectSetListener,
StorageObjectListener,
StatementsConstants,
PropertiesPropagator {
    public static final String PERMANENT = "PERMANENT";
    public static final String AUTOALLOCATE = "AUTOALLOCATE";
    private static final String[] LOG_STATES = new String[]{"LOGGING", "NOLOGGING"};
    private static final String[] STATUS_STATES = new String[]{"ONLINE", "OFFLINE"};
    private static final String[] CONTENTS_STATES = new String[]{"PERMANENT", "TEMPORARY"};
    protected static final String[] EXTEND_MANAGE_STATES = new String[]{"DICTIONARY", "LOCAL"};
    private static final String[] EM_SUBTYPE_STATES = new String[]{"AUTOALLOCATE", "UNIFORM"};
    private static List loggingList = Arrays.asList(LOG_STATES);
    private static List statusList = Arrays.asList(STATUS_STATES);
    private static List contentsList = Arrays.asList(CONTENTS_STATES);
    private static List extendManageList = Arrays.asList(EXTEND_MANAGE_STATES);
    private static List emLocalSubtypeList = Arrays.asList(EM_SUBTYPE_STATES);
    private Map tableMap = new HashMap();
    private List tables = new ArrayList();
    private int minExtLen = 0;
    private static Set logSet = null;
    private String logging = LOG_STATES[0];
    private static Set statusSet = null;
    private String status = STATUS_STATES[0];
    private static Set contentsSet = null;
    private String contents = CONTENTS_STATES[0];
    private long dsInitialExtent = 0L;
    private long dsNextExtent = 0L;
    private int dsMinExtents = 1;
    private String dsMaxExtents = "UNLIMITED";
    private int dsPctIncrease = 0;
    private static Set extManageSet = null;
    protected String extentManagement = EXTEND_MANAGE_STATES[0];
    private static Set emSubtypeSet = null;
    private String emLocalSubtype = EM_SUBTYPE_STATES[0];
    private int emUniformSize = 0;
    private StorageObjectCollection tabcoll;
    private StorageObjectCollection dfiles;
    public static final String NAME_SUBSTITUTION_TYPE = "Tablespace";
    private String defaultForTable;
    public static final String TYPE_NAME = "TSpace";
    public static final String OLD_TYPE_NAME = "TableSpaceOracle";

    public TableSpaceOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.setParent(((StorageDesignOracle)storageDesign).getTableSpaceSet());
        this.tabcoll = new StorageObjectCollection();
        this.tabcoll.setParent(this);
        this.tabcoll.setName(Messages.getString("TableSpaceOracle.Tables"));
        this.tabcoll.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        this.registerToTableProxyFromDesign(storageDesign.getTableProxySet());
        storageDesign.getTableProxySet().addSetListener(this);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setTableSpace");
        this.dfiles.setClassForParent(TableSpaceOracle.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public boolean setName(String string) {
        if (string.equalsIgnoreCase("EXAMPLE") || string.equalsIgnoreCase("SYSAUX") || string.equalsIgnoreCase("SYSTEM") || string.equalsIgnoreCase("USERS")) {
            this.setMarkedGenerate(false);
        }
        return super.setName(string);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TableProxy) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)objectChangeEvent.getAffected();
            if (tableProxyOracle.getTableSpace() != null && tableProxyOracle.getTableSpace() == this) {
                StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableProxyOracle);
                storageObjectPlaceHolder.setParent(this.tabcoll);
                this.tabcoll.add(storageObjectPlaceHolder);
            } else if (tableProxyOracle.getTableSpace() == null || tableProxyOracle.getTableSpace() != null && tableProxyOracle.getTableSpace() != this) {
                this.tabcoll.removePlaceHolderFor(tableProxyOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof DataFileOracle) {
            DataFileOracle dataFileOracle = (DataFileOracle)objectChangeEvent.getAffected();
            if (dataFileOracle.getTableSpace() != null && dataFileOracle.getTableSpace() == this) {
                dataFileOracle.setParent(this.dfiles);
                this.dfiles.add(dataFileOracle);
            } else {
                this.dfiles.remove(dataFileOracle);
            }
        }
    }

    @Override
    public String getIDPrefix() {
        return "TableSpace";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public int getMinExtLen() {
        return this.minExtLen;
    }

    public void setMinExtLen(int n) {
        this.minExtLen = n;
    }

    public static String[] getLogStates() {
        return LOG_STATES;
    }

    protected boolean checkLogState(String string) {
        if (logSet == null) {
            logSet = new HashSet();
            logSet.addAll(Arrays.asList(TableSpaceOracle.getLogStates()));
        }
        return logSet.contains(string);
    }

    public void setLogging(String string) {
        if (this.checkLogState(string)) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public static String[] getStatusStates() {
        return STATUS_STATES;
    }

    protected boolean checkStatusState(String string) {
        if (statusSet == null) {
            statusSet = new HashSet();
            statusSet.addAll(Arrays.asList(TableSpaceOracle.getStatusStates()));
        }
        return statusSet.contains(string);
    }

    public void setStatus(String string) {
        if (this.checkStatusState(string)) {
            this.status = string;
            this.fireDataFieldChange();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public static String[] getContentsStates() {
        return CONTENTS_STATES;
    }

    protected boolean checkContentsState(String string) {
        if (contentsSet == null) {
            contentsSet = new HashSet();
            contentsSet.addAll(Arrays.asList(TableSpaceOracle.getContentsStates()));
        }
        return contentsSet.contains(string);
    }

    public void setContents(String string) {
        if (this.checkContentsState(string)) {
            this.contents = string;
            this.fireDataFieldChange();
        }
    }

    public String getContents() {
        return this.contents;
    }

    public long getDSInitialExtent() {
        return this.dsInitialExtent;
    }

    public void setDSInitialExtent(long l) {
        this.dsInitialExtent = l;
    }

    public long getDSNextExtent() {
        return this.dsNextExtent;
    }

    public void setDSNextExtent(long l) {
        this.dsNextExtent = l;
    }

    public int getDSMinExtents() {
        return this.dsMinExtents;
    }

    public void setDSMinExtents(int n) {
        this.dsMinExtents = n;
    }

    public String getDSMaxExtents() {
        return this.dsMaxExtents;
    }

    public void setDSMaxExtents(String string) {
        try {
            this.dsMaxExtents = Integer.parseInt(string) > 0 ? string : "UNLIMITED";
        }
        catch (NumberFormatException numberFormatException) {
            this.dsMaxExtents = "UNLIMITED";
        }
    }

    public int getDSPctIncrease() {
        return this.dsPctIncrease;
    }

    public void setDSPctIncrease(int n) {
        this.dsPctIncrease = n;
    }

    public static String[] getExtManageStates() {
        return EXTEND_MANAGE_STATES;
    }

    protected boolean checkExtManageState(String string) {
        if (extManageSet == null) {
            extManageSet = new HashSet();
            extManageSet.addAll(Arrays.asList(TableSpaceOracle.getExtManageStates()));
        }
        return extManageSet.contains(string);
    }

    public void setExtentManagement(String string) {
        if (this.checkExtManageState(string)) {
            this.extentManagement = string;
            this.fireDataFieldChange();
        }
    }

    public String getExtentManagement() {
        return this.extentManagement;
    }

    public static String[] getEmLocalSubtypeStates() {
        return EM_SUBTYPE_STATES;
    }

    protected boolean checkEmLocalSubtypeState(String string) {
        if (emSubtypeSet == null) {
            emSubtypeSet = new HashSet();
            emSubtypeSet.addAll(Arrays.asList(TableSpaceOracle.getEmLocalSubtypeStates()));
        }
        return emSubtypeSet.contains(string);
    }

    public void setEMLocalSubtype(String string) {
        if (this.checkEmLocalSubtypeState(string)) {
            this.emLocalSubtype = string;
            this.fireDataFieldChange();
        }
    }

    public String getEMLocalSubtype() {
        return this.emLocalSubtype;
    }

    public int getEMUniformSize() {
        return this.emUniformSize;
    }

    public void setEMUniformSize(int n) {
        this.emUniformSize = n;
    }

    public static List getLoggingValues() {
        return loggingList;
    }

    public static List getStatusValues() {
        return statusList;
    }

    public static List getContentsValues() {
        return contentsList;
    }

    public static List getExtendManageValues() {
        return extendManageList;
    }

    public static List getEmLocalSubtypeValues() {
        return emLocalSubtypeList;
    }

    public boolean willAcceptTable() {
        return true;
    }

    public void removeTable(TableProxy tableProxy) {
        this.tableMap.remove(tableProxy.getObjectID());
        this.tables.remove(tableProxy);
        StorageEvent storageEvent = StorageEvent.TS_TABLE_REMOVED;
        storageEvent.setAffected(tableProxy);
        this.fireChange(storageEvent);
    }

    public void addTable(TableProxy tableProxy) {
        if (this.willAcceptTable()) {
            this.tableMap.put(tableProxy.getObjectID(), tableProxy);
            this.tables.add(tableProxy);
            StorageEvent storageEvent = StorageEvent.TS_TABLE_ADDED;
            storageEvent.setAffected(tableProxy);
            this.fireChange(storageEvent);
        }
    }

    public String getDefaultForTable() {
        return this.defaultForTable;
    }

    public void setDefaultForTable(String string) {
        this.defaultForTable = string;
    }

    public boolean isDefaultFor(TableProxy tableProxy) {
        return this.tables.size() == 1 && this.tables.contains(tableProxy) && this.getDefaultForTable() != null && this.getDefaultForTable().equals(tableProxy.getObjectID());
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.tabcoll;
            }
            case 1: {
                return this.dfiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.tabcoll) {
            return 0;
        }
        if (modelObject == this.dfiles) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.tabcoll) {
            return 0;
        }
        if (object == this.dfiles) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void registerToTableProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            TableProxy tableProxy = (TableProxy)iterator.next();
            tableProxy.addObjectListener(this);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TableProxy) {
                TableProxyOracle tableProxyOracle = (TableProxyOracle)modelObjectSetEvent.getAffected();
                tableProxyOracle.addObjectListener(this);
                if (this == tableProxyOracle.getTableSpace()) {
                    StorageObjectPlaceHolder storageObjectPlaceHolder = new StorageObjectPlaceHolder(tableProxyOracle);
                    storageObjectPlaceHolder.setParent(this.tabcoll);
                    this.tabcoll.add(storageObjectPlaceHolder);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof TableProxy) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)modelObjectSetEvent.getAffected();
            tableProxyOracle.removeObjectListener(this);
            this.tabcoll.removePlaceHolderFor(tableProxyOracle);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileOracle) {
                DataFileOracle dataFileOracle = (DataFileOracle)modelObjectSetEvent.getAffected();
                dataFileOracle.addObjectListener(this);
                if (dataFileOracle.getTableSpace() != null && dataFileOracle.getTableSpace() == this) {
                    dataFileOracle.setParent(this.dfiles);
                    this.dfiles.add(dataFileOracle);
                } else {
                    this.dfiles.remove(dataFileOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof DataFileOracle) {
            DataFileOracle dataFileOracle = (DataFileOracle)modelObjectSetEvent.getAffected();
            this.dfiles.remove(dataFileOracle);
            dataFileOracle.removeObjectListener(this);
        }
    }

    public StorageObjectCollection getTabcoll() {
        return this.tabcoll;
    }

    public StorageObjectCollection getDfiles() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }

    public List getDataFiles() {
        ArrayList<DataFileOracle> arrayList = new ArrayList<DataFileOracle>();
        DataFileSetOracle dataFileSetOracle = ((StorageDesignOracle)this.getStorageDesign()).getDataFileSet();
        Iterator iterator = dataFileSetOracle.iterator();
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            TableSpaceOracle tableSpaceOracle = dataFileOracle.getTableSpace();
            if (tableSpaceOracle == null || tableSpaceOracle != this) continue;
            arrayList.add(dataFileOracle);
        }
        return arrayList;
    }

    @Override
    public void clearNoneMergableStructure() {
        this.dfiles.removeAll();
    }
}

