/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.TableCheckConstraintPropertyDialogOracle;

public abstract class TableCheckConstraintOracle
extends AbstractStorageObjectOracle {
    private TableProxyOracle table;
    private String deferrable = "NO";
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String enable = "YES";
    private String validate = "YES";
    private TableProxyOracle exceptionsTable = null;

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableCheckConstraintPropertyDialogOracle tableCheckConstraintPropertyDialogOracle = new TableCheckConstraintPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableCheckConstraintPropertyDialogOracle.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return "TableCheckConstraint";
    }

    @Override
    public String getIDPrefix() {
        return "TCC";
    }

    @Override
    public String getName() {
        Object object;
        if (this.isNameChanged() && !"".equals(object = super.getName())) {
            return object;
        }
        object = this.getTableConstraint();
        if (object != null) {
            return ((DesignObject)object).getName();
        }
        return "";
    }

    @Override
    public boolean setName(String string) {
        TableLevelConstraint tableLevelConstraint;
        boolean bl = true;
        if (!this.getName().equals(string)) {
            bl = super.setName(string);
            if (bl) {
                this.setNameChanged(true);
                this.setDirty(true);
            }
            this.fireDataFieldChange();
        }
        if (this.isNameChanged() && (tableLevelConstraint = this.getTableConstraint()) != null && this.getName().equals(tableLevelConstraint.getName())) {
            this.setNameChanged(false);
            this.setDirty(true);
        }
        return bl;
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    public TableLevelConstraint getTableConstraint() {
        if (this.table != null) {
            for (TableLevelConstraint tableLevelConstraint : ((Table)this.table.getObject()).getCheckConstraints()) {
                if (!tableLevelConstraint.getObjectID().equals(this.getObjectID())) continue;
                return tableLevelConstraint;
            }
        }
        return null;
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle tableProxyOracle) {
        this.table = tableProxyOracle;
        if (tableProxyOracle != null) {
            tableProxyOracle.addObject(this);
        }
        this.setPAC_Element(tableProxyOracle);
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String string) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(TableCheckConstraintOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(string);
    }

    public void setInitially(String string) {
        if (this.checkInitially(string)) {
            this.initially = string;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.deferrable = string;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.enable = string;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.validate = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle tableProxyOracle) {
        this.exceptionsTable = tableProxyOracle;
        this.fireDataFieldChange();
    }

    public String getConstraintID() {
        return this.getObjectID();
    }

    public void setConstraintID(String string) {
        this.setObjectID(string);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16);
    }
}

