/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class SynonymOracle
extends AbstractStorageObjectOracle {
    private UserOracle user = null;
    private String isPublic = "NO";
    private UserOracle objectUser = null;
    private String object = "";
    private String dbLink = "";
    public static final String TYPE_NAME = "Synonym";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setPublic(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.isPublic = string;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public UserOracle getObjectUser() {
        return this.objectUser;
    }

    public void setObjectUser(UserOracle userOracle) {
        this.objectUser = userOracle;
        this.fireDataFieldChange();
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String string) {
        this.object = string;
    }

    public String getDBLink() {
        return this.dbLink;
    }

    public void setDBLink(String string) {
        this.dbLink = string;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null && "NO".equalsIgnoreCase(this.isPublic)) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SYNONYM_ICON", 16);
    }
}

