/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class SequenceOracle
extends AbstractStorageObjectOracle
implements PropertiesPropagator {
    private UserOracle user = null;
    private String startWith = "";
    private String incrementBy = "";
    private String maxValue = "";
    private String minValue = "";
    private String cycle = "NO";
    private String noCache = "NO";
    private String cache = "";
    private String order = "NO";
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "Sequence";

    public SequenceOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getStartWith() {
        return this.startWith;
    }

    public void setStartWith(String string) {
        this.startWith = string;
        this.fireDataFieldChange();
    }

    public String getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(String string) {
        this.incrementBy = string;
        this.fireDataFieldChange();
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String string) {
        this.maxValue = string;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String string) {
        this.minValue = string;
        this.fireDataFieldChange();
    }

    public void setCycle(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.cycle = string;
            this.fireDataFieldChange();
        }
    }

    public String getCycle() {
        return this.cycle;
    }

    public String getNoCache() {
        return this.noCache;
    }

    public void setNoCache(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.noCache = string;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String string) {
        this.cache = string;
        this.fireDataFieldChange();
    }

    public void setOrder(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.order = string;
            this.fireDataFieldChange();
        }
    }

    public String getOrder() {
        return this.order;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("User", this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Start With", this, "getStartWith", "setStartWith", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Increment By", this, "getIncrementBy", "setIncrementBy", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Max Value", this, "getMaxValue", "setMaxValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Min Value", this, "getMinValue", "setMinValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cycle", this, "getCycle", "setCycle", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Disable Cache", this, "getNoCache", "setNoCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Order", this, "getOrder", "setOrder", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEQUENCE_ICON", 16);
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        SequenceOraclev10g sequenceOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)storageDesign).getSequenceSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                sequenceOraclev10g = (SequenceOraclev10g)storageObject;
            }
        } else {
            sequenceOraclev10g = (SequenceOraclev10g)((StorageDesignOracle)storageDesign).getSequenceSet().createSequence();
        }
        if (sequenceOraclev10g != null) {
            sequenceOraclev10g.setName(this.getName());
            if (this.getUser() != null) {
                UserOracle userOracle = (UserOracle)((StorageDesignOracle)storageDesign).getUserSet().getByName(this.getUser().getName());
                if (userOracle == null) {
                    UserOracle userOracle2 = ((StorageDesignOracle)storageDesign).getUserSet().createUser();
                    userOracle2.setName(this.getUser().getName());
                    userOracle2.setRawObject(true);
                    sequenceOraclev10g.setUser(userOracle2);
                } else {
                    sequenceOraclev10g.setUser(userOracle);
                }
            }
            sequenceOraclev10g.setStartWith(this.getStartWith());
            sequenceOraclev10g.setIncrementBy(this.getIncrementBy());
            sequenceOraclev10g.setMaxValue(this.getMaxValue());
            sequenceOraclev10g.setMinValue(this.getMinValue());
            sequenceOraclev10g.setCycle(this.getCycle());
            sequenceOraclev10g.setNoCache(this.getNoCache());
            sequenceOraclev10g.setCache(this.getCache());
            sequenceOraclev10g.setOrder(this.getOrder());
            sequenceOraclev10g.setComment(this.getComment());
            sequenceOraclev10g.setRawObject(false);
        }
    }

    public void copy(SequenceOracle sequenceOracle) {
        if (sequenceOracle != null) {
            StorageDesign storageDesign = sequenceOracle.getStorageDesign();
            sequenceOracle.setName(this.getName());
            if (this.getUser() != null) {
                UserOracle userOracle = (UserOracle)((StorageDesignOracle)storageDesign).getUserSet().getByName(this.getUser().getName());
                if (userOracle == null) {
                    UserOracle userOracle2 = ((StorageDesignOracle)storageDesign).getUserSet().createUser();
                    userOracle2.setName(this.getUser().getName());
                    userOracle2.setRawObject(true);
                    sequenceOracle.setUser(userOracle2);
                } else {
                    sequenceOracle.setUser(userOracle);
                }
            }
            sequenceOracle.setStartWith(this.getStartWith());
            sequenceOracle.setIncrementBy(this.getIncrementBy());
            sequenceOracle.setMaxValue(this.getMaxValue());
            sequenceOracle.setMinValue(this.getMinValue());
            sequenceOracle.setCycle(this.getCycle());
            sequenceOracle.setNoCache(this.getNoCache());
            sequenceOracle.setCache(this.getCache());
            sequenceOracle.setOrder(this.getOrder());
            sequenceOracle.setComment(this.getComment());
            sequenceOracle.setRawObject(false);
        }
    }
}

