/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.RollbackSegmentPropertyDialogOracle;

public class RollbackSegmentOracle
extends AbstractStorageObjectOracle {
    private String initialSizeUnit = "";
    private String nextSizeUnit = "";
    private int scInitialExtent = 0;
    private int scNextExtent = 0;
    private int scMinExtents = 1;
    private String scMaxExtents = "UNLIMITED";
    private String tablespaces = "";
    private InlineList tablespaceSet = null;
    private String pub = "NO";
    private String scOptimal = "";
    public static final String TYPE_NAME = "RSeg";
    public static final String OLD_TYPE_NAME = "RollbackSegment";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RollbackSegmentPropertyDialogOracle rollbackSegmentPropertyDialogOracle = new RollbackSegmentPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            rollbackSegmentPropertyDialogOracle.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "RollbackSeg";
    }

    public static String[] getSizeUnitChoices() {
        return ConstantsOracle.UNITS_CHOICES;
    }

    public String getInitialSizeUnit() {
        return this.initialSizeUnit;
    }

    public void setInitialSizeUnit(String string) {
        if (ConstantsOracle.checkUnit(string)) {
            this.initialSizeUnit = string;
        }
    }

    public String getNextSizeUnit() {
        return this.nextSizeUnit;
    }

    public void setNextSizeUnit(String string) {
        if (ConstantsOracle.checkUnit(string)) {
            this.nextSizeUnit = string;
        }
    }

    public int getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(int n) {
        this.scInitialExtent = n;
    }

    public int getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(int n) {
        this.scNextExtent = n;
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int n) {
        if (n >= 1) {
            this.scMinExtents = n;
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String string) {
        try {
            this.scMaxExtents = Integer.parseInt(string) > 0 ? string : "UNLIMITED";
        }
        catch (NumberFormatException numberFormatException) {
            this.scMaxExtents = "UNLIMITED";
        }
    }

    public String convertTSNamesToIDs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getObjectID());
        }
        return stringBuffer.toString();
    }

    private void addTablespace(String string) {
        if (!this.getTablespaceSet().contains(string)) {
            this.getTablespaceSet().add(string);
        }
    }

    public void recreateTablespaceSet(String string) {
        this.getTablespaceSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getTablespaceSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setTablespaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateTablespaceSet(string);
        } else {
            this.addTablespace(string);
        }
        this.tablespaces = this.getTablespaceSet().toString();
        this.fireDataFieldChange();
    }

    public String getTablespaces() {
        return this.tablespaces;
    }

    public InlineList getTablespaceSet() {
        if (this.tablespaceSet == null) {
            this.tablespaceSet = new InlineList();
        }
        return this.tablespaceSet;
    }

    public void clear() {
        this.getTablespaceSet().removeAllElements();
        this.tablespaces = "";
    }

    public String getPub() {
        return this.pub;
    }

    public void setPub(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.pub = string;
            this.fireDataFieldChange();
        }
    }

    public String getScOptimal() {
        return this.scOptimal;
    }

    public void setScOptimal(String string) {
        this.scOptimal = string;
        this.fireDataFieldChange();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEGMENT_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

