/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.string.Crypt;

public abstract class RoleOracle
extends AbstractStorageObjectOracle {
    private static Crypt crypt = new Crypt();
    private String identified = "NO";
    private String password = "";
    protected InlineList roleSet = null;
    protected InlineList rolesWithAdminOptionSet = null;
    protected InlineList systemPrivilegesSet = null;
    protected InlineList privilegesWithAdminOptionSet = null;
    protected String roles = "";
    protected String rolesWithAdminOption = "";
    protected String systemPrivileges = "";
    protected String privilegesWithAdminOption = "";
    protected String isPublic = "NO";
    protected String adminOption = "NO";
    public static final String TYPE_NAME = "Role";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setIdentified(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.identified = string;
            this.fireDataFieldChange();
        }
    }

    public String getIdentified() {
        return this.identified;
    }

    public abstract void setAuthType(String var1);

    public abstract String getAuthType();

    public String getPassword() {
        return this.password;
    }

    public String decodePassword() {
        String string = this.getDesign().getLoadedVersion() < 3.3f ? this.password : crypt.decrypt(this.password);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void encodePassword(String string) {
        this.password = crypt.encrypt(string);
    }

    public void setAdminOption(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.adminOption = string;
            this.fireDataFieldChange();
        }
    }

    public String getAdminOption() {
        return this.adminOption;
    }

    public void setRoles(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRoleSet(string);
        } else {
            this.addRole(string);
        }
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public String getRoles() {
        return this.roles;
    }

    private void addRole(String string) {
        if (!this.getRolesSet().contains(string)) {
            this.getRolesSet().add(string);
        }
    }

    public void recreateRoleSet(String string) {
        this.getRolesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getRolesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getRolesSet() {
        if (this.roleSet == null) {
            this.roleSet = new InlineList();
        }
        return this.roleSet;
    }

    public void setRolesWithAdminOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRolesWithAdminOptionSet(string);
        } else {
            this.addRoleWithAdminOption(string);
        }
        this.rolesWithAdminOption = this.getRolesWithAdminOptionSet().toString();
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getRolesWithAdminOptionSet() {
        if (this.rolesWithAdminOptionSet == null) {
            this.rolesWithAdminOptionSet = new InlineList();
        }
        return this.rolesWithAdminOptionSet;
    }

    protected void recreateRolesWithAdminOptionSet(String string) {
        this.getRolesWithAdminOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getRolesWithAdminOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void addRoleWithAdminOption(String string) {
        if (!this.getRolesWithAdminOptionSet().contains(string)) {
            this.getRolesWithAdminOptionSet().add(string);
        }
    }

    public String getRolesWithAdminOption() {
        return this.rolesWithAdminOption;
    }

    public void setPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else {
            this.addPrivilege(string);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void addPrivilege(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
        }
    }

    public void setPrivilegesWithAdminOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithAdminOptionSet(string);
        } else {
            this.addPrivilegeWithAdminOption(string);
        }
        this.privilegesWithAdminOption = this.getPrivilegesWithAdminOptionSet().toString();
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesWithAdminOptionSet() {
        if (this.privilegesWithAdminOptionSet == null) {
            this.privilegesWithAdminOptionSet = new InlineList();
        }
        return this.privilegesWithAdminOptionSet;
    }

    public String getPrivilegesWithAdminOption() {
        return this.privilegesWithAdminOption;
    }

    protected void recreatePrivilegesWithAdminOptionSet(String string) {
        this.getPrivilegesWithAdminOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesWithAdminOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void addPrivilegeWithAdminOption(String string) {
        if (!this.getPrivilegesWithAdminOptionSet().contains(string)) {
            this.getPrivilegesWithAdminOptionSet().add(string);
        }
    }

    public void setPublic(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.isPublic = string;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithAdminOptionSet().removeAllElements();
        this.getRolesSet().removeAllElements();
        this.getRolesWithAdminOptionSet().removeAllElements();
        this.roles = "";
        this.rolesWithAdminOption = "";
        this.systemPrivileges = "";
        this.privilegesWithAdminOption = "";
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16);
    }

    public String getRolesWithAdminOptionNames() {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle roleSetOracle = storageDesignOracle.getRoleSet();
        String string = "";
        boolean bl = true;
        Object[] objectArray = this.getRolesWithAdminOptionSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            RoleOracle roleOracle = (RoleOracle)roleSetOracle.getById(string2);
            if (roleOracle == null) continue;
            if (!bl) {
                string = string + "," + roleOracle.getName();
                continue;
            }
            string = roleOracle.getName();
            bl = false;
        }
        return string;
    }

    public String getRolesNames() {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle roleSetOracle = storageDesignOracle.getRoleSet();
        String string = "";
        boolean bl = true;
        Object[] objectArray = this.getRolesSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            RoleOracle roleOracle = (RoleOracle)roleSetOracle.getById(string2);
            if (roleOracle == null) continue;
            if (!bl) {
                string = string + "," + roleOracle.getName();
                continue;
            }
            string = roleOracle.getName();
            bl = false;
        }
        return string;
    }

    public List getPermissions() {
        ArrayList<PermissionsOracle> arrayList = new ArrayList<PermissionsOracle>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getRole() != this) continue;
            arrayList.add(permissionsOracle);
        }
        return arrayList;
    }

    public PermissionsOracle createPermission() {
        PermissionsOracle permissionsOracle = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permissionsOracle.setRole(this);
        return permissionsOracle;
    }

    @Override
    public void remove() {
        this.removePermissions();
        super.remove();
    }

    @Override
    public void remove(boolean bl) {
        this.removePermissions();
        super.remove(bl);
    }

    private void removePermissions() {
        for (PermissionsOracle permissionsOracle : this.getPermissions()) {
            permissionsOracle.clear();
            permissionsOracle.remove();
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }
}

