/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.RedoLogGroupPropertyDialogOraclev9i;

public abstract class RedoLogGroupOracle
extends AbstractStorageObjectOracle {
    private String fileName = "";
    private int size = 0;
    private String reuse = "YES";
    private String measureUnit = ConstantsOracle.UNITS_CHOICES[1];
    private DataBaseOracle dataBase = null;
    public static final String TYPE_NAME = "RLGrp";
    public static final String OLD_TYPE_NAME = "RedoLogGroup";

    @Override
    public String getIDPrefix() {
        return "RLG";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.fireDataFieldChange();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        this.fireDataFieldChange();
    }

    public void setReuse(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.reuse = string;
            this.fireDataFieldChange();
        }
    }

    public String getReuse() {
        return this.reuse;
    }

    public void setMeasureUnit(String string) {
        if (ConstantsOracle.checkUnit(string)) {
            this.measureUnit = string;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public static List getMeasureUnitValues() {
        return Arrays.asList(ConstantsOracle.UNITS_CHOICES);
    }

    public void setDataBase(DataBaseOracle dataBaseOracle) {
        if (this.dataBase != dataBaseOracle) {
            this.dataBase = dataBaseOracle;
            this.setPAC_Element(dataBaseOracle);
            this.fireDataFieldChange();
        }
    }

    public DataBaseOracle getDataBase() {
        return this.dataBase;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RedoLogGroupPropertyDialogOraclev9i redoLogGroupPropertyDialogOraclev9i = new RedoLogGroupPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            redoLogGroupPropertyDialogOraclev9i.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

