/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class PermissionsOracle
extends AbstractStorageObjectOracle {
    private static final String[] TABLE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "REFERENCES", "SELECT", "UPDATE"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE"};
    private static final String[] SEQ_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT"};
    private static final String[] SNAPSHOT_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE"};
    private static final String[] PROCEDURE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE"};
    private static final String[] COLUMNS_PRIVILEGES = new String[]{"ALL PRIVILEGES", "INSERT", "UPDATE", "REFERENCES"};
    private static final String[] PACKAGE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] DIRECTORY_PRIVILEGES = new String[]{"ALL PRIVILEGES", "READ", "WRITE"};
    private static final String[] ST_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] CT_PRIVILEGES = new String[]{"ALL PRIVILEGES", "EXECUTE", "DEBUG"};
    private static final String[] EXT_TAB_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "SELECT"};
    protected PermissionsSet privilegesSet = null;
    protected PermissionsSet privilegesWithGrantOptionSet = null;
    protected PermissionsSet privilegesWithHierarchyOptionSet = null;
    protected TableProxyOracle table = null;
    protected TableViewProxyOracle view = null;
    protected SequenceOracle sequence = null;
    protected SnapshotOracle snapshot = null;
    protected StoredProcedureOracle proc = null;
    protected PackageOracle packageOracle = null;
    protected FunctionOracle functionOracle = null;
    protected DirectoryOracle directoryOracle = null;
    protected StructuredTypeProxyOracle structuredTypeOracle = null;
    protected CollectionTypeProxyOracle collectionTypeOracle = null;
    protected ExternalTableOracle externalTableOracle = null;
    protected TableProxyOracle columnsTable = null;
    protected String privileges = "";
    protected String privilegesWithGrantOption = "";
    protected String privilegesWithHierarchyOption = "";
    protected String columnList = "";
    protected String columnWithGrantOptionList = "";
    protected String isPublic = "NO";
    protected UserOracle user;
    protected RoleOracle role;
    public static final String TYPE_NAME = "Permissions";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setTable(TableProxyOracle tableProxyOracle) {
        this.table = tableProxyOracle;
        if (tableProxyOracle != null) {
            this.view = null;
            this.sequence = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setView(TableViewProxyOracle tableViewProxyOracle) {
        this.view = tableViewProxyOracle;
        if (tableViewProxyOracle != null) {
            this.table = null;
            this.sequence = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyOracle getView() {
        return this.view;
    }

    public StoredProcedureOracle getProc() {
        return this.proc;
    }

    public void setProc(StoredProcedureOracle storedProcedureOracle) {
        this.proc = storedProcedureOracle;
        if (storedProcedureOracle != null) {
            this.table = null;
            this.view = null;
            this.sequence = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public PackageOracle getPackage() {
        return this.packageOracle;
    }

    public void setPackage(PackageOracle packageOracle) {
        this.packageOracle = packageOracle;
        this.fireDataFieldChange();
    }

    public FunctionOracle getFunctionOracle() {
        return this.functionOracle;
    }

    public void setFunctionOracle(FunctionOracle functionOracle) {
        this.functionOracle = functionOracle;
        this.fireDataFieldChange();
    }

    public DirectoryOracle getDirectoryOracle() {
        return this.directoryOracle;
    }

    public void setDirectoryOracle(DirectoryOracle directoryOracle) {
        this.directoryOracle = directoryOracle;
        this.fireDataFieldChange();
    }

    public StructuredTypeProxyOracle getStructuredTypeOracle() {
        return this.structuredTypeOracle;
    }

    public void setStructuredTypeOracle(StructuredTypeProxyOracle structuredTypeProxyOracle) {
        this.structuredTypeOracle = structuredTypeProxyOracle;
        this.fireDataFieldChange();
    }

    public CollectionTypeProxyOracle getCollectionTypeOracle() {
        return this.collectionTypeOracle;
    }

    public void setCollectionTypeOracle(CollectionTypeProxyOracle collectionTypeProxyOracle) {
        this.collectionTypeOracle = collectionTypeProxyOracle;
        this.fireDataFieldChange();
    }

    public ExternalTableOracle getExternalTableOracle() {
        return this.externalTableOracle;
    }

    public void setExternalTableOracle(ExternalTableOracle externalTableOracle) {
        this.externalTableOracle = externalTableOracle;
        this.fireDataFieldChange();
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshotOracle) {
        this.snapshot = snapshotOracle;
        if (snapshotOracle != null) {
            this.table = null;
            this.view = null;
            this.sequence = null;
            this.proc = null;
        }
        this.fireDataFieldChange();
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public String getPrivilegesWithGrantOption() {
        return this.privilegesWithGrantOption;
    }

    public String getPrivilegesWithHierarchyOption() {
        return this.privilegesWithHierarchyOption;
    }

    public String getColumnList() {
        return this.columnList;
    }

    public String getColumnWithGrantOptionList() {
        return this.columnWithGrantOptionList;
    }

    public void setSequence(SequenceOracle sequenceOracle) {
        this.sequence = sequenceOracle;
        if (sequenceOracle != null) {
            this.view = null;
            this.table = null;
            this.proc = null;
            this.snapshot = null;
        }
        this.fireDataFieldChange();
    }

    public SequenceOracle getSequence() {
        return this.sequence;
    }

    protected void addPrivilege(String string) {
        if (!this.getPrivilegesSet().contains(string)) {
            this.getPrivilegesSet().add(string);
            this.getPrivilegesWithGrantOptionSet().remove(string);
        }
    }

    protected void addPrivilegeWithGrantOption(String string) {
        if (!this.getPrivilegesWithGrantOptionSet().contains(string)) {
            this.getPrivilegesWithGrantOptionSet().add(string);
            this.getPrivilegesSet().remove(string);
        }
    }

    protected void addPrivilegeWithHierarchyOption(String string) {
        if (!this.getPrivilegesWithHierarchyOptionSet().contains(string)) {
            this.getPrivilegesWithHierarchyOptionSet().add(string);
            this.getPrivilegesSet().remove(string);
        }
    }

    public void addColumn(String string) {
        if (!this.columnList.trim().equalsIgnoreCase("")) {
            this.columnList = this.columnList + "|";
        }
        this.columnList = this.columnList + string;
    }

    public void addColumnWithGrantOption(String string) {
        if (!this.columnWithGrantOptionList.trim().equalsIgnoreCase("")) {
            this.columnWithGrantOptionList = this.columnWithGrantOptionList + "|";
        }
        this.columnWithGrantOptionList = this.columnWithGrantOptionList + string;
    }

    public void setPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesSet(string);
        } else {
            this.addPrivilege(string);
        }
        this.privileges = this.getPrivilegesSet().toString();
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.privilegesWithHierarchyOption = this.getPrivilegesWithHierarchyOptionSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithGrantOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithGrantOptionSet(string);
        } else {
            this.addPrivilegeWithGrantOption(string);
        }
        this.privilegesWithGrantOption = this.getPrivilegesWithGrantOptionSet().toString();
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public void setPrivilegesWithHierarchyOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithHierarchyOptionSet(string);
        } else {
            this.addPrivilegeWithHierarchyOption(string);
        }
        this.privilegesWithHierarchyOption = this.getPrivilegesWithHierarchyOptionSet().toString();
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    protected void recreatePrivilegesSet(String string) {
        this.getPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void recreatePrivilegesWithGrantOptionSet(String string) {
        this.getPrivilegesWithGrantOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesWithGrantOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    protected void recreatePrivilegesWithHierarchyOptionSet(String string) {
        this.getPrivilegesWithHierarchyOptionSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getPrivilegesWithHierarchyOptionSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void recreateColumnList(String string) {
        this.columnList = string;
    }

    private void recreateColumnWithGranOptionList(String string) {
        this.columnWithGrantOptionList = string;
    }

    public void setColumnList(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnList(string);
        } else {
            this.addColumn(string);
        }
        this.fireDataFieldChange();
    }

    public void setColumnListWithGrantOption(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnWithGranOptionList(string);
        } else {
            this.addColumnWithGrantOption(string);
        }
        this.fireDataFieldChange();
    }

    public static String[] getTablePrivilegesValues() {
        return TABLE_PRIVILEGES;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    public static String[] getSeqPrivilegesValues() {
        return SEQ_PRIVILEGES;
    }

    public static String[] getSnapshotPrivilegesValues() {
        return SNAPSHOT_PRIVILEGES;
    }

    public static String[] getProcedurePrivilegesValues() {
        return PROCEDURE_PRIVILEGES;
    }

    public static String[] getPackagePrivilegesValues() {
        return PACKAGE_PRIVILEGES;
    }

    public static String[] getDirectoryPrivilegesValues() {
        return DIRECTORY_PRIVILEGES;
    }

    public static String[] getStructuredTypePrivilegesValues() {
        return ST_PRIVILEGES;
    }

    public static String[] getCollectionTypePrivilegesValues() {
        return CT_PRIVILEGES;
    }

    public static String[] getExtTablesPrivilegesValues() {
        return EXT_TAB_PRIVILEGES;
    }

    public void setPublic(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.isPublic = string;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public PermissionsSet getPrivilegesSet() {
        if (this.privilegesSet == null) {
            this.privilegesSet = new PermissionsSet();
        }
        return this.privilegesSet;
    }

    public PermissionsSet getPrivilegesWithGrantOptionSet() {
        if (this.privilegesWithGrantOptionSet == null) {
            this.privilegesWithGrantOptionSet = new PermissionsSet();
        }
        return this.privilegesWithGrantOptionSet;
    }

    public PermissionsSet getPrivilegesWithHierarchyOptionSet() {
        if (this.privilegesWithHierarchyOptionSet == null) {
            this.privilegesWithHierarchyOptionSet = new PermissionsSet();
        }
        return this.privilegesWithHierarchyOptionSet;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithGrantOptionSet().removeAllElements();
        this.getPrivilegesWithHierarchyOptionSet().removeAllElements();
        this.privileges = "";
        this.privilegesWithGrantOption = "";
        this.privilegesWithHierarchyOption = "";
    }

    public void clearColPermissions() {
        this.columnList = "";
        this.columnWithGrantOptionList = "";
    }

    public RoleOracle getRole() {
        return this.role;
    }

    public void setRole(RoleOracle roleOracle) {
        if (this.role != roleOracle) {
            this.role = roleOracle;
            if (roleOracle != null) {
                this.setPAC_Element(roleOracle);
            }
            this.fireDataFieldChange();
        }
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        if (this.user != userOracle) {
            this.user = userOracle;
            if (userOracle != null) {
                this.setPAC_Element(userOracle);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public static String[] getColumnPermissionsValues() {
        return COLUMNS_PRIVILEGES;
    }

    public String getPrivs(ColumnProxyOracle columnProxyOracle) {
        return this.getPrivs(columnProxyOracle.getName());
    }

    public String getPrivs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String[] stringArray = string3.split(",");
            if (!string.equalsIgnoreCase(stringArray[0])) continue;
            if (string2.length() > 0) {
                string2 = string2 + "," + stringArray[1];
                continue;
            }
            string2 = stringArray[1];
        }
        return string2;
    }

    public String getPrivsWithGrantOption(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String[] stringArray = string3.split(",");
            if (!string.equalsIgnoreCase(stringArray[0])) continue;
            if (string2.length() > 0) {
                string2 = string2 + "," + stringArray[1];
                continue;
            }
            string2 = stringArray[1];
        }
        return string2;
    }

    public String getPrivsWithGrantOption(ColumnProxyOracle columnProxyOracle) {
        return this.getPrivsWithGrantOption(columnProxyOracle.getName());
    }

    public ArrayList getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnList(), "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf(44) > -1) {
                string = string.substring(0, string.indexOf(44));
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ArrayList getColumnsWithGrantOption() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getColumnWithGrantOptionList(), "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf(44) > -1) {
                string = string.substring(0, string.indexOf(44));
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean hasColPrivilege(String string) {
        ArrayList arrayList = this.getColumns();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.getPrivs((String)arrayList.get(i)).indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public TableProxyOracle getColumnsTable() {
        return this.columnsTable;
    }

    public void setColumnsTable(TableProxyOracle tableProxyOracle) {
        this.columnsTable = tableProxyOracle;
        this.table = null;
        this.view = null;
        this.sequence = null;
        this.proc = null;
        this.snapshot = null;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        Object object;
        if (string2 == null) {
            return null;
        }
        Object object2 = this.getStorageDesign().getStorageObject(string2);
        if (object2 == null) {
            ModelIDObject modelIDObject;
            object = null;
            Map map = this.getStorageDesign().getCorrespondenceMap();
            if (map != null && (modelIDObject = (ModelIDObject)map.get(string2)) != null) {
                object = modelIDObject.getObjectID();
                object2 = this.getStorageDesign().getStorageObject((String)object);
            }
        }
        if (object2 != null) {
            if ("package".equals(string) && object2 instanceof PackageBodyOracle && string2.equals(((ModelIDObject)(object = ((PackageBodyOracle)object2).getPackageOracle())).getObjectID())) {
                object2 = object;
            }
            return object2;
        }
        return super.translateIdToObject(string, string2);
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class PermissionsSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

