/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public abstract class PKProxySetOracle
extends IndexProxySet {
    public PKProxySetOracle(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        Index index;
        if (modelObjectSetEvent.isAdded()) {
            Index index2 = (Index)modelObjectSetEvent.getAffected();
            if (index2.isPK()) {
                this.add(index2);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved() && this.containsId((index = (Index)modelObjectSetEvent.getAffected()).getObjectID())) {
            this.remove((Index)modelObjectSetEvent.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (!index.isPK()) continue;
            this.add(index);
        }
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && ((KeyObject)designObject).isPK()) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            Iterator iterator = this.iterator();
            IndexProxy indexProxy = null;
            while (iterator.hasNext() && ((indexProxy = (IndexProxy)iterator.next()).equals(relationalObjectProxy) || indexProxy.getTable() == null || !indexProxy.getTable().equals(((IndexProxy)relationalObjectProxy).getTable()))) {
                indexProxy = null;
            }
            try {
                if (indexProxy != null) {
                    this.remove(indexProxy);
                }
                this.add(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in PKProxySetOracle.add");
            }
        }
    }

    public boolean hasDublicateNames() {
        for (int i = 0; i < this.elements.size(); ++i) {
            PKProxyOracle pKProxyOracle = (PKProxyOracle)this.elements.get(i);
            for (int j = i + 1; j < this.elements.size(); ++j) {
                PKProxyOracle pKProxyOracle2 = (PKProxyOracle)this.elements.get(j);
                if (!pKProxyOracle.getName().equalsIgnoreCase(pKProxyOracle2.getName()) || ((TableProxyOracle)pKProxyOracle.getTableProxy()).getUser() != ((TableProxyOracle)pKProxyOracle2.getTableProxy()).getUser()) continue;
                return true;
            }
        }
        return false;
    }
}

