/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.NotNullConstraintPropertyDialogOraclev9i;

public class NotNullConstraintOracle
extends AbstractStorageObjectOracle {
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set initiallySet = null;
    private ColumnProxyOracle column = null;
    private String initially = INITIALLY[0];
    private String deferrable = "NO";
    private String enable = "YES";
    private String validate = "YES";
    private String rely = "NO";
    private TableProxyOracle exceptionsTable = null;
    public static final String TYPE_NAME = "NotNullConstraint";

    public void setColumn(ColumnProxyOracle columnProxyOracle) {
        NotNullConstraintSetOracle notNullConstraintSetOracle = this.getStorageDesignOracle().getNotNullConstraintSet();
        NotNullConstraintOracle notNullConstraintOracle = notNullConstraintSetOracle.getNotNullConstraint(columnProxyOracle);
        if (notNullConstraintOracle != null && notNullConstraintOracle != this) {
            notNullConstraintSetOracle.remove(notNullConstraintOracle);
        }
        this.column = columnProxyOracle;
        this.resetID(columnProxyOracle);
    }

    @Override
    public String getIDPrefix() {
        return "NNC";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public ColumnProxyOracle getColumn() {
        return this.column;
    }

    public TableProxyOracle getTable() {
        if (this.column != null) {
            return this.column.getTableProxy();
        }
        return null;
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String string) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(NotNullConstraintOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(string);
    }

    public void setInitially(String string) {
        if (this.checkInitially(string)) {
            this.initially = string;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.deferrable = string;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setRely(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.rely = string;
            this.fireDataFieldChange();
        }
    }

    public String getRely() {
        return this.rely;
    }

    public void setEnable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.enable = string;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.validate = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle tableProxyOracle) {
        if (this.exceptionsTable != tableProxyOracle) {
            this.exceptionsTable = tableProxyOracle;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            NotNullConstraintPropertyDialogOraclev9i notNullConstraintPropertyDialogOraclev9i = new NotNullConstraintPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            notNullConstraintPropertyDialogOraclev9i.show();
        }
    }

    private void resetID(ColumnProxyOracle columnProxyOracle) {
        this.createGlobalID();
    }
}

