/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.MethodPropertyDialogOraclev9i;

public class MethodProxyOracle
extends MethodProxy {
    private String isStatic = "NO";
    private String implLanguage = "PL/SQL";
    private String PLSQLBody = "";
    private String javaName = "";
    private String cName = "";
    private String cLibrary = "";
    private String withContext = "NO";
    private String cPartemeters = "";
    private String pragmaClause = "";
    public static final String[] METHOD_TYPES = new String[]{"Function", "Procedure"};
    public static final String[] IMPL_LANGUAGES = new String[]{"PL/SQL", "Java", "C"};
    private static Set languagesSet = null;
    public static final String PL_SQL = "PL/SQL";
    public static final String JAVA = "Java";
    public static final String C = "C";

    public MethodProxyOracle(Method method, StorageDesign storageDesign) {
        super(method, storageDesign);
    }

    public MethodProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public String getCLibrary() {
        return this.cLibrary;
    }

    public void setCLibrary(String string) {
        this.cLibrary = string;
        this.fireDataFieldChange();
    }

    public String getCName() {
        return this.cName;
    }

    public void setCName(String string) {
        this.cName = string;
        this.fireDataFieldChange();
    }

    public String getCPartemeters() {
        return this.cPartemeters;
    }

    public void setCPartemeters(String string) {
        this.cPartemeters = string;
        this.fireDataFieldChange();
    }

    public String getImplLanguage() {
        return this.implLanguage;
    }

    public void setImplLanguage(String string) {
        if (this.checkImplLanguage(string)) {
            this.implLanguage = string;
            this.fireDataFieldChange();
        }
    }

    public String getIsStatic() {
        return this.isStatic;
    }

    public void setIsStatic(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.isStatic = string;
            this.fireDataFieldChange();
        }
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String string) {
        this.javaName = string;
        this.fireDataFieldChange();
    }

    public String getMethodType() {
        if (((Method)this.getObject()).getReturnValue() != null) {
            return METHOD_TYPES[0];
        }
        return METHOD_TYPES[1];
    }

    public String getPLSQLBody() {
        if (this.isBodyChanged()) {
            return this.PLSQLBody;
        }
        return this.getMethod().getBody();
    }

    public void setPLSQLBody(String string) {
        if (!string.equals(this.getMethod().getBody())) {
            this.PLSQLBody = string;
            this.setBodyChanged(true);
            this.fireDataFieldChange();
        } else {
            this.setBodyChanged(false);
        }
    }

    public String getPragmaClause() {
        return this.pragmaClause;
    }

    public void setPragmaClause(String string) {
        this.pragmaClause = string;
        this.fireDataFieldChange();
    }

    public String getWithContext() {
        return this.withContext;
    }

    public void setWithContext(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.withContext = string;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkImplLanguage(String string) {
        if (languagesSet == null) {
            languagesSet = new HashSet();
            languagesSet.addAll(Arrays.asList(IMPL_LANGUAGES));
        }
        return languagesSet.contains(string);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MethodPropertyDialogOraclev9i methodPropertyDialogOraclev9i = new MethodPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            methodPropertyDialogOraclev9i.show();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

