/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ListStorageTemplatePartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private TableSpaceOracle tablespace = null;
    private String valueList = "Default";
    private String dataSegmentCompression = "";
    private AbstractStorageObjectOracle subPartitionOf;
    private TableProxyOracle partOfStorageTable;
    private StorageObjectCollection lobs;
    public static final String TYPE_NAME = "ListStorageTemplatePartition";

    public ListStorageTemplatePartitionOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.lobs = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("ListStorageTemplatePartitionOracle.LobStorages"));
        this.lobs.setClassForParent(ListStorageTemplatePartitionOracle.class);
        this.lobs.setSetMethod("setListTemplatePartition");
        ((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ListTemplatePart";
    }

    public TableSpaceOracle getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tableSpaceOracle) {
        if (this.tablespace != tableSpaceOracle) {
            this.tablespace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public String getValueList() {
        return this.valueList;
    }

    public void setValueList(String string) {
        if (string != null && string.equals(this.valueList)) {
            return;
        }
        this.valueList = string;
        this.fireDataFieldChange();
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public void setDataSegmentCompression(String string) {
        if (!this.dataSegmentCompression.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.dataSegmentCompression = string;
            this.fireDataFieldChange();
        }
    }

    public void setSubPartitionOf(AbstractStorageObjectOracle abstractStorageObjectOracle) {
        if (this.subPartitionOf != abstractStorageObjectOracle) {
            this.subPartitionOf = abstractStorageObjectOracle;
            if (abstractStorageObjectOracle != null) {
                this.setPAC_Element(abstractStorageObjectOracle.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public AbstractStorageObjectOracle getSubPartitionOf() {
        return this.subPartitionOf;
    }

    public void setPartOfStorageTable(TableProxyOracle tableProxyOracle) {
        if (this.partOfStorageTable != tableProxyOracle) {
            this.partOfStorageTable = tableProxyOracle;
            if (tableProxyOracle != null) {
                this.setPAC_Element(tableProxyOracle);
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getPartOfStorageTable() {
        return this.partOfStorageTable;
    }

    public StorageObjectCollection getLobs() {
        return this.lobs;
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)objectChangeEvent.getAffected();
            if (hashPartitionLobItemOracle.getListTemplatePartition() == this) {
                hashPartitionLobItemOracle.setParent(this.lobs);
                this.lobs.add(hashPartitionLobItemOracle);
            } else {
                this.lobs.remove(hashPartitionLobItemOracle);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof HashPartitionLobItemOracle) {
                HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)modelObjectSetEvent.getAffected();
                hashPartitionLobItemOracle.addObjectListener(this);
                if (hashPartitionLobItemOracle.getListTemplatePartition() == this) {
                    hashPartitionLobItemOracle.setParent(this.lobs);
                    this.lobs.add(hashPartitionLobItemOracle);
                } else {
                    this.lobs.remove(hashPartitionLobItemOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)modelObjectSetEvent.getAffected();
            this.lobs.remove(hashPartitionLobItemOracle);
            hashPartitionLobItemOracle.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.lobs;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)storageDesign).getListStorageTemplatePartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)storageObject;
            }
        } else {
            listStorageTemplatePartitionOracle = ((StorageDesignOracle)storageDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
        }
        if (listStorageTemplatePartitionOracle != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            Object object;
            listStorageTemplatePartitionOracle.setName(this.getName());
            if (this.getPartOfStorageTable() != null) {
                object = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getPartOfStorageTable().getObject().getName());
                storageObject3 = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxyOracle)((TableProxySetOracle)storageDesign.getTableProxySet()).createProxy((DesignObject)object);
                    ((RelationalObjectProxy)storageObject2).setName(this.getPartOfStorageTable().getName());
                    storageObject2.setRawObject(true);
                    listStorageTemplatePartitionOracle.setPartOfStorageTable((TableProxyOracle)storageObject2);
                } else {
                    listStorageTemplatePartitionOracle.setPartOfStorageTable((TableProxyOracle)storageObject3);
                }
            }
            if (this.getSubPartitionOf() != null) {
                object = (PartitionOracle)((StorageDesignOracle)storageDesign).getPartitionSet().getByName(this.getSubPartitionOf().getName());
                if (object == null) {
                    storageObject3 = ((StorageDesignOracle)storageDesign).getPartitionSet().createPartition();
                    storageObject3.setName(this.getSubPartitionOf().getName());
                    storageObject3.setRawObject(true);
                    listStorageTemplatePartitionOracle.setSubPartitionOf((AbstractStorageObjectOracle)storageObject3);
                } else {
                    listStorageTemplatePartitionOracle.setSubPartitionOf((AbstractStorageObjectOracle)object);
                }
            }
            object = this.getLobs().iterator();
            while (object.hasNext()) {
                storageObject3 = (HashPartitionLobItemOracle)object.next();
                storageObject2 = (HashPartitionLobItemOracle)((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    HashPartitionLobItemOracle hashPartitionLobItemOracle = ((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
                    hashPartitionLobItemOracle.setName(storageObject3.getName());
                    hashPartitionLobItemOracle.setRawObject(true);
                    hashPartitionLobItemOracle.setListTemplatePartition(listStorageTemplatePartitionOracle);
                    listStorageTemplatePartitionOracle.getLobs().add(hashPartitionLobItemOracle);
                    continue;
                }
                ((HashPartitionLobItemOracle)storageObject2).setListTemplatePartition(listStorageTemplatePartitionOracle);
                listStorageTemplatePartitionOracle.getLobs().add(storageObject2);
            }
            listStorageTemplatePartitionOracle.setValueList(this.getValueList());
            if (this.getTablespace() != null) {
                storageObject3 = (TableSpaceOracle)((StorageDesignOracle)storageDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (storageObject3 == null) {
                    storageObject2 = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject2).setName(this.getTablespace().getName());
                    storageObject2.setRawObject(true);
                    listStorageTemplatePartitionOracle.setTablespace((TableSpaceOracle)storageObject2);
                } else {
                    listStorageTemplatePartitionOracle.setTablespace((TableSpaceOracle)storageObject3);
                }
            }
            listStorageTemplatePartitionOracle.setDataSegmentCompression(this.getDataSegmentCompression());
            listStorageTemplatePartitionOracle.setComment(this.getComment());
            listStorageTemplatePartitionOracle.setRawObject(false);
        }
    }

    public HashPartitionLobItemOracle createLob() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (HashPartitionLobItemOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> arrayList = new ArrayList<LocalIndexProperties>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().iterator();
        while (iterator.hasNext()) {
            LocalIndexProperties localIndexProperties = (LocalIndexProperties)iterator.next();
            if (localIndexProperties.getPartition() != this || localIndexProperties.getIndex() == null) continue;
            arrayList.add(localIndexProperties);
        }
        return arrayList;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties localIndexProperties = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        localIndexProperties.setPartition(this);
        return localIndexProperties;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16);
    }
}

