/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class HashPartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private PartitionListOracle partitionList = null;
    private AbstractStorageObjectOracle subPartitionOf = null;
    private TableProxyOracle partOfStorageTable;
    private TableSpaceOracle tableSpace = null;
    private TableSpaceOracle iotOverflowTablespace = null;
    private StorageObjectCollection lobitems;
    public static final String TYPE_NAME = "HashPartition";

    public HashPartitionOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.lobitems = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet());
        this.lobitems.setParent(this);
        this.lobitems.setName(Messages.getString("HashPartitionOracle.LobStorages"));
        this.lobitems.setClassForParent(HashPartitionOracle.class);
        this.lobitems.setSetMethod("setHashPartition");
        ((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "HP";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setPartitionList(PartitionListOracle partitionListOracle) {
        if (this.partitionList != partitionListOracle) {
            this.partitionList = partitionListOracle;
            this.fireDataFieldChange();
        }
    }

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public void setSubPartitionOf(AbstractStorageObjectOracle abstractStorageObjectOracle) {
        if (this.subPartitionOf != abstractStorageObjectOracle) {
            this.subPartitionOf = abstractStorageObjectOracle;
            this.fireDataFieldChange();
        }
    }

    public AbstractStorageObjectOracle getSubPartitionOf() {
        return this.subPartitionOf;
    }

    public void setPartOfStorageTable(TableProxyOracle tableProxyOracle) {
        if (this.partOfStorageTable != tableProxyOracle) {
            this.partOfStorageTable = tableProxyOracle;
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getPartOfStorageTable() {
        return this.partOfStorageTable;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setIotOverflowTablespace(TableSpaceOracle tableSpaceOracle) {
        if (this.iotOverflowTablespace != tableSpaceOracle) {
            this.iotOverflowTablespace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getIotOverflowTablespace() {
        return this.iotOverflowTablespace;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof HashPartitionLobItemOracle) {
                HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)modelObjectSetEvent.getAffected();
                hashPartitionLobItemOracle.addObjectListener(this);
                if (hashPartitionLobItemOracle.getHashPartition() != null && hashPartitionLobItemOracle.getHashPartition() == this) {
                    hashPartitionLobItemOracle.setParent(this.lobitems);
                    this.lobitems.add(hashPartitionLobItemOracle);
                } else {
                    this.lobitems.remove(hashPartitionLobItemOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)modelObjectSetEvent.getAffected();
            this.lobitems.remove(hashPartitionLobItemOracle);
            hashPartitionLobItemOracle.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof HashPartitionLobItemOracle) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)objectChangeEvent.getAffected();
            if (hashPartitionLobItemOracle.getHashPartition() != null && hashPartitionLobItemOracle.getHashPartition() == this) {
                hashPartitionLobItemOracle.setParent(this.lobitems);
                this.lobitems.add(hashPartitionLobItemOracle);
            } else {
                this.lobitems.remove(hashPartitionLobItemOracle);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.lobitems;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.lobitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.lobitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageObjectCollection getLobItems() {
        return this.lobitems;
    }

    public StorageObjectCollection getLobs() {
        return this.lobitems;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        HashPartitionOracle hashPartitionOracle = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)storageDesign).getHashPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                hashPartitionOracle = (HashPartitionOracle)storageObject;
            }
        } else {
            hashPartitionOracle = ((StorageDesignOracle)storageDesign).getHashPartitionSet().createHashPartition();
        }
        if (hashPartitionOracle != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            ModelIDObject modelIDObject;
            Object object;
            hashPartitionOracle.setName(this.getName());
            if (this.getPartitionList() != null) {
                object = (PartitionListOracle)((StorageDesignOracle)storageDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (object == null) {
                    modelIDObject = ((StorageDesignOracle)storageDesign).getPartitionListSet().createPartitionList();
                    ((StorageObject)modelIDObject).setName(this.getPartitionList().getName());
                    ((StorageObject)modelIDObject).setRawObject(true);
                    hashPartitionOracle.setPartitionList((PartitionListOracle)modelIDObject);
                } else {
                    hashPartitionOracle.setPartitionList((PartitionListOracle)object);
                }
            }
            object = this.getLobs().iterator();
            while (object.hasNext()) {
                modelIDObject = (HashPartitionLobItemOracle)object.next();
                storageObject3 = (HashPartitionLobItemOracle)((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().getByName(((StorageObject)modelIDObject).getName());
                if (storageObject3 == null) {
                    storageObject2 = ((StorageDesignOracle)storageDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
                    storageObject2.setName(((StorageObject)modelIDObject).getName());
                    storageObject2.setRawObject(true);
                    ((HashPartitionLobItemOracle)storageObject2).setHashPartition(hashPartitionOracle);
                    hashPartitionOracle.getLobs().add(storageObject2);
                    continue;
                }
                ((HashPartitionLobItemOracle)storageObject3).setHashPartition(hashPartitionOracle);
                hashPartitionOracle.getLobs().add(storageObject3);
            }
            if (this.getTableSpace() != null) {
                modelIDObject = (TableSpaceOracle)((StorageDesignOracle)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (modelIDObject == null) {
                    storageObject3 = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject3).setName(this.getTableSpace().getName());
                    storageObject3.setRawObject(true);
                    hashPartitionOracle.setTableSpace((TableSpaceOracle)storageObject3);
                } else {
                    hashPartitionOracle.setTableSpace((TableSpaceOracle)modelIDObject);
                }
            }
            if (this.getIotOverflowTablespace() != null) {
                modelIDObject = (TableSpaceOracle)((StorageDesignOracle)storageDesign).getTableSpaceSet().getByName(this.getIotOverflowTablespace().getName());
                if (modelIDObject == null) {
                    storageObject3 = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject3).setName(this.getIotOverflowTablespace().getName());
                    storageObject3.setRawObject(true);
                    hashPartitionOracle.setIotOverflowTablespace((TableSpaceOracle)storageObject3);
                } else {
                    hashPartitionOracle.setIotOverflowTablespace((TableSpaceOracle)modelIDObject);
                }
            }
            if (this.getSubPartitionOf() != null) {
                modelIDObject = (PartitionOracle)((StorageDesignOracle)storageDesign).getPartitionSet().getByName(this.getSubPartitionOf().getName());
                if (modelIDObject == null) {
                    storageObject3 = ((StorageDesignOracle)storageDesign).getPartitionSet().createPartition();
                    storageObject3.setName(this.getSubPartitionOf().getName());
                    storageObject3.setRawObject(true);
                    hashPartitionOracle.setSubPartitionOf((AbstractStorageObjectOracle)storageObject3);
                } else {
                    hashPartitionOracle.setSubPartitionOf((AbstractStorageObjectOracle)modelIDObject);
                }
            }
            if (this.getPartOfStorageTable() != null) {
                modelIDObject = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getPartOfStorageTable().getObject().getName());
                storageObject3 = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(modelIDObject.getObjectID());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxyOracle)((TableProxySetOracle)((StorageDesignOracle)storageDesign).getTableProxySet()).createProxy((DesignObject)modelIDObject);
                    ((RelationalObjectProxy)storageObject2).setName(this.getPartOfStorageTable().getName());
                    storageObject2.setRawObject(true);
                    hashPartitionOracle.setPartOfStorageTable((TableProxyOracle)storageObject2);
                } else {
                    hashPartitionOracle.setPartOfStorageTable((TableProxyOracle)storageObject3);
                }
            }
            hashPartitionOracle.setComment(this.getComment());
            hashPartitionOracle.setRawObject(false);
        }
    }

    public HashPartitionLobItemOracle createLobItem() {
        if (this.lobitems.getStorageObjectSet() != null) {
            return (HashPartitionLobItemOracle)this.lobitems.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> arrayList = new ArrayList<LocalIndexProperties>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().iterator();
        while (iterator.hasNext()) {
            LocalIndexProperties localIndexProperties = (LocalIndexProperties)iterator.next();
            if (localIndexProperties.getPartition() != this || localIndexProperties.getIndex() == null) continue;
            arrayList.add(localIndexProperties);
        }
        return arrayList;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties localIndexProperties = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        localIndexProperties.setPartition(this);
        return localIndexProperties;
    }

    @Override
    public void setParent(Object object) {
        RepositoryObject repositoryObject;
        super.setParent(object);
        RepositoryObject repositoryObject2 = null;
        if (object instanceof StorageObjectCollection && (repositoryObject2 = (repositoryObject = (RepositoryObject)((StorageObjectCollection)object).getParent()).getPAC_Element()) == null) {
            repositoryObject2 = repositoryObject;
        }
        this.setPAC_Element(repositoryObject2);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append("| ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

