/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.FKPropertyDialogOraclev9i;

public class FKProxyOracle
extends IndexProxy
implements StorageObjectListener {
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static List initiallyList = Arrays.asList(INITIALLY);
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String deferrable = "NO";
    private String rely = "NO";
    private String enable = "YES";
    private String validate = "YES";
    private TableProxyOracle exceptionsTable = null;

    public FKProxyOracle(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return "ForeignKey";
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        this.fireChange(objectChangeEvent);
    }

    public String getColumns() {
        return this.getColumns(null);
    }

    public String getColumns(StorageDesign storageDesign) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (bl) {
                stringBuffer.append(",\n");
            } else {
                bl = true;
            }
            String string = columnProxyArray[i].getName();
            if (storageDesign != null) {
                string = storageDesign.getFormatedName(string);
            } else if (string.indexOf(32) > -1) {
                string = "\"" + string + "\"";
            }
            stringBuffer.append("     ").append(string);
        }
        return stringBuffer.toString();
    }

    public Table getFKTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getReferenceTable() {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(this.getFKTable().getObjectID());
        if (tableProxyOracle != null) {
            return tableProxyOracle.getLongName();
        }
        return "";
    }

    public String getReferenceColumns() {
        return this.getReferenceColumns(null);
    }

    public String getReferenceColumns(StorageDesign storageDesign) {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        Column[] columnArray = (Column[])index.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnArray.length; ++i) {
            if (bl) {
                stringBuffer.append(",\n");
            } else {
                bl = true;
            }
            String string = columnArray[i].getName();
            if (storageDesign != null) {
                string = storageDesign.getFormatedName(string);
            } else if (string.indexOf(32) > -1) {
                string = "\"" + string + "\"";
            }
            stringBuffer.append("     ").append(string);
        }
        return stringBuffer.toString();
    }

    public Column[] getRefColumns() {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        return (Column[])index.getElements();
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String string) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(FKProxyOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(string);
    }

    public void setInitially(String string) {
        if (this.checkInitially(string)) {
            this.initially = string;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setRely(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.rely = string;
            this.fireDataFieldChange();
        }
    }

    public String getRely() {
        return this.rely;
    }

    public void setDeferrable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.deferrable = string;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.enable = string;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.validate = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle tableProxyOracle) {
        this.exceptionsTable = tableProxyOracle;
        this.fireDataFieldChange();
    }

    public static List getInitiallyValues() {
        return initiallyList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogOraclev9i fKPropertyDialogOraclev9i = new FKPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            fKPropertyDialogOraclev9i.show();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            string = index.getFKAssociation().getName();
        }
        string = this.applyNameSubstitution(string);
        return string;
    }
}

