/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DimensionOraclev9iPropertyDialog;

public class DimensionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private UserOracle user;
    private StorageObjectCollection levels;
    private StorageObjectCollection hierarchies;
    public static final String TYPE_NAME = "Dimension";

    public DimensionOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
        this.levels = new StorageObjectCollection(storageDesignOracle.getLevelSet());
        this.levels.setParent(this);
        this.levels.setName(Messages.getString("DimensionOracle.Levels"));
        this.levels.setSetMethod("setDimension");
        this.levels.setClassForParent(DimensionOracle.class);
        this.levels.setIcon(GUIConfiguration.getInstance().getIcon("LEVEL_ICON", 16));
        ((StorageDesignOracle)storageDesign).getLevelSet().addSetListener(this);
        this.addLevelsFromDesign(((StorageDesignOracle)storageDesign).getLevelSet());
        this.hierarchies = new StorageObjectCollection(storageDesignOracle.getHierarchySet());
        this.hierarchies.setParent(this);
        this.hierarchies.setName(Messages.getString("DimensionOracle.Hierarchies"));
        this.hierarchies.setSetMethod("setDimension");
        this.hierarchies.setClassForParent(DimensionOracle.class);
        this.hierarchies.setIcon(GUIConfiguration.getInstance().getIcon("HIERARCHY_ICON", 16));
        ((StorageDesignOracle)storageDesign).getHierarchySet().addSetListener(this);
        this.addHierarchiesFromDesign(((StorageDesignOracle)storageDesign).getHierarchySet());
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.levels;
            }
            case 1: {
                return this.hierarchies;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.levels) {
            return 0;
        }
        if (modelObject == this.hierarchies) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.levels) {
            return 0;
        }
        if (object == this.hierarchies) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.levels.removeAll();
        this.hierarchies.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof LevelOracle) {
                LevelOracle levelOracle = (LevelOracle)modelObjectSetEvent.getAffected();
                levelOracle.addObjectListener(this);
                if (levelOracle.getDimension() == this) {
                    levelOracle.setParent(this.levels);
                    this.levels.add(levelOracle);
                } else {
                    this.levels.remove(levelOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof HierarchyOracle) {
                HierarchyOracle hierarchyOracle = (HierarchyOracle)modelObjectSetEvent.getAffected();
                hierarchyOracle.addObjectListener(this);
                if (hierarchyOracle.getDimension() == this) {
                    hierarchyOracle.setParent(this.hierarchies);
                    this.hierarchies.add(hierarchyOracle);
                } else {
                    this.hierarchies.remove(hierarchyOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof LevelOracle) {
                LevelOracle levelOracle = (LevelOracle)modelObjectSetEvent.getAffected();
                this.levels.remove(levelOracle);
                levelOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof HierarchyOracle) {
                HierarchyOracle hierarchyOracle = (HierarchyOracle)modelObjectSetEvent.getAffected();
                this.hierarchies.remove(hierarchyOracle);
                hierarchyOracle.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof LevelOracle) {
            LevelOracle levelOracle = (LevelOracle)objectChangeEvent.getAffected();
            if (levelOracle.getDimension() == this) {
                levelOracle.setParent(this.levels);
                this.levels.add(levelOracle);
            } else {
                this.levels.remove(levelOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof HierarchyOracle) {
            HierarchyOracle hierarchyOracle = (HierarchyOracle)objectChangeEvent.getAffected();
            if (hierarchyOracle.getDimension() == this) {
                hierarchyOracle.setParent(this.hierarchies);
                this.hierarchies.add(hierarchyOracle);
            } else {
                this.hierarchies.remove(hierarchyOracle);
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DimensionOraclev9iPropertyDialog dimensionOraclev9iPropertyDialog = new DimensionOraclev9iPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dimensionOraclev9iPropertyDialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Dim";
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        if (this.user != userOracle) {
            this.user = userOracle;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public Object[] getLevelSet() {
        ArrayList<LevelOracle> arrayList = new ArrayList<LevelOracle>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getLevelSet().iterator();
        LevelOracle levelOracle = null;
        while (iterator.hasNext()) {
            levelOracle = (LevelOracle)iterator.next();
            if (levelOracle.getDimension() != this) continue;
            arrayList.add(levelOracle);
        }
        return arrayList.toArray();
    }

    public StorageObjectCollection getLevelCollection() {
        return this.levels;
    }

    public LevelOracle createLevel() {
        if (this.levels.getStorageObjectSet() != null) {
            return (LevelOracle)this.levels.createElement(null);
        }
        return null;
    }

    public Object[] getHierarchySet() {
        ArrayList<HierarchyOracle> arrayList = new ArrayList<HierarchyOracle>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getHierarchySet().iterator();
        HierarchyOracle hierarchyOracle = null;
        while (iterator.hasNext()) {
            hierarchyOracle = (HierarchyOracle)iterator.next();
            if (hierarchyOracle.getDimension() != this) continue;
            arrayList.add(hierarchyOracle);
        }
        return arrayList.toArray();
    }

    public StorageObjectCollection getHierarchyCollection() {
        return this.hierarchies;
    }

    public HierarchyOracle createHierarchy() {
        if (this.hierarchies.getStorageObjectSet() != null) {
            return (HierarchyOracle)this.hierarchies.createElement(null);
        }
        return null;
    }

    public Object[] getAttributeSet() {
        return this.getAttributeList().toArray();
    }

    public List getAttributeList() {
        ArrayList<DimensionAttributeOracle> arrayList = new ArrayList<DimensionAttributeOracle>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getDimensionAttributeSet().iterator();
        DimensionAttributeOracle dimensionAttributeOracle = null;
        while (iterator.hasNext()) {
            dimensionAttributeOracle = (DimensionAttributeOracle)iterator.next();
            if (dimensionAttributeOracle.getDimension() != this) continue;
            arrayList.add(dimensionAttributeOracle);
        }
        return arrayList;
    }

    public DimensionAttributeOracle createAttribute() {
        DimensionAttributeOracle dimensionAttributeOracle = ((StorageDesignOracle)this.getStorageDesign()).getDimensionAttributeSet().createDimensionAttribute();
        dimensionAttributeOracle.setDimension(this);
        return dimensionAttributeOracle;
    }

    public void addLevelsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            LevelOracle levelOracle = (LevelOracle)iterator.next();
            levelOracle.addObjectListener(this);
            if (levelOracle.getDimension() == this) {
                levelOracle.setParent(this.levels);
                this.levels.add(levelOracle);
                continue;
            }
            this.levels.remove(levelOracle);
        }
    }

    public void addHierarchiesFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            HierarchyOracle hierarchyOracle = (HierarchyOracle)iterator.next();
            hierarchyOracle.addObjectListener(this);
            if (hierarchyOracle.getDimension() == this) {
                hierarchyOracle.setParent(this.hierarchies);
                this.hierarchies.add(hierarchyOracle);
                continue;
            }
            this.hierarchies.remove(hierarchyOracle);
        }
    }

    public LevelOracle getLevelByName(String string) {
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getLevelSet().iterator();
        LevelOracle levelOracle = null;
        while (iterator.hasNext()) {
            levelOracle = (LevelOracle)iterator.next();
            if (levelOracle.getDimension() != this || !levelOracle.getName().equalsIgnoreCase(string)) continue;
            return levelOracle;
        }
        return null;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DIMENSION_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        Object[] objectArray = this.getAttributeSet();
        for (int i = 0; i < objectArray.length; ++i) {
            ((StorageObject)objectArray[i]).remove();
        }
        this.levels.removeAll();
        this.hierarchies.removeAll();
    }
}

