/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DimensionAttributePropertyDialogOraclev9i;

public abstract class DimensionAttributeOracle
extends AbstractStorageObjectOracle {
    private String columns = "";
    private InlineList columnSet = null;
    private LevelOracle level;
    private DimensionOracle dimension;
    public static final String TYPE_NAME = "DimenAttr";
    public static final String OLD_TYPE_NAME = "DimensionAttr";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DimensionAttributePropertyDialogOraclev9i dimensionAttributePropertyDialogOraclev9i = new DimensionAttributePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dimensionAttributePropertyDialogOraclev9i.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Attr";
    }

    private void addColumn(String string) {
        if (!this.getColumnSet().contains(string)) {
            this.getColumnSet().add(string);
        }
    }

    public void recreateColumnSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(string);
        } else {
            this.addColumn(string);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public InlineList getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new InlineList();
        }
        return this.columnSet;
    }

    public void clearColumns() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public DimensionOracle getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionOracle dimensionOracle) {
        if (this.dimension != dimensionOracle) {
            this.dimension = dimensionOracle;
            this.setPAC_Element(dimensionOracle);
            this.fireDataFieldChange();
        }
    }

    public LevelOracle getLevel() {
        return this.level;
    }

    public void setLevel(LevelOracle levelOracle) {
        this.level = levelOracle;
        if (levelOracle.getDimension() != null) {
            this.dimension = levelOracle.getDimension();
            this.setPAC_Element(this.dimension);
        }
        this.fireDataFieldChange();
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(",");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

